#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2015.9.25

Chopper
'''

from conf.constants import *

# user defined

from model.readData import *
from model.chopperModel import *
from canvas import *

import random


class CSNSChopperPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSChopperPage, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, Widget):
	self.horizontalLayout = QtGui.QHBoxLayout(self)

	# chopper tab control

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaLeft = QtGui.QScrollArea()
        self.scrollAreaLeft.setWidgetResizable(True)
        self.scrollAreaLeft.setWidget(self.first)

        # left grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        # left grid label

        self.timeframeLabel = QtGui.QLabel('Time Frame')

        # canvas for time frame

        self.timeframeCanvas = CSNSCanvas(
            self,
            8,
            4,
            150,
            xlabel='Time of Flight (ms)',
            ylabel='Distance (m)',
            )
        self.timeframeCanvas.fig.subplots_adjust(left=0.12,
                bottom=0.15, right=0.95, top=0.9)
        self.timeframeCanvas.setParent(self.first)
        self.timeframeCanvas.ax.get_yaxis().set_visible(False)
        self.timeframeCanvas.ax2 = self.timeframeCanvas.ax.twiny()
        self.timeframeCanvas.ax2.tick_params(axis='x', which='major',
                labelsize=5)

        # canvas for monitor 1

        self.monitor1Canvas = CSNSCanvas(
            self,
            4,
            4,
            150,
            xlabel='Wavelength (AA)',
            ylabel='Intensity',
            )
        self.monitor1Canvas.setParent(self.first)
        self.monitor1Canvas.ax.set_xlim(0, 20)

        self.monitor1Canvas.ax.yaxis.set_major_formatter(ticker.FormatStrFormatter('%3.1E'
                ))
        (nmoderator, dataModerator) = CSNSRead2DData('./dat/DPHM.dat')
        wavemin = 1.0
        wavemax = 4.0
        imin = min(dataModerator[0], key=lambda x: abs(x - wavemin))
        imax = min(dataModerator[0], key=lambda x: abs(x - wavemax))
        imin = dataModerator[0].index(imin)
        imax = dataModerator[0].index(imax)
        self.monitor1Canvas.ax.plot(dataModerator[0],
                                    np.array(dataModerator[1]) / 1E5,
                                    color='blue')

        self.monitor1Canvas.ax.vlines((dataModerator[0])[imin:imax], 0,
                np.array((dataModerator[1])[imin:imax]) / 1E5,
                color='yellow')

        self.monitor1Canvas.fig.subplots_adjust(left=0.20, bottom=0.20,
                right=0.95, top=0.95)

        # canvas for monitor 2

        self.monitor2Canvas = CSNSCanvas(self, 4, 4,
                xlabel='Wavelength (AA)', ylabel='Neutron Counts')

        # read monitor data
        # self.monitor2Axes.yaxis.set_major_formatter(ticker.FormatStrFormatter('%3.1E'))

        (nmonitor, dataMonitor) = CSNSRead2DData('./dat/monitor.dat')
        self.monitor2Canvas.ax.plot(dataMonitor[0], dataMonitor[1],
                                    color='green', zorder=1)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.monitor2Canvas.ax.add_patch(self.rect)
        self.monitor2Canvas.fig.subplots_adjust(left=0.20, bottom=0.20,
                right=0.95, top=0.95)
        self.zoomEvents()

        self.mainGrid.addWidget(self.timeframeLabel, 0, 0, 1, 1)  # ,QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(
            self.timeframeCanvas,
            1,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.monitor1Canvas,
            2,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.monitor2Canvas,
            2,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaRight = QtGui.QScrollArea()
        self.scrollAreaRight.setWidgetResizable(True)
        self.scrollAreaRight.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaRight1 = QtGui.QScrollArea()
        self.scrollAreaRight1.setWidgetResizable(True)
        self.scrollAreaRight1.setWidget(self.third)

        self.rightUpGrid = QtGui.QGridLayout(self.second)
        self.rightDownGrid = QtGui.QGridLayout(self.third)

        # Wavelenghth

        self.waveLengthLabel = \
            QtGui.QLabel('<font color=red>Wavelength:</font>',
                         self.second)
        self.frequencyLabel = QtGui.QLabel('Frequency:', self.second)
        self.frequencyComboBox = QtGui.QComboBox(self.second)
        self.frequencyComboBox.addItem('25')
        self.frequencyComboBox.addItem('25/2')
        self.frequencyComboBox.addItem('25/3')
        self.frequencyComboBox.addItem('25/4')
        self.frequencyComboBox.addItem('25/5')
        self.frequencyComboBox.addItem('open')
        self.frequencyComboBox.addItem('close')
        self.frequencyComboBox.setSizePolicy(QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Fixed)
        self.minimumLabel = QtGui.QLabel('Minimum:', self.second)
        self.waveminTextEdit = QtGui.QTextEdit('0.1', self.second)

        # self.waveminTextEdit.setReadOnly(True)

        self.waveminTextEdit.setMaximumHeight(CSNStextMaximumHeight)
        self.maximumLabel = QtGui.QLabel('Maximum:', self.second)
        self.wavemaxTextEdit = QtGui.QTextEdit('4.0', self.second)
        self.wavemaxTextEdit.setReadOnly(True)
        self.wavemaxTextEdit.setMaximumHeight(CSNStextMaximumHeight)

        self.cancelButton1 = QtGui.QPushButton('Reset', self.second)

        self.okButton1 = QtGui.QPushButton('OK', self.second)
        self.okButton1.clicked.connect(self.wavelengthSet)

        # for DC1

        self.dc1Label = QtGui.QLabel('<font color=red>DC1</font>',
                self.third)

        self.dc1FrequencyLabel = QtGui.QLabel('Frequency', self.third)

        self.dc1FrequencyComboBox = QtGui.QComboBox(self.third)
        self.dc1FrequencyComboBox.addItem('25')
        self.dc1FrequencyComboBox.addItem('25/2')
        self.dc1FrequencyComboBox.addItem('25/3')
        self.dc1FrequencyComboBox.addItem('25/4')
        self.dc1FrequencyComboBox.addItem('25/5')
        self.dc1FrequencyComboBox.addItem('open')
        self.dc1FrequencyComboBox.addItem('close')
        self.dc1FrequencyComboBox.setSizePolicy(QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Fixed)

        self.dc1PhaseLabel = QtGui.QLabel('Phase', self.third)

        self.dc1PhaseSpinBox = QtGui.QSpinBox(self.third)
        self.dc1PhaseSpinBox.setRange(-360, 360)
        self.dc1PhaseSpinBox.setSingleStep(1)

        # for DC2

        self.dc2Label = QtGui.QLabel('<font color=red>DC2</font>',
                self.third)

        self.dc2FrequencyLabel = QtGui.QLabel('Frequency', self.third)

        self.dc2FrequencyComboBox = QtGui.QComboBox(self.third)
        self.dc2FrequencyComboBox.addItem('25')
        self.dc2FrequencyComboBox.addItem('25/2')
        self.dc2FrequencyComboBox.addItem('25/3')
        self.dc2FrequencyComboBox.addItem('25/4')
        self.dc2FrequencyComboBox.addItem('25/5')
        self.dc2FrequencyComboBox.addItem('open')
        self.dc2FrequencyComboBox.addItem('close')

        self.dc2PhaseLabel = QtGui.QLabel('Phase', self.third)

        self.dc2PhaseSpinBox = QtGui.QSpinBox(self.third)
        self.dc2PhaseSpinBox.setRange(-360, 360)
        self.dc2PhaseSpinBox.setSingleStep(1)

        # for DC3

        self.dc3Label = QtGui.QLabel('<font color=red>DC3</font>',
                self.third)

        self.dc3FrequencyLabel = QtGui.QLabel('Frequency', self.third)

        self.dc3FrequencyComboBox = QtGui.QComboBox(self.third)
        self.dc3FrequencyComboBox.addItem('25')
        self.dc3FrequencyComboBox.addItem('25/2')
        self.dc3FrequencyComboBox.addItem('25/3')
        self.dc3FrequencyComboBox.addItem('25/4')
        self.dc3FrequencyComboBox.addItem('25/5')
        self.dc3FrequencyComboBox.addItem('open')
        self.dc3FrequencyComboBox.addItem('close')

        self.dc3PhaseLabel = QtGui.QLabel('Phase', self.third)

        self.dc3PhaseSpinBox = QtGui.QSpinBox(self.third)
        self.dc3PhaseSpinBox.setRange(-360, 360)
        self.dc3PhaseSpinBox.setSingleStep(1)

        # for button

        self.cancelButton2 = QtGui.QPushButton('Reset', self.third)

        self.okButton2 = QtGui.QPushButton('OK', self.third)

        # self.okButton2.clicked.connect(self.waveLength)

        self.okButton2.clicked.connect(self.chopperSet)

        nrow = -1
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.waveLengthLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.frequencyLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(self.frequencyComboBox, nrow, 0, 1,
                                   2)
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.minimumLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.waveminTextEdit,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.maximumLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.wavemaxTextEdit,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.cancelButton1,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.rightUpGrid.addWidget(
            self.okButton1,
            nrow,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )

        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc1Label,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc1FrequencyLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc1FrequencyComboBox, nrow,
                0, 1, 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc1PhaseLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc1PhaseSpinBox, nrow, 0, 1,
                2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc2Label,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc2FrequencyLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc2FrequencyComboBox, nrow,
                0, 1, 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc2PhaseLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc2PhaseSpinBox, nrow, 0, 1,
                2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc3Label,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc3FrequencyLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc3FrequencyComboBox, nrow,
                0, 1, 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc3PhaseLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc3PhaseSpinBox, nrow, 0, 1,
                2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.cancelButton2,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.rightDownGrid.addWidget(
            self.okButton2,
            nrow,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addItem(QtGui.QSpacerItem(-1, -1,
                                   QtGui.QSizePolicy.Ignored,
                                   QtGui.QSizePolicy.Expanding), nrow,
                                   0)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal)
        self.splitterRight = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitterRight.addWidget(self.scrollAreaRight)
        self.splitterRight.addWidget(self.scrollAreaRight1)
        self.splitter.addWidget(self.scrollAreaLeft)
        self.splitter.addWidget(self.splitterRight)
        self.splitterRight.setSizes([220, 380])
        self.splitter.setSizes([550, 150])
        self.horizontalLayout.addWidget(self.splitter)

        self.ini()

    def ini(self):
        _frequency = 25.0
        _lambdaMin = 0.8
        _tfvalue = TimeFrameModel()
        (frequency, lambdaMin, lambdaMax) = \
            _tfvalue.fromWavelength(frequency=_frequency,
                                    lambdaMin=_lambdaMin)

        (
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            ) = _tfvalue.ChopperCalculation(frequency, lambdaMin,
                    lambdaMax)

        (
            pulseList,
            chopperList,
            samplePosition,
            timeList,
            xList,
            yList,
            ) = _tfvalue.TimeFrameCalculation(
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            )

        self.updateChopperSetting(
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            )
        self.updateWavelengthSetting(frequency, lambdaMin, lambdaMax)
        self.plotTimeFrame(
            pulseList,
            chopperList,
            samplePosition,
            timeList,
            xList,
            yList,
            )

    def wavelengthSet(self):
        frequency = float(self.frequencyComboBox.currentText())
        lambdaMin = float(self.waveminTextEdit.toPlainText())

        # lambdaMax = float(self.wavemaxTextEdit.toPlainText())

        self.tfvalue = TimeFrameModel()
        (frequency, lambdaMin, lambdaMax) = \
            self.tfvalue.fromWavelength(frequency=frequency,
                lambdaMin=lambdaMin)
        self.updateWavelengthSetting(frequency, lambdaMin, lambdaMax)

        (
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            ) = self.tfvalue.ChopperCalculation(frequency, lambdaMin,
                    lambdaMax)

        (
            pulseList,
            chopperList,
            samplePosition,
            timeList,
            xList,
            yList,
            ) = self.tfvalue.TimeFrameCalculation(
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            )

        self.plotTimeFrame(
            pulseList,
            chopperList,
            samplePosition,
            timeList,
            xList,
            yList,
            )

        self.updateChopperSetting(
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            )

        self.updateMonitor1()

    def chopperSet(self):
        _frequency = [
            25,
            25 / 2.0,
            25 / 3.0,
            25 / 4.0,
            25 / 5.0,
            1,
            0,
            ]
        dc1Phase = self.dc1PhaseSpinBox.value()
        dc2Phase = self.dc2PhaseSpinBox.value()
        dc3Phase = self.dc3PhaseSpinBox.value()
        dc1Frequency = \
            _frequency[self.dc1FrequencyComboBox.currentIndex()]
        dc2Frequency = \
            _frequency[self.dc2FrequencyComboBox.currentIndex()]
        dc3Frequency = \
            _frequency[self.dc3FrequencyComboBox.currentIndex()]

        self.tfvalue = TimeFrameModel()
        (frequency, lambdaMin, lambdaMax) = self.tfvalue.fromChopper(
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            )

        (
            pulseList,
            chopperList,
            samplePosition,
            timeList,
            xList,
            yList,
            ) = self.tfvalue.TimeFrameCalculation(
            dc1Frequency,
            dc2Frequency,
            dc3Frequency,
            dc1Phase,
            dc2Phase,
            dc3Phase,
            )
        self.plotTimeFrame(
            pulseList,
            chopperList,
            samplePosition,
            timeList,
            xList,
            yList,
            )

        self.updateWavelengthSetting(frequency, lambdaMin, lambdaMax)

        self.updateMonitor1()

    def updateWavelengthSetting(
        self,
        frequency,
        lambdaMin,
        lambdaMax,
        ):
        _frequency = [
            25,
            25 / 2.0,
            25 / 3.0,
            25 / 4.0,
            25 / 5.0,
            0.0,
            ]
        _idx = min(_frequency, key=lambda x: abs(x - frequency))
        _idx = _frequency.index(_idx)
        self.frequencyComboBox.setCurrentIndex(_idx)

        self.waveminTextEdit.setText(str(lambdaMin))
        self.wavemaxTextEdit.setText(str(lambdaMax))

    def updateChopperSetting(
        self,
        DC1frequency,
        DC2frequency,
        DC3frequency,
        DC1phase,
        DC2phase,
        DC3phase,
        ):
        frequency = [
            25,
            25 / 2.0,
            25 / 3.0,
            25 / 4.0,
            25 / 5.0,
            0.0,
            ]
        dc1Frequency = min(frequency, key=lambda x: abs(x
                           - DC1frequency))
        dc1Frequency = frequency.index(dc1Frequency)

        dc2Frequency = min(frequency, key=lambda x: abs(x
                           - DC2frequency))
        dc2Frequency = frequency.index(dc2Frequency)

        dc3Frequency = min(frequency, key=lambda x: abs(x
                           - DC3frequency))
        dc3Frequency = frequency.index(dc3Frequency)

        self.dc1PhaseSpinBox.setValue(int(DC1phase))
        self.dc2PhaseSpinBox.setValue(int(DC2phase))
        self.dc3PhaseSpinBox.setValue(int(DC3phase))
        self.dc1FrequencyComboBox.setCurrentIndex(dc1Frequency)
        self.dc2FrequencyComboBox.setCurrentIndex(dc2Frequency)
        self.dc3FrequencyComboBox.setCurrentIndex(dc3Frequency)

    def plotTimeFrame(
        self,
        pulseList,
        chopperList,
        samplePosition,
        timeList,
        xList,
        yList,
        ):

        self.timeframeCanvas.ax.clear()
        self.timeframeCanvas.ax.YTick = chopperList

        _x = pulseList[0] - (pulseList[1] - pulseList[0]) / 6.0

        self.timeframeCanvas.ax.text(_x, chopperList[0], 'DC1',
                fontsize=5)
        self.timeframeCanvas.ax.text(_x, chopperList[1], 'DC2',
                fontsize=5)
        self.timeframeCanvas.ax.text(_x, chopperList[2], 'DC3',
                fontsize=5)
        self.timeframeCanvas.ax.text(_x, samplePosition, 'Sample',
                fontsize=5)

        for i in range(len(timeList)):
            _Npoint = len(timeList[i])
            for j in range(0, int(int(_Npoint / 2.0) * 2), 2):
                self.timeframeCanvas.ax.plot((timeList[i][j],
                        timeList[i][j + 1]), (chopperList[i],
                        chopperList[i]), color='black')

        _Ngroup = len(xList)
        for i in range(0, _Ngroup):
            if i % 2 == 0:
                _R = random.uniform(0, 1)
                _G = random.uniform(0, 1)
                _B = random.uniform(0, 1)
            self.timeframeCanvas.ax.plot(xList[i], yList, color=[_R,
                    _G, _B])

        self.timeframeCanvas.ax.set_xlim((pulseList[0], pulseList[-1]))
        self.timeframeCanvas.ax.xaxis.set_major_formatter(ticker.FormatStrFormatter('%d'
                ))
        self.timeframeCanvas.ax.set_xticks(np.arange(0, pulseList[-1]
                + 40, 40))

        _npulse = len(pulseList)
        _x2 = []
        _y2 = []
        for i in range(_npulse):
            _y2.append(samplePosition)
            _x2.append(2 * 1000 * pulseList[i] / 505.55
                       / samplePosition)

        _y2.append(samplePosition)
        _x2.append(2 * 1000 * (pulseList[i] + 40) / 505.55
                   / samplePosition)
        self.timeframeCanvas.ax2.plot(_x2, _y2, 'b')
        self.timeframeCanvas.ax2.set_xticks(np.arange(0, _x2[-1], 5))

        self.timeframeCanvas.draw()

    def updateMonitor1(self):
        self.monitor1Canvas.ax.clear()
        self.monitor1Canvas.ax.set_xlim(0, 20)
        self.monitor1Canvas.ax.yaxis.set_major_formatter(ticker.FormatStrFormatter('%3.1E'
                ))
        (nmoderator, dataModerator) = CSNSRead2DData('./dat/DPHM.dat')

        self.wavemin = float(self.waveminTextEdit.toPlainText())
        self.wavemax = float(self.wavemaxTextEdit.toPlainText())

        self.iminidx = min(dataModerator[0], key=lambda x: abs(x
                           - self.wavemin))
        self.imaxidx = min(dataModerator[0], key=lambda x: abs(x
                           - self.wavemax))
        self.imin = dataModerator[0].index(self.iminidx)
        self.imax = dataModerator[0].index(self.imaxidx)
        self.monitor1Canvas.ax.plot(dataModerator[0],
                                    np.array(dataModerator[1]) / 1E5,
                                    color='red')
        self.monitor1Canvas.ax.vlines((dataModerator[0])[self.imin:self.imax],
                0, np.array((dataModerator[1])[self.imin:self.imax])
                / 1E5, color='yellow')
        self.monitor1Canvas.draw()

    def zoomEvents(self):
        self.monitor2Canvas.mpl_connect('button_press_event',
                self.zoomFigurePress)
        self.monitor2Canvas.mpl_connect('button_release_event',
                self.zoomFigureRelease)
        self.monitor2Canvas.mpl_connect('motion_notify_event',
                self.zoomFigureMove)

    def zoomFigurePress(self, event):
        if event.button == 1:
            self.zoomClick = True
            self.x0 = event.xdata
            self.y0 = event.ydata
        elif event.button == 3:
            self.monitor2Canvas.ax.autoscale(enable=True)
            self.monitor2Canvas.draw()
        else:
            return

    def zoomFigureMove(self, event):
        if event.button == 1 and self.zoomClick == True and self.x0 \
            and self.y0 and event.xdata and event.ydata:

            self.rect.set_width(event.xdata - self.x0)
            self.rect.set_height(event.ydata - self.y0)
            self.rect.set_xy((self.x0, self.y0))
            self.monitor2Canvas.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick = False

        if event.button == 1 and self.x0 and self.y0 and event.xdata \
            and event.ydata:
            self.x1 = event.xdata
            self.y1 = event.ydata

            self.rect.set_width(0)
            self.rect.set_height(0)

            _min = min(self.x0, self.x1)
            _max = max(self.x0, self.x1)
            self.monitor2Canvas.ax.set_xlim(_min, _max)
            _min = min(self.y0, self.y1)
            _max = max(self.y0, self.y1)
            self.monitor2Canvas.ax.set_ylim(_min, _max)
            self.monitor2Canvas.draw()
        else:
            return


