#!/usr/bin/python
# -*- coding: utf-8 -*-

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

from conf.constants import *
import json

from conf import *

from viewer.mainTab import *
from viewer.subTab import *


class CSNSMainSetInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSMainSetInfo, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.upRightTab = CSNSMainTab(self)
        self.timeProgress = QtGui.QProgressBar(self)
        self.downRightTab = CSNSSubTab(self)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)

        self.splitter.addWidget(self.upRightTab)
        self.splitter.addWidget(self.timeProgress)
        self.splitter.addWidget(self.downRightTab)
        self.splitter.setSizes([450, 10, 20])
        self.verticalLayout.addWidget(self.splitter)

    # time Progress Thread

        self.timeProgressThread = updateProgressBar(121, 1, 3600)
        self.timeProgressThread.partDone.connect(self.updateTimeProgress)
        self.timeProgressThread.procDone.connect(self.fin)
        self.timeProgressThread.start()

    def updateTimeProgress(self, val):
        self.timeProgress.setValue(val)
        perct = '{0}%'.format(val)

    def fin(self):
        pass

    def getNeutronCanvas(self):
        return self.upRightTab.getNeutronCanvas()

    def getImageCanvas(self):
        return self.upRightTab.getImageCanvas()


