#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from PyQt4 import QtCore, QtGui
import histogramDock


class CSNSHistogramPage(QtGui.QMainWindow):

    def __init__(self, parent):
        super(CSNSHistogramPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        # self.setTabPosition(QTabWidget.West)

        self.patternDock=[]
        self.patternDock.append(histogramDock.histogramDock(self,
                9, 0.4, 'r', 4000, 'Backward Bank'))
        self.patternDock.append(histogramDock.histogramDock(self,
                9, 0.4, 'g', 3000, 'Medium-Angle Bank'))
        self.patternDock.append(histogramDock.histogramDock(self,
                9, 0.4, 'b', 2000, 'Low-Angle Bank'))

        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[0])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[1])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[2])

    def getPatternCanvas(self, n):
        return self.patternDock[n].getImageCanvas()
