#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Created on 2015.10.10

Histogram

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *


class CSNSHistogramPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSHistogramPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        # Backward TOF/d

        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem('TOF')
        self.BackwardComboBox.addItem('d')
        self.filexy = ['img/XY ++.png', 'img/XY +-.png']
        self.filext = ['img/XT ++.png', 'img/XT +-.png']
        _index = self.BackwardComboBox.currentIndex()

        _xsize = 5
        _ysize = 0.8

        # Backward

        self.BackwardLabel = QtGui.QLabel('Backward')
        self.CountBackwardLabel = QtGui.QLabel('Count')

        self.BackwardImageCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.BackwardImage = \
            self.BackwardImageCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.BackwardImageCanvas.ax.add_patch(self.rect)
        self.BackwardImageCanvas.fig.subplots_adjust(left=0.12,
                bottom=0.15, right=0.95, top=0.95)
        self.BackwardImageCanvas.ax.set_xlabel('Vertical', fontsize=5)
        self.BackwardImageCanvas.ax.set_ylabel('Horizental', fontsize=5)
        self.BackwardImageCanvas.draw()

        # 90-Bank TOF/d

        self.BankComboBox = QtGui.QComboBox()
        self.BankComboBox.addItem('TOF')
        self.BankComboBox.addItem('d')
        self.filexy = ['img/XY ++.png', 'img/XY +-.png']
        self.filext = ['img/XT ++.png', 'img/XT +-.png']
        _index = self.BankComboBox.currentIndex()

        # 90-Bank

        self.BankLabel = QtGui.QLabel('90 Bank')
        self.CountBankLabel = QtGui.QLabel('Count')
        self.BankCanvas = CSNSCanvas(self, _xsize, _ysize)

        (nx, dataX) = CSNSRead2DData('./dat/monitor.dat')
        self.BankCanvas.ax.plot(dataX[0], dataX[1], color='red')
        self.BankCanvas.ax.tick_params(axis='both', which='major',
                labelsize=5)
        self.BankCanvas.fig.subplots_adjust(left=0.12, bottom=0.15,
                right=0.95, top=0.95)
        self.BankCanvas.ax.set_xlabel('Vertical', fontsize=5)
        self.BankCanvas.ax.set_ylabel('Horizental', fontsize=5)
        self.BankCanvas.draw()

        # Small-angle bank TOF/d

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('TOF')
        self.SmallComboBox.addItem('d')
        self.filexy = ['img/XY ++.png', 'img/XY +-.png']
        self.filext = ['img/XT ++.png', 'img/XT +-.png']
        _index = self.SmallComboBox.currentIndex()

        # Small-angle bank

        self.SmallLabel = QtGui.QLabel('Small-angle bank')
        self.CountSmallLabel = QtGui.QLabel('Count')
        self.SmallCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxtX, self.dataxtY, self.dataxtZ) = \
            CSNSReadImage2Matrix(self.filext[_index], 1, 0.4)
        self.SmallImage = self.SmallCanvas.ax.pcolormesh(self.dataxtY,
                self.dataxtX, self.dataxtZ, cmap=cm.hot)
        self.SmallCanvas.fig.subplots_adjust(left=0.12, bottom=0.15,
                right=0.95, top=0.95)
        self.SmallCanvas.ax.set_xlabel('Vertical', fontsize=5)
        self.SmallCanvas.ax.set_ylabel('Horizental', fontsize=5)
        self.SmallCanvas.draw()

        # Monitor TOF/d

        self.MonitorComboBox = QtGui.QComboBox()
        self.MonitorComboBox.addItem('TOF')
        self.MonitorComboBox.addItem('d')
        self.filexy = ['img/XY ++.png', 'img/XY +-.png']
        self.filext = ['img/XT ++.png', 'img/XT +-.png']
        _index = self.MonitorComboBox.currentIndex()

        # Monitor

        self.MonitorLabel = QtGui.QLabel('Monitor')
        self.CountMonitorLabel = QtGui.QLabel('Count')
        self.MonitorCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.dataXTx = []
        for i in range(1, self.dataxtY.shape[0]):
            self.dataXTx.append(self.dataxtY[0][i])
        self.dataXTy = []
        for i in range(1, self.dataxtX.shape[0]):
            self.dataXTy.append(self.dataxtX[i][0])

        self.MonitorFigure = self.MonitorCanvas.ax.plot(self.dataXTx,
                (self.dataxtZ[40])[:], color='red')
        self.MonitorCanvas.fig.subplots_adjust(left=0.12, bottom=0.15,
                right=0.95, top=0.95)
        self.MonitorCanvas.ax.set_xlabel('Vertical', fontsize=5)
        self.MonitorCanvas.ax.set_ylabel('Horizental', fontsize=5)
        self.MonitorCanvas.draw()

        self.mainGrid.addWidget(
            self.BackwardLabel,
            0,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountBackwardLabel, 0, 0, 1, 1)
        self.mainGrid.addWidget(self.BackwardImageCanvas, 1, 1, 1, 1)
        self.mainGrid.addWidget(self.BackwardComboBox, 1, 2, 1, 1)
        self.mainGrid.addWidget(self.BackwardImageCanvas, 1, 1, 1, 1)
        self.mainGrid.addWidget(
            self.BankLabel,
            2,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountBankLabel, 2, 0, 1, 1)
        self.mainGrid.addWidget(self.BankCanvas, 3, 1, 1, 1)
        self.mainGrid.addWidget(self.BankComboBox, 3, 2, 1, 1)
        self.mainGrid.addWidget(
            self.SmallLabel,
            4,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountSmallLabel, 4, 0, 1, 1)
        self.mainGrid.addWidget(self.SmallCanvas, 5, 1, 1, 1)
        self.mainGrid.addWidget(self.SmallComboBox, 5, 2, 1, 1)
        self.mainGrid.addWidget(
            self.MonitorLabel,
            6,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountMonitorLabel, 6, 0, 1, 1)
        self.mainGrid.addWidget(self.MonitorCanvas, 7, 1, 1, 1)
        self.mainGrid.addWidget(self.MonitorComboBox, 7, 2, 1, 1)


