#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from pattern import *
from detector import *
from monitor import *
from experiment import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.patternPage = CSNSPatternPage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.patternPage, 'Diffraction Pattern')
        self.addTab(self.detectorPage, 'Detector Counts')
        self.addTab(self.monitorPage, 'Monitor Counts')
        self.addTab(self.experimentPage, 'Experiment Progress')
    
        self.currentChanged.connect(self.tabChange)

    def updateDiffractionSimulator(self):
        self.patternPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.patternPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getPatternPath(self):
        groupStatus = []
        groupTOFPath = []
        groupCountsPath = []
        _index = self.patternPage.patternDock[0].normSelected()
        for i in range(len(self.patternPage.patternDock)):
            groupStatus.append(self.patternPage.patternDock[i].pauseButton.text())
            if _index == 0:
                groupTOFPath.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/tof')
                groupCountsPath.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/counts')
            else:
                groupTOFPath.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/tof')
                groupCountsPath.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/counts')
                
        return groupStatus, groupTOFPath, groupCountsPath

    def getDetectorPath(self):
        buttonIndex = self.detectorPage.getButtonIndex() 
        
        pidXaxisPath = []
        pidValuePath = []
        xyXaxisPath = []        
        xyYaxisPath = []        
        xyValuePath = []
        
        moduleList=[131,132,133,231,232,233,322,331,332,333,341,342,343,422,431,432,433,441,442,443,521,522,523,531,532,533,541,542,543,621,622,623,631,632,633,641,642,643]
        
        for i in range (buttonIndex+1):
            pidXaxisPath.append("/GPPD/workspace/MantidData/module"+str(moduleList[i])+"/pid_image/x")
            pidValuePath.append("/GPPD/workspace/MantidData/module"+str(moduleList[i])+"/pid_image/value")
            xyXaxisPath.append("/GPPD/workspace/MantidData/module"+str(moduleList[i])+"/xy_image/x")
            xyYaxisPath.append("/GPPD/workspace/MantidData/module"+str(moduleList[i])+"/xy_image/y")
            xyValuePath.append("/GPPD/workspace/MantidData/module"+str(moduleList[i])+"/xy_image/value")            
        return pidXaxisPath, pidValuePath, xyXaxisPath, xyYaxisPath, xyValuePath
        

    def getMonitorPath(self):
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            monitorAxisXPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_x')
            monitorAxisYPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/axis_y')
            monitorValuePath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/value')
            monitorTOFPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/tof')
            monitorCountsPath.append('/GPPD/workspace/MantidData/monitor'+str(i+1).zfill(2)+'/counts')
        return monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath

    def getExperimentPath(self):
        protonPath = []
        neutronPath = []
        pulsePath = []
        protonPath.append('/GPPD/workspace/MantidData/proton_charge/time')
        protonPath.append('/GPPD/workspace/MantidData/proton_charge/value')
        neutronPath.append('/GPPD/workspace/MantidData/neutron_counts/time')
        neutronPath.append('/GPPD/workspace/MantidData/neutron_counts/value')
        pulsePath.append('/GPPD/workspace/MantidData/pulse_charge/time')
        pulsePath.append('/GPPD/workspace/MantidData/pulse_charge/value')
        return protonPath, neutronPath, pulsePath
    
    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        groupStatus = []
        groupTOFPath = []
        groupCountsPath = []
        monitorStatus = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        tabIndex = self.currentIndex()

        if tabIndex == 0:
            groupStatus, path1, path2 = self.getPatternPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2,
                        "status": groupStatus}
            #groupStatus, groupTOFPath, groupCountsPath = self.getPatternPath() 
            #kwargs = {"tabIndex": tabIndex, "path1": groupCountsPath, "path2": groupTOFPath,  "status": groupStatus}
        elif tabIndex == 1:
            path1, path2, path3, path4, path5 = self.getDetectorPath()
            kwargs = {'tabIndex': tabIndex, 'path1': path1, 'path2': path2, 'path3': path3, 'path4': path4, 'path5': path5}
            #pidXaxisPath, pidValuePath, xyXaxisPath, xyYaxisPath, xyValuePath = self.getDetectorPath()
            #kwargs = {'tabIndex': tabIndex, 'path1': pidXaxisPath, 'path2': pidValuePath, 'path3': xyXaxisPath, 'path4': xyYaxisPath, 'path5': xyValuePath}
        elif tabIndex == 2:
            monitorStatus, monitorAxisXPath, monitorAxisYPath, monitorValuePath, monitorTOFPath, monitorCountsPath = self.getMonitorPath()
            kwargs = {"tabIndex": tabIndex, "path1": monitorValuePath, "path2": monitorAxisXPath, "path3": monitorAxisYPath, "path4": monitorTOFPath,"path5": monitorCountsPath, "status": monitorStatus}

        elif tabIndex == 3:
            path1, path2, path3 = self.getExperimentPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3}
       
        self.parent.setDataPath(kwargs)
