#!/usr/bin/python
# -*- coding: utf-8 -*-
from conf import *
import thread
import threading
from model.globalClass import *
from model.diffractionSimulator import *

from matplotlib.figure import Figure
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.mlab import griddata
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D


class updateStreamingMonitor(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        color,
        simulatorStreaming,
        ):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.simulatorStreaming = simulatorStreaming
        self.can = can
        self.ax = ax
        self.lines = self.ax.plot(self.simulatorStreaming.MX,
                                  self.simulatorStreaming.MY,
                                  color=color)
    def process(self):
        self.lines[0].set_xdata(self.simulatorStreaming.MX)
        self.lines[0].set_ydata(self.simulatorStreaming.MY)

        self.ax.relim()
        self.ax.autoscale_view()
        self.can.draw()

    def run(self):
        while True:
            delay = 1  # random.randrange(1,10,1)/10.0
            time.sleep(delay)
            try:
                self.process()
            except:
                break

class updateStreaming2D(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        constant,
        color,
        simulatorStreaming,
        ):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.color = color
        self.simulatorStreaming = simulatorStreaming
        self.can = can
        self.ax = ax
        self.constant = constant
        self.thread_stop = False

    def process(self):
        self.ax.clear()
        self.ax.plot(self.simulatorStreaming.X * self.constant,
                     self.simulatorStreaming.Y,
                     color=self.color)

        self.ax.relim()
        self.ax.autoscale_view()
        self.can.draw() 

    def run(self):
        while not self.thread_stop:
            while True:
                try:
                    self.process() 
                    if self.thread_stop==True:break
                except:
                    break

    def stop(self):
        self.thread_stop= True

class updateStreaming3D(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        cmap,
        simulatorStreaming,
        ):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.simulatorStreaming = simulatorStreaming
        self._x = self.simulatorStreaming.Xaxis
        self._y = self.simulatorStreaming.Yaxis
        self.can = can
        self.ax = ax
        self.cmap = cmap

    def process(self):
        self.ax.pcolormesh(self._x, self._y, self._z, cmap=self.cmap)
        self.can.draw()

    def run(self):
        while True:
            self._z = self.simulatorStreaming.XY
            delay = 1  # random.randrange(1,10,1)/10.0
            time.sleep(delay)
            try:
                self.process()
            except:
                break

class updateProtonCharge(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        color,
        queue,
        singleLock,
        ):
        threading.Thread.__init__(self)
        self.threadID=threadID
        self.color = color
        self.can = can
        self.ax = ax
        self.queue=queue
        self.singleLock=singleLock

    def process(self, result):
        self.ax.clear()
        self.ax.plot(result, color=self.color)

        self.ax.relim()
        self.ax.autoscale_view()
        self.can.draw()
         
    def run(self):
        while True:
            #self.singleLock.acquire()
            result=self.queue.get()
            try:
                self.process(result)
            except:
                break
            self.queue.task_done()
            #self.singleLock.release() 
