#!/usr/bin/python
# -*- coding: utf-8 -*-
import math
import random
from math import atan
from numpy import *
from scipy import pi, log
import numpy as np
import time
import thread
import threading
from scipy.interpolate import interp1d
from scipy.interpolate import InterpolatedUnivariateSpline
from scipy.interpolate import UnivariateSpline
from readData import *
from globalClass import *


class diffractionSimulator(threading.Thread):

    def __init__(
        self,
        threadID,
        sampling,
        histogramData,
        monitorData,
        neutronCounts,
        measurementTime,
        CSNSGlobal,
        ):
        threading.Thread.__init__(self)

        self.thread_stop = False
        self.threadID = threadID
        self.sampling = sampling

        self.histogramData = histogramData
        self.monitorData = monitorData
        self.neutronCounts = neutronCounts
        self.measurementTime = measurementTime

        self.L1 = 30000.0
        self.L2 = 1500.0
        self.M1 = 28504.0

        self.histogramOut = CSNSGlobal

        (self.Xaxis, self.Yaxis, self.R, self.L, self.sintheta) = \
            self.generateGeometry()
        self.Xnum = self.Xaxis.shape[0]
        self.Ynum = self.Yaxis.shape[1]
        self.histogramOut.XY = np.zeros((self.Xnum, self.Ynum))
        self.histogramOut.Xaxis = self.Xaxis
        self.histogramOut.Yaxis = self.Yaxis

        # position sampling

        _nid = (self.Ynum + 1) * self.Xnum
        _R = np.zeros(_nid)
        for j in range(self.Ynum):
            for i in range(self.Xnum):
                _id = j * self.Xnum + i
                _R[_id] = 1 / self.R[i][j]
        self.pR = self.importanceSampling(_R)

        # intensity sampling

        (nId, Id) = CSNSRead2DData(self.histogramData)
        self.pId = self.importanceSampling(Id[1])
        self.histogramOut.X = np.array(Id[0])

        self.histogramOut.Y = np.zeros(len(Id[0]))

        # monitor sampling

        (nMl, Ml) = CSNSRead2DData(self.monitorData)
        self.pMl = self.importanceSampling(Ml[1])
        self.histogramOut.MX = np.array(Ml[0])

        self.histogramOut.MY = np.zeros(len(Ml[0]))

    def generateGeometry(self):
        L1 = self.L1
        L2 = self.L2
        Xmin = 50
        Xbin = 5.0
        Xnum = 100
        Xmax = Xmin + Xbin * Xnum

        Ymin = -Xmax
        Ymax = Xmax
        Ybin = 5.0
        Ynum = int((Ymax - Ymin) / Ybin)

        # Xaxis=[]
        # Yaxis=[]
        # for i in range(Xnum):
        #    Xaxis.append(Xmin+i*Xbin)

        # for i in range(Ynum):
        #    Yaxis.append(Ymin+i*Ybin)

        Xaxis = np.zeros((Xnum, Ynum))
        Yaxis = np.zeros((Xnum, Ynum))
        L = np.zeros((Xnum, Ynum))
        R = np.zeros((Xnum, Ynum))
        sintheta = np.zeros((Xnum, Ynum))

        for iy in range(Ynum):
            for ix in range(Xnum):
                Xaxis[ix][iy] = Xmin + ix * Xbin
                Yaxis[ix][iy] = Ymin + iy * Ybin
                R[ix][iy] = (Xaxis[ix][iy] ** 2.0 + Yaxis[ix][iy]
                             ** 2.0) ** 0.5
                L[ix][iy] = L1 + R[ix][iy]
                sintheta[ix][iy] = ((1 - L2 / (L2 ** 2.0 + R[ix][iy]
                                    ** 2.0) ** 0.5) / 2.0) ** 0.5

        return (Xaxis, Yaxis, R, L, sintheta)

    def generateTOF():
        Tmin = 4.0
        Tmax = 40000.0
        Tbin = 4.0
        Tnum = int((Tmax - Tmin) / Tbin)
        tof = np.zeros(Tnum)
        for i in range(Tnum):
            tof[i] = Tmin + Tbin * i

        return tof

    def d2Tof(d=0, sintheta=1.0, L=30000):
        tof = d * 505.55683 * sintheta * L / 1000.0
        return tof

    def d2TofList(dList, sintheta=1.0, L=30000):
        tof = np.zeros(len(dList))
        tof = dList * 505.55683 * sintheta * L / 1000.0
        return tof

    def l2Tof(l=0, L=30000):
        tof = l * 505.55683 * L / 2.0
        return tof

    def l2TofList(lList, L=30000):
        tof = np.zeros(len(dList))
        tof = lList * 505.55683 * L / 2.0
        return tof

    def rebin(inX, inY, outX):
        x = np.array(inX, dtype=float)
        y = np.array(inY, dtype=float)
        fxy = InterpolatedUnivariateSpline(x, y, k=1)
        outY = fxy(outX)
        return outY

    def importanceSampling(self, fx):
        nx = len(fx)
        px = np.zeros(nx)
        px[0] = fx[0]
        for i in range(1, nx):
            px[i] = fx[i] + px[i - 1]

        for i in range(nx):
            px[i] = px[i] / px[nx - 1]

        return px

    def monitorDetetor(outFile):
        Ml = CSNSRead2DData(self.monitorData)
        Mx = Ml[0]

        tof = generateTOF()

        Mx = l2TofList(Ml[0], self.M1)

        My = rebin(Mx, Ml[1], tof)

    def randomSampling(ylist, y0):
        p = random.random()
        idx = np.argmin(np.abs(ylist - y0))
        return idx

    def xyzSampling(self):
        for i in range(int(self.neutronCounts)):
            _p = random.random()
            _id = np.argmin(np.abs(self.pR - _p))
            _idy = int(_id / self.Xnum + 0.5)
            _idx = _id - _idy * self.Xnum
            if _idx >= 0 and _idx < self.Xnum and _idy >= 0 and _idy \
                < self.Ynum:
                self.histogramOut.XY[_idx][_idy] += 1

            _p = random.random()
            _idx = np.argmin(np.abs(self.pId - _p))
            self.histogramOut.Y[_idx] += 1

            _p = random.random()
            _idx = np.argmin(np.abs(self.pMl - _p))
            self.histogramOut.MY[_idx] += 1000

            # time.sleep(0.04/100.0)

    def xySampling(self):
        _Xnum = self.R.shape[0]
        _Ynum = self.R.shape[1]
        _nid = (_Ynum + 1) * _Xnum
        R = np.zeros(_nid)
        for j in range(_Ynum):
            for i in range(_Xnum):
                _i = j * _Xnum + i
                R[_i] = 1 / self.R[i][j] ** 2.0
        pR = self.importanceSampling(R)

        for i in range(int(self.neutronCounts)):
            self.histogramOut.Connected = False
            time.sleep(0.04)
            _p = random.random()
            _id = np.argmin(np.abs(pR - _p))
            _idy = int(_id / _Xnum + 0.5)
            _idx = _id - _idy * _Xnum

            if _idx >= 0 and _idx < _Xnum and _idy >= 0 and _idy \
                < _Ynum:
                self.histogramOut.XY[_idx][_idy] += 1
            self.histogramOut.Connected = True

    def ySampling(self):
        (nId, Id) = CSNSRead2DData(self.histogramData)

        pId = self.importanceSampling(Id[1])

        nId = len(Id[0])
        for i in range(nId):
            self.histogramOut.X.append(Id[0][i])
            self.histogramOut.Y.append(0)

        for i in range(int(self.neutronCounts)):
            self.histogramOut.Connected = False
            time.sleep(0.04)
            p = random.random()
            idx = np.argmin(np.abs(pId - p))
            self.histogramOut.Y[idx] = self.histogramOut.Y[idx] + 1
            self.histogramOut.Connected = True

    def run(self):
        try:
            if self.sampling == 1:
                self.ySampling()
            elif self.sampling == 2:
                self.xySampling()
            elif self.sampling == 3:
                self.xyzSampling()
            else:
                pass
            if self.thread_stop==True:
                return 0
        except:
            return 

    def stop(self):
        self.thread_stop= True
