#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''
import Queue
from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *

class CSNSExperimentPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSExperimentPage, self).__init__(parent=None)
        self.inQueue=Queue.Queue()
        self.outQueue=Queue.Queue()
        self.singleLock=threading.Lock()
        self.setupUi(self)

    def __del__(self):
        #self.inQueue.join()
        self.outQueue.task_done()
        self.getThread.stop_event.set()
        self.outQueue.task_done()
        self.putThread.stop_event.set()
        
    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        _xsize = 3
        _ysize = 0.5

        # 
        self.timeLabel = QtGui.QLabel('Measurement Time:')
        self.timeProgressBar = QtGui.QProgressBar(self)     
        self.timeProgressThread = updateProgressBar()
 
        # 
        self.protonLabel = QtGui.QLabel('Proton Charge:')

        self.protonCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        
        # 
        self.scatterLabel = QtGui.QLabel('Scattered Neutron Counts:')

        self.scatterCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # 
        self.monitorLabel = QtGui.QLabel('Incident Neutron Counts:')

        self.monitorCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )


        # 
        self.peakLabel = QtGui.QLabel('Peak Intensity:')

        self.peakCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # 
        self.rexpLabel = QtGui.QLabel('Rexp Factor:')

        self.rexpCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )


        _nline = 0
        self.mainGrid.addWidget(
            self.timeLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.timeProgressBar, _nline, 1, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(
            self.protonLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.protonCanvas, _nline, 1, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(
            self.scatterLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.scatterCanvas, _nline, 1, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(
            self.monitorLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.monitorCanvas, _nline, 1, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(
            self.peakLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.peakCanvas, _nline, 1, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(
            self.rexpLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.rexpCanvas, _nline, 1, 1, 1)

        #self.inQueue.join()
        #self.outQueue.join()

    def startProtonSimulator(self):
        for i in range(int(1E6)):
            self.inQueue.put_nowait(i)        
            self.inQueue.join()        

    def putProton(self, threadID):
        self.putThread = protonSimulator(
            threadID,
            self.inQueue,
            self.outQueue,
            )

        self.putThread.setDaemon(True)
        self.putThread.start()

    def getProton(self, threadID):        
        self.getThread = updateProtonCharge(threadID, self.protonCanvas,self.protonCanvas.ax, 'g', self.outQueue, self.singleLock)
        self.getThread.setDaemon(True)
        self.getThread.start()

    def updateProgressBar(self,progressBar, val):
        self.progressBar.setValue(val)
        perct = "{0}%".format(val)

    def fin(self):
        pass
