#!/usr/bin/python
# -*- coding: utf-8 -*-

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

from conf.constants import *
import conf.constants
import json

from conf import *
import thread
import threading
import datetime

from presenter.updateStreaming import *
from model.diffractionSimulator import *
from model.readData import *
from model import neonReceiver
from viewer.commandThread import *


class CSNSUserInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSUserInfo, self).__init__(parent)
        self.setupUi(self)

        self.parent = parent
        self.controlThread = None

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        # self.mainGrid.setMargin(0)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreafirst = QtGui.QScrollArea()
        self.scrollAreafirst.setWidgetResizable(True)
        self.scrollAreafirst.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreasecond = QtGui.QScrollArea()
        self.scrollAreasecond.setWidgetResizable(True)
        self.scrollAreasecond.setWidget(self.second)

        self.forth = QtGui.QFrame(self)
        self.forth.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaforth = QtGui.QScrollArea()
        self.scrollAreaforth.setWidgetResizable(True)
        self.scrollAreaforth.setWidget(self.forth)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollAreafirst)
        self.splitter.addWidget(self.scrollAreasecond)
        self.splitter.addWidget(self.scrollAreaforth)
        self.splitter.setSizes([100, 200, 100])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.forthGrid = QtGui.QGridLayout(self.forth)

    	# main verticalLayout
        self.GPPDLabel = QtGui.QLabel('<font color=red>GPPD</font>')
        self.GPPDLabel.setFont(QtGui.QFont('Roman times', 20,
                               QtGui.QFont.Bold))

    	# first Grid
        self.userIDLabel = QtGui.QLabel('UserID: ', self.first)
        self.userIDText = QtGui.QLabel('Lili Yan', self.first)

        self.proposalLabel = QtGui.QLabel('ProposalID: ', self.first)
        self.proposalText = QtGui.QLabel('GP-2017-000031D', self.first)

        self.verticalLayout.addWidget(self.GPPDLabel)
        self.verticalLayout.addWidget(self.splitter)

    	# second Grid
        self.analyserLabel = QtGui.QLabel('NEON', self.second)
        self.hostTextEdit = QtGui.QTextEdit('10.1.53.240:9000', self.second)
        self.hostTextEdit.setReadOnly(True)
        self.hostTextEdit.setFixedSize(QtCore.QSize(100, 30))
        #self.hostTextEdit.setLineWrapColumnOrWidth(150)
        #self.hostTextEdit.setWordWrapMode(QtGui.QTextOption.NoWrap)
        #self.hostTextEdit.setLineWrapMode(QtGui.QTextEdit.FixedPixelWidth)

        self.hostButton = QtGui.QPushButton('Enable',
                self.second)
        self.hostButton.setFixedSize(QtCore.QSize(60, 30))
        self.hostButton.clicked.connect(self.hostButtonClicked)

        self.analyserButton = QtGui.QPushButton('Connect',
                self.second)
        self.analyserButton.setFixedSize(QtCore.QSize(80, 30))
        self.analyserButton.clicked.connect(self.connectButtonClicked)
 
        self.commandLabel = QtGui.QLabel('Command: ', self.second)

        self.commandTimeLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel = QtGui.QLabel('', self.second)
        self.statusLabel = QtGui.QLabel('Status: ', self.second)
        self.statusTimeLabel = QtGui.QLabel('', self.second)
        self.statusValueLabel = QtGui.QLabel('', self.second)

 
        #self.createAnalyserThread()
        #self.analyserThread.start()
        # self.createStateCmdThread()....
        # self.stateCmdThread.start()

    # forth Grid

        with plt.xkcd():
            self.runFigure = Figure(
                (1, 1),
                dpi=150,
                facecolor='white',
                edgecolor=None,
                frameon=False,
                tight_layout=False,
                )
            self.runCanvas = FigureCanvas(self.runFigure)
            self.runCanvas.setParent(self)

            self.runAxes = self.runFigure.add_subplot(111)
            self.runFigure.subplots_adjust(left=0.05, bottom=0.05,
                    right=0.95, top=0.95)
            self.runAxes.tick_params(axis='both', which='major',
                    labelsize=6)
            self.runAxes.get_xaxis().set_visible(False)
            self.runAxes.get_yaxis().set_visible(False)

        self.expTimeLabel = \
            QtGui.QLabel('<font color=red>Running Time:</font>')
        self.expTimeText = QtGui.QLabel('<font color=red></font>')

        self.start=time.time()
        self.timer = QtCore.QTimer(self)
        self.timer.setInterval(1000)
        self.timer.timeout.connect(self.setRunTime)
        self.timer.start()

        self.chargeLabel = QtGui.QLabel('Proton Charge: ')
        self.chargeText = QtGui.QLabel('1.3E6 ')

        self.countsLabel = QtGui.QLabel('Neutron Counts: ')
        self.countsText = QtGui.QLabel('5.2E10 ')

        self.monitorStreaming = CSNSGlobal()
        self.startMonitor()

        _nline = 0
        self.firstGrid.addWidget(self.userIDLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.userIDText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.proposalLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.proposalText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline = 0
        self.secondGrid.addWidget(self.analyserLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.analyserButton, _nline, 1, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.hostTextEdit, _nline, 0, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.hostButton, _nline, 1, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.commandLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.commandValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.commandTimeLabel, _nline, 0, 1, 2, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.statusLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.statusValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.statusTimeLabel, _nline, 0, 1, 2, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)

        _nline += 1
        self.forthGrid.addWidget(
            self.expTimeLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.forthGrid.addWidget(
            self.expTimeText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.forthGrid.addWidget(
            self.chargeLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.forthGrid.addWidget(
            self.chargeText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.forthGrid.addWidget(
            self.countsLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.forthGrid.addWidget(
            self.countsText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.forthGrid.addWidget(
            self.runCanvas,
            _nline,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        self.forthGrid.addItem(QtGui.QSpacerItem(-1, -1,
                               QtGui.QSizePolicy.Ignored,
                               QtGui.QSizePolicy.Expanding), 2, 0)

        timen=str(datetime.datetime.now())
        self.setCommandTimeLabel(timen)

	#_palette = QtGui.QPalette(QtGui.QColor.green)
        self.setCommandValueLabel('<font color=green>Start</font>')
        #self.setCommandValueLabel.setPalette(_palette)
        
        #timen=timen+21.4
        self.setStatusTimeLabel(timen)
        self.setStatusValueLabel('<font color=red>Running</font>')

    def hostButtonClicked(self):
        if self.hostButton.text() == 'Enable':
            self.hostTextEdit.setReadOnly(True)      
            self.hostButton.setText('Disable')
            logging.info("HOST Editor disabled.")
        elif self.hostButton.text() == 'Disable':
            self.hostButton.setText('Enable')       
            self.hostTextEdit.setReadOnly(False)      
            logging.info("HOST Editor enabled.")

    def setNeonButton(self, value):
	if value:
	    self.analyserButton.setText('Disconnect')
	else:
	    self.analyserButton.setText('Connect')

    def getNeon(self):
        status=False
	server=None

	_timeout=10
        _ip=self.getIP()
        _port=self.getPort()
        if _ip is None or _port is None:
           logging.ERROR("NEON is not configured")
        else:
            _r=neonReceiver.connectNeon(_ip, _port, _timeout)
	    status=_r.getStatus()
            server=_r.getServer()
        
	return status, server

    def connectButtonClicked(self):
        if self.analyserButton.text() == 'Connect':
            _ip="10.1.53.240"
            _port=9000
            _timeout=10
            _r=neonReceiver.connectNeon(_ip, _port, _timeout)
            
            status=_r.status
            server=_r.server

            if status:
                self.analyserButton.setText('Disconnect')
                logging.info("NEON connected.")

        elif self.analyserButton.text() == 'Disconnect':
            status=False
            server=None
            self.analyserButton.setText('Connect')
            logging.info("NEON disconnected.")

    def setCommandTimeLabel(self, time):
        self.commandTimeLabel.setText(time)

    def setCommandValueLabel(self, value):
        self.commandValueLabel.setText(value)
    
    def setStatusTimeLabel(self, time):
        self.statusTimeLabel.setText(time)

    def setStatusValueLabel(self, value):
        self.statusValueLabel.setText(value)
    
    def setRunTime(self):
        _during=int(time.time()-self.start)
        self.expTimeText.setText(str(_during))

    def startMonitor(self):
        self.createStreamingThread(self.getSource())
        self.createPlotThread()

        self.streamingThread.start()
        self.plotThread.start()

    def createStreamingThread(self, sourceID):
        global CSNSThreadID
        CSNSThreadID += 1

        if sourceID == 2:
            self.streamingThread = diffractionSimulator(
                CSNSThreadID,
                3,
                './dat/gppd.dat',
                './dat/monitor.dat',
                1E6,
                1.0,
                self.monitorStreaming,
                )
        elif sourceID == 0:
            self.streamingThread = neonReceiver(
                CSNSThreadID,
                self.getIP(),
                self.getPort(),
                '/BL01/MONITOR01/PATTERN',
                1.0,
                self.monitorStreaming,
                )

        self.streamingThread.setDaemon(True)

    def createPlotThread(self):
        global CSNSThreadID
        CSNSThreadID += 1

        self.plotThread = updateStreamingMonitor(CSNSThreadID,
                self.runCanvas, self.runAxes, 'g',
                self.monitorStreaming)

        self.plotThread.setDaemon(True)

    def getIP(self):
        _host=self.hostTextEdit.toPlainText().split(":")
        return _host[0]

    def getPort(self):
        _host=self.hostTextEdit.toPlainText().split(":")
        return int(_host[1])

    def getSource(self):
        self.sourceID = 2
        return self.sourceID

    def getUserIDText(self):
	return self.userIDText
   
    def getProposalText(self):
	return self.proposalText

    def getCommandValueLabel(self):
	return self.commandValueLabel

    def getCommandTimeLabel(self):
	return self.commandTimeLabel

    def getStatusValueLabel(self):
	return self.statusValueLabel

    def getStatusTimeLabel(self):
	return self.statusTimeLabel

    def getStateNowTime(self):
        return self.stateNowTime

    def getStateNowText(self):
        return self.stateNowText

    def getCmdRecTime(self):
        return self.cmdRecTime

    def getCmdRecText(self):
        return self.cmdRecText

    def getExpTimeText(self):
        return expTimeText

    def getChargeText(self):
        return self.chargeText

    def getCountsText(self):
        return self.countsText

    def createControllerThread(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.controllerThread = ControllerStatusListen(CSNSThreadID,
                self.controllerRightStatus, self.controllerErrorStatus,
                self.controllerStatusLabel, self.controllerButton)
        self.controllerThread.setDaemon(True)

    def createAnalyserThread(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.analyserThread = AnalyserStatusListen(CSNSThreadID,
                self.analyserRightStatus, self.analyserErrorStatus,
                self.analyserStatusLabel, self.analyserButton)
        self.analyserThread.setDaemon(True)

    def createStateCmdThread(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.stateCmdThread = StateCmdListen(CSNSThreadID,
                self.stateNowText, self.cmdRecText)
        self.stateCmdThread.setDaemon(True)


class statusRightLabel(QtGui.QWidget):

    def __init__(self, text=None):
        super(self.__class__, self).__init__()
        self.text = text
        self.setMinimumSize(10, 10)

    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        pen = QtGui.QPen()

        # pen.setStyle(QtGui.Qt.SquareCap)

        pen.setWidth(2)
        pen.setColor(QtCore.Qt.white)
        painter.setPen(pen)
        painter.translate(0, 13)
        line1 = QtCore.QLine(0, 5, 4, 10)
        line2 = QtCore.QLine(4, 10, 10, 0)
        painter.drawRect(0, 0, 10, 10)
        painter.fillRect(0, 0, 10, 10, QtCore.Qt.green)
        painter.drawLines(line1, line2)
        if self.text:
            painter.drawText(0, 0, self.text)
        painter.end()


class statusErrorLabel(QtGui.QWidget):

    def __init__(self, text=None):
        super(self.__class__, self).__init__()
        self.text = text
        self.setMinimumSize(10, 10)

    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        pen = QtGui.QPen()

        # pen.setStyle(QtGui.Qt.SquareCap)

        pen.setWidth(2)
        pen.setColor(QtCore.Qt.white)
        painter.setPen(pen)
        painter.translate(0, 13)
        line1 = QtCore.QLine(0, 0, 10, 10)
        line2 = QtCore.QLine(10, 0, 0, 10)
        painter.drawRect(0, 0, 10, 10)
        painter.fillRect(0, 0, 10, 10, QtCore.Qt.red)
        painter.drawLines(line1, line2)
        if self.text:
            painter.drawText(0, 0, self.text)
        painter.end()


class ControllerStatusListen(threading.Thread):

    def __init__(
        self,
        threadID,
        controllerRightStatus,
        controllerErrorStatus,
        controllerStatusLabel,
        controllerButton,
        ):

        threading.Thread.__init__(self)
        self.threadID = threadID
        self.constant_run = threading.Event()
        self.controllerRightStatus = controllerRightStatus
        self.controllerErrorStatus = controllerErrorStatus
        self.controllerStatusLabel = controllerStatusLabel
        self.controllerButton = controllerButton

    def process(self):
        self.controllerStatus = conf.constants.CSNSControllerStatus
        if self.controllerStatus:
            self.controllerRightStatus.hide()
            self.controllerErrorStatus.show()
            self.controllerStatusLabel.setText('DisConnected')
            self.controllerButton.setText('Connected')
        else:

           # time.sleep(10)
        # global CSNSControllerStatus
        # CSNSControllerStatus = 0

            self.controllerRightStatus.show()
            self.controllerErrorStatus.hide()
            self.controllerStatusLabel.setText('Connected')
            self.controllerButton.setText('DisConnected')

           # time.sleep(10)
           # global CSNSControllerStatus
        # CSNSControllerStatus = 1

    def run(self):
        while True:
            if not self.constant_run.isSet():
                delay = 1
                time.sleep(delay)
                try:
                    self.process()
                except:
                    break
                finally:
                    pass

    def pause(self):
        self.constant_run.clear()

    def resume(self):
        self.constant_run.set()


class AnalyserStatusListen(threading.Thread):

    def __init__(
        self,
        threadID,
        analyserRightStatus,
        analyserErrorStatus,
        analyserStatusLabel,
        analyserButton,
        ):

        threading.Thread.__init__(self)
        self.threadID = threadID
        self.constant_run = threading.Event()
        self.analyserRightStatus = analyserRightStatus
        self.analyserErrorStatus = analyserErrorStatus
        self.analyserStatusLabel = analyserStatusLabel
        self.analyserButton = analyserButton
        global CSNSAnalyserStatus

    def process(self):
        if CSNSAnalyserStatus:
            self.analyserRightStatus.hide()
            self.analyserErrorStatus.show()
            self.analyserStatusLabel.setText('DisConnected')
            self.analyserButton.setText('Connected')
        else:
            self.analyserRightStatus.show()
            self.analyserErrorStatus.hide()
            self.analyserStatusLabel.setText('Connected')
            self.analyserButton.setText('DisConnected')

    def run(self):
        while True:
            if not self.constant_run.isSet():
                delay = 1
                time.sleep(delay)
                try:
                    self.process()
                except:
                    break
                finally:
                    pass

    def pause(self):
        self.constant_run.clear()

    def resume(self):
        self.constant_run.set()


class StateCmdListen(threading.Thread):

    def __init__(
        self,
        threadID,
        stateNowText,
        cmdRecText,
        ):

        threading.Thread.__init__(self)
        self.threadID = threadID
        self.constant_run = threading.Event()
        self.stateNowText = stateNowText
        self.cmdRecText = cmdRecText

    def process(self):
        self.stateNow = self.stateNowText.getText()
        self.statusVar = conf.constants.CSNSStateNow

        self.cmdNow = self.cmdRecText.getText()
        self.recCommand = conf.constants.CSNSCommandReceived

        if self.statusVar == self.stateNow:
            pass
        else:
            self.stateNowText.setText(self.stateNow)

        if self.recCommand == self.cmdNow:
            pass
        else:
            self.cmdRecText.setText(self.recCommand)

    def run(self):
        while True:
            if not self.constant_run.isSet():
                delay = 5
                time.sleep(delay)
                try:
                    self.process()
                except:
                    break
                finally:
                    pass

    def pause(self):
        self.constant_run.clear()

    def resume(self):
        self.constant_run.set()


