#!/usr/bin/python
# -*- coding: utf-8 -*-

from conf.constants import *
from canvas import *
from matplotlib.ticker import MaxNLocator
import numpy as np

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)
        
        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([100, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
	
        #first Grid
        _width = 15
        _height = 15
        self.moduleList=[131,132,133,233,232,231,322,331,332,333,341,342,343,422,431,432,433,441,442,443,521,522,523,531,532,533,541,542,543,621,622,623,631,632,633,641,642,643]
        self.buttonList=[131,132,133,# 0, 1, 2
                        233,232,231, # 3, 4, 5
                        322,         # 6
                        331,332,333, # 7, 8, 9
                        341,342,343, #10,11,12
                        422,         #13,
                        431,432,433, #14,15,16
                        441,442,443, #17,18,19
                        521,522,523, #20.21.22
                        531,532,533, #23,24,25
                        541,542,543, #26,27,28
                        621,622,623, #29,30,31
                        631,632,633, #32,33,34
                        641,642,643] #35,36,37
        for i in range(len(self.buttonList)):
            self.buttonList[i] = BankButton(self,'img/module_off.png', _width, _height)
        
        self.camera = BankButton(self,'img/camera.png', _width, _height)
        self.sample = BankButton(self,'img/sample.png', _width, _height)
        self.monitor = BankButton(self,'img/monitor.png', _width, _height)
        
        self.blank5 = BankButton(self,'blank.png', _width, _height)
        self.blank9 = BankButton(self,'blank.png', _width, _height)
	
        self.RadioGroup = QtGui.QButtonGroup()
        for i in range(len(self.buttonList)):
            self.RadioGroup.addButton(self.buttonList[i])
        self.RadioGroup.buttonClicked.connect(self.buttonClicked)

        self.blank1 = QtGui.QLabel("                               ---------------------------------------------->", self.first)
        self.blank1.setMinimumWidth(460)
        self.blank2 = QtGui.QLabel(self.first)
        self.blank2.setMinimumWidth(460)
	
        #second Grid
        self.moduleLabel = QtGui.QLabel("module:633   ", self.second)
        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('XY')
        self.bankCombo.addItem('I-tof')
        self.bankCombo.addItem('I-d')
        #self.bankCombo.setCurrentIndex(1)
        self.bankCombo.activated.connect(self.comboSelected)

        _xsize = 16
        _ysize = 8
        self.xyCanvas = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            'Neutron Distribution',
            'X / mm',
            #'TOF / us',
            )
        self.pidCanvas = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            'Neutron Distribution',
            'TOF / us',
            #'TOF / us',
            )

        _nline = 0
        self.firstGrid.addWidget(self.blank5, _nline, 5, 1,1)
        self.firstGrid.addWidget(self.blank9, _nline, 9, 1,1)
        self.firstGrid.addWidget(self.buttonList[10], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[11], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[12], _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[28], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[25], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[22], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[7], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[8], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[9], _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[27], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[24], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[21], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[6], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[0], _nline, 10, 1,1)
        self.firstGrid.addWidget(self.buttonList[1], _nline, 11, 1,1)
        self.firstGrid.addWidget(self.buttonList[2], _nline, 12, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[26], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[23], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[20], _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.monitor, _nline, 1, 1,1)
        self.firstGrid.addWidget(self.sample, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.camera, _nline, 13, 1,1)
        self.firstGrid.addWidget(self.blank1, _nline, 0, 1,1)
        self.firstGrid.addWidget(self.blank2, _nline, 14, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[37], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[34], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[31], _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[36], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[33], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[30], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[13], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[3], _nline, 10, 1,1)
        self.firstGrid.addWidget(self.buttonList[4], _nline,11, 1,1)
        self.firstGrid.addWidget(self.buttonList[5], _nline, 12, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[35], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[32], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[29], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[16], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[15], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[14], _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[19], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[18], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[17], _nline, 8, 1,1)
        _nline = 0
        self.secondGrid.addWidget(self.moduleLabel, _nline, 1, 1,1)
        self.secondGrid.addWidget(self.bankCombo, _nline, 2, 1,1)
        _nline += 1
        self.secondGrid.addWidget(self.xyCanvas, _nline, 0, 1,1)#, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.pidCanvas, _nline, 0, 1,1)#, QtCore.Qt.AlignCenter)
        self.xyCanvas.show()
        self.pidCanvas.hide()
        self.verticalLayout.addWidget(self.splitter)
        
        self.buttonIndex = 34
        self.buttonList[34].setIcon(QtGui.QIcon('img/module_on.png'))
        self.buttonChange = True
        self.comboIndex = 0  

        self.pix = None
        self.roi = None
        self.colorbar = None

        self.font={ 'family': 'serif',
                    'color':  'red',
                    'weight': 'normal',
                    'size': 7,
                    }

    def getComboIndex(self):
        self.comboIndex = self.bankCombo.currentIndex()    
        return self.comboIndex    

    def getButtonIndex(self):
        return self.buttonIndex
    
    def getDetectorIndex(self):
        buttonIndex = self.getButtonIndex()
        comboIndex = self.getComboIndex()
        return buttonIndex, comboIndex

    def comboSelected(self):
        self.pix = None
        self.pidCanvas.zoomSelected = False
        comboIndex = self.getComboIndex()
        #buttonIndex = self.getButtonIndex()
        self.parent.tabChange()
        if comboIndex==0:
            self.pidCanvas.hide()
            self.xyCanvas.show()
        elif comboIndex==1:
            self.pidCanvas.ax.set_xlabel('TOF / us')
            self.pidCanvas.show()
            self.xyCanvas.hide()
            self.pidCanvas.draw()
        elif comboIndex==2:
            self.pidCanvas.ax.set_xlabel('d')
            self.pidCanvas.show()
            self.xyCanvas.hide()
            self.pidCanvas.draw()
        self.getDetectorData()        

    def getDetectorData(self):
        self.parent.getDetectorData()

    def buttonClicked(self):
        self.buttonReset()
        for i in range (len(self.buttonList)):
            if self.buttonList[i].isChecked():
                self.buttonIndex = i
                self.moduleLabel.setText("module:"+str(self.moduleList[i])+"   ")
                self.buttonList[i].setIcon(QtGui.QIcon('img/module_on.png'))
        self.parent.tabChange()
        self.roi = None
        self.pix = None
        self.buttonChange = True
        self.xyCanvas.zoomSelected = False
        self.pidCanvas.zoomSelected = False
        self.pidCanvas.ax.clear()
        self.xyCanvas.ax.clear()
        self.pidCanvas.draw()
        self.xyCanvas.draw()
        comboIndex = self.getComboIndex()

    def clearCanvas(self):
        self.xyCanvas.ax.clear()
        self.xyCanvas.draw()
        self.pidCanvas.ax.clear()
        self.pidCanvas.draw()
 
    def updateBankCanvas(self, num, value):#, started, _command):
        _buttonIndex=self.getButtonIndex()
        _comboIndex=self.getComboIndex()
        if _buttonIndex in (0,1,2,3,4,5):
            color2D = 'c'
            color3D = 'Greens'
        elif _buttonIndex   in (6,7,8,9,10,11,12,13,14,15,16,17,18,19):
            color2D = 'r'
            color3D = 'Blues'
        elif _buttonIndex in (20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37):
            color2D = 'y'
            color3D = 'gist_heat'
        # XY 3D Image
        if _comboIndex==0:
            try:
                if str(value[2]) == 'clear':
                    self.xyCanvas.ax.clear()
                    self.xyCanvas.draw()
                elif len(value[2]) == 0:
                    pass
                else:
                    #if self.buttonChange or self.roi == None:
                    self.xyCanvas.ax.clear()
                    self.xyCanvas.ax.add_patch(self.xyCanvas.rect)
                    #self.xyCanvas.ax.axis('equal', adjustable='box')
                    self.roi=self.xyCanvas.ax.pcolor(value[0], value[1], value[2], cmap=color3D)
                    self.roi=self.xyCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                    self.xyCanvas.ax.xaxis.set_major_locator(matplotlib.ticker.MultipleLocator(20))
                    self.xyCanvas.ax.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(20))
                    self.xyCanvas.ax.set_xlabel('X / mm')
                    self.xyCanvas.ax.set_ylabel('Y / mm')
                    #self.buttonChange = False
                    #else:
                    #    self.roi.set_array(np.array(value[2]).ravel())
                        #self.roi.set_array(np.array(value[2])[:-1,:-1].ravel())
                    if self.buttonChange == False:
                        if self.xyCanvas.zoomSelected and (self.xyCanvas.minX != self.xyCanvas.maxX) and (self.xyCanvas.minY != self.xyCanvas.maxY):
                            self.xyCanvas.ax.set_xlim(self.xyCanvas.minX, self.xyCanvas.maxX)
                            self.xyCanvas.ax.set_ylim(self.xyCanvas.minY, self.xyCanvas.maxY)
                    if self.colorbar == None:
                        self.colorbar=self.xyCanvas.fig.colorbar(self.roi,ax=self.xyCanvas.ax,extend='max')
                        self.colorbar.ax.tick_params(labelsize=5)
                    else:
                        self.colorbar.on_mappable_changed(self.roi)
                    self.buttonChange = False
                    self.xyCanvas.draw()
            except:
                pass
                #self.roi = None
        # PID 2D Bar
        else:
            try:
            #self.pidCanvas.ax.bar(_x,value,0.5,color='r')
            #self.pidCanvas.ax.axis('scaled')
            #self.pidCanvas.ax.hist(value[4], color=color2D)
                if str(value[4]) == 'clear':
                    self.pidCanvas.ax.clear()
                    self.pidCanvas.draw()
                elif len(value[3]) != len(value[4]) or len(value[4]) == 0:
                    pass
                else:
                    #_t=np.array(value[4])
                    #_t[np.isnan(_t)]=0
                    #_t[np.isinf(_t)]=0
                    #if self.buttonChange or self.pix == None:
                    self.pidCanvas.ax.clear()
                    self.pix, = self.pidCanvas.ax.plot(value[3], value[4], color=color2D)
                    #self.pix, = self.pidCanvas.ax.plot(value[3], _t, color=color2D)
                    self.pidCanvas.ax.add_patch(self.pidCanvas.rect)
                    #else:
                    #    self.pix.set_ydata(value[4])
                    if self.buttonChange == False:
                        if self.pidCanvas.zoomSelected and (self.pidCanvas.minX != self.pidCanvas.maxX) and (self.pidCanvas.minY != self.pidCanvas.maxY):
                            self.pidCanvas.ax.set_xlim(self.pidCanvas.minX, self.pidCanvas.maxX)
                            self.pidCanvas.ax.set_ylim(self.pidCanvas.minY, self.pidCanvas.maxY)
                    self.pidCanvas.ax.yaxis.set_major_locator(MaxNLocator(integer=True))
                    if _comboIndex==1:
                        self.pidCanvas.ax.set_xlabel('TOF / us')
                    elif _comboIndex==2:
                        self.pidCanvas.ax.set_xlabel('d')
                    self.pidCanvas.ax.set_ylabel('Neutron Distribution')
                    self.pidCanvas.ax.relim()
                    self.pidCanvas.ax.autoscale_view()
                    self.pidCanvas.draw()
                    self.buttonChange = False
            except:
                pass
            #    self.pix = None
                #self.pidCanvas.ax.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(3))
        plt.pause(0.0001)

    def buttonReset(self):
        for i in range (len(self.buttonList)):
            self.buttonList[i].setIcon(QtGui.QIcon('img/module_off.png')) 

class BankButton(QtGui.QPushButton):

    def __init__(
        self,
        parent=None,
        img='',
        width=20,
        height=20,
        ):
        super(BankButton,self).__init__(parent)
	
        self.setFlat(True)
        self.setStyleSheet("border:none;outline:none")
        self.setIcon(QtGui.QIcon(img))
        self.setIconSize(QtCore.QSize(width,height))
        self.setCheckable(True)
