from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy as np

class getCommand(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    signalLog = QtCore.pyqtSignal(str)
 
    def __init__(self, parent, neonServer, commandPath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.commandPath = commandPath
        self.refreshTime = refreshTime
        self.command = True
        self.commandLog = 0
    
    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            #get command from neon
            if not self.command: break
            try:
                _command = self.neonServer.get(self.commandPath)
                if _command is None:
                    if self.commandLog == 0:
                        self.signalLog.emit("Empty command from NEON!")
                        self.commandLog += 1
                else:
                    try:
                        _command = str(json.loads(_command))
                        self.signalStatus.emit(_command)
                        self.commandLog = 0
                    except:
                        pass
            except:
                pass
            try: 
                time.sleep(self.refreshTime) 
            except:
                pass
        try: 
            self.finished.emit()            
        except:
            pass

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command

class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalProgress = QtCore.pyqtSignal(str)
    signalStatus = QtCore.pyqtSignal(object, object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object, object, object, object, object)
    signalTime = QtCore.pyqtSignal(object,object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, progressPath, protonPath, detectorPath, detectorRatePath, monitorPath, monitorRatePath, pulsePath, startPath, endPath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.progressPath = progressPath
        self.protonPath = protonPath
        
        self.detectorPath = detectorPath
        self.detectorRatePath = detectorRatePath
        self.monitorPath = monitorPath
        self.monitorRatePath = monitorRatePath
        self.pulsePath = pulsePath
        self.startPath = startPath
        self.endPath = endPath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/GPPD/workspace/MantidData/monitor1/tof'
        self.monitorCountsPath = '/GPPD/workspace/MantidData/monitor1/counts'
        self.monitorTOF=[]

        self.pidXaxis=[]
        self.xyXaxis=[]
        self.xyYaxis=[]
        for i in range(38):
            self.pidXaxis.append([])
            self.xyXaxis.append([])
            self.xyYaxis.append([])
        
        self.progressLog = 0 
        self.monitorTOFLog = 0
        self.monitorCountsLog = 0
        self.pidLog = 0
        self.xyLog = 0
        self.expLog = 0
        self.hisLog = 0

    def __del__(self):
        self.wait()

    def pause(self):
        self.started=False

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def resume(self):
        if not self.started:
            self.started = True

    @QtCore.pyqtSlot()
    def process(self):
        # progress setting in mainSet
        self.getProgressValue()

        # Monitor TOF in User Panel 
        self.getMonitorTOFData()

        while True:
            _data = None
            _started = self.get()
            if not _started:
                continue 
            # Monitor Counts in User Panel 
            self.getMonitorCountsData()

            # get Proton Charge and Neutron Counts in User
            _proton = None
            _detector = None
            _detectorRate = None
            _monitor = None
            _monitorRate = None
            try:
                _proton = self.getPathData(self.protonPath)
                _proton = json.loads(_proton)
                if _proton == [[],[]] or str(_proton) == 'clear' or _proton == None:
                    _proton = [[0],[0]]
            except:
                _proton = [[0],[0]]
            try:
                _detector = self.getPathData(self.detectorPath)
                _detector = json.loads(_detector)
                if _detector == [[],[]] or str(_detector) == 'clear' or _detector == None:
                    _detector = [[0],[0]]
            except:
                detector = [[0],[0]]
            try:
                _detectorRate = self.getPathData(self.detectorRatePath)
                _detectorRate = json.loads(_detectorRate)
                if str(_detectorRate) == 'clear' or _detectorRate == None:
                    _detectorRate = 0.0
            except:
                _detectorRate = 0.0
            try:
                _monitor = self.getPathData(self.monitorPath)
                _monitor = json.loads(_monitor)
                if _monitor == [[],[]] or str(_monitor) == 'clear' or _monitor == None:
                    _monitor = [[0],[0]]
            except:
                monitor = [[0],[0]]
            try:
                _monitorRate = self.getPathData(self.monitorRatePath)
                _monitorRate = json.loads(_monitorRate)
                if str(_monitorRate) == 'clear' or _monitorRate == None:
                    _monitorRate = 0.0
            except:
                _monitorRate = 0.0
            try:
                self.signalExperiment.emit(format(_proton[1][-1], '.2f'), _detector[1][-1], _detectorRate, _monitor[1][-1], _monitorRate)
            except:
                pass

            # get start and end time for user
            _start = self.getPathData(self.startPath)
            _end = self.getPathData(self.endPath)
            try:
                _start = json.loads(_start)
                _end = json.loads(_end)
                self.signalTime.emit(_start, _end)
            except:
                pass
            # get Tab index
            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass
            # Detector Page
            if self.tabIndex == 0:
                self.getHistogramData()
            elif self.tabIndex == 1:
                self.getDetectorData()
            # Experiment Page
            elif self.tabIndex == 3:
                self.getExperimentData()
            # Histogram and Monitor Page
            elif self.tabIndex == 2:
                self.getMonitorData()
            try:
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()
   
    def getProgressValue(self):
        # progress setting in mainSet
        try:
            #get json date after json.dumps from neon
            progress = self.neonServer.get(self.progressPath)
            if progress is None:
                if self.progressLog == 0:
                    self.signalLog.emit("Empty progressBar Setting Data!")
                    self.progressLog += 1
            else:
                self.signalProgress.emit(progress)
                self.progressLog = 0
        except:
            pass

    def getMonitorTOFData(self):
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
        except:
            pass
        if _data is None:
            if self.monitorTOFLog == 0:
                self.signalLog.emit("Empty Monitor TOF Data!")
                self.monitorTOFLog += 1
        else:
            try:
                _data = jsonArray.jsonDecoder(_data)
                self.monitorTOF=_data
                self.monitorTOFLog = 0
            except:
                if self.monitorTOFLog < 2:
                    self.signalLog.emit("Incompleted Monitor TOF Data")
                    self.monitorTOFLog += 1

    def getMonitorCountsData(self):
        try:
            _data = self.neonServer.get(self.monitorCountsPath)
        except:
            pass
        if _data is None :
            if self.monitorCountsLog == 0:
                self.signalLog.emit("Empty Monitor Counts Data!")
                self.monitorCountsLog += 1
        else:
            try:
                _data = jsonArray.jsonDecoder(_data)
                self.signalMonitor.emit(_data)
                self.monitorCountsLog = 0
            except:
                if self.monitorCountsLog < 2:
                    self.signalLog.emit("Incompleted Monitor Counts Data")
                    self.monitorCountsLog += 1 

    def getHistogramData(self):
        _pause = []
        try:
            _pause = self.kwargs['status']
        except:
            pass
        for i in range(len(self.kwargs)-2):
            _array = []
            for key in range(len(self.kwargs['path'+str(i+1)])):
                _array.append([])
            #try:
            for j in range(len(self.kwargs['path'+str(i+1)])):
                if _pause[j]=='Pause':
                    _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                    if _data is None:
                        if self.hisLog == 0:
                            self.signalLog.emit("Empty Canvas Data!")
                            self.hisLog += 1
                    else:
                        try:
                            _data = jsonArray.jsonDecoder(_data)
                            _array[j] = _data
                        except:
                            if self.hisLog < 2:
                                self.signalLog.emit("Incompleted Canvas data")
                                self.hisLog += 1
            self.signalStatus.emit(i+1,_array)
            #except:
            #    pass

    def getDetectorData(self):
        buttonIndex, comboIndex = self.getDetectorIndex()
        if  buttonIndex!=-1:
            value=[]
            i = 0
            for i in range(len(self.kwargs)-1):
                value.append([])
            i = 0
            try:
                for i in range(len(self.kwargs)-1):
                    _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                    if _data is None:
                        if self.pidLog == 0:
                            self.signalLog.emit("Empty PID Data!")
                            self.pidLog += 1
                    else:
                        _data = jsonArray.jsonDecoder(_data)
                        value[i] = _data
                        if self.pidLog < 2:
                            self.signalLog.emit("Incompleted Canvas data")
                            self.pidLog += 1
            except:
                pass
        try:
            self.signalStatus.emit(1,value)
        except:
            pass

    def getMonitorData(self):
        value = []
        _pause = []
        try:
            _pause = self.kwargs['status']
        except:
            pass
        for _ini in range(len(self.kwargs)-2):
            value.append([])
        for i in range(len(self.kwargs)-2):
            _array = []
            for key in range(len(self.kwargs['path1'])):
                _array.append([])
            try:
                for j in range(len(self.kwargs['path1'])):
                    if _pause[j]=='Pause':
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                        if _data is None:
                            if self.hisLog == 0:
                                self.signalLog.emit("Empty Canvas Data!")
                                self.hisLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                                _array[j] = _data
                            except:
                                if self.hisLog < 2:
                                    self.signalLog.emit("Incompleted Canvas data")
                                    self.hisLog += 1
                    else:
                        pass
                value[i]=_array
            except:
                pass
        try:
            self.signalStatus.emit(1,value)
        except:
            pass

    def getExperimentData(self):
        value = []
        i = 0
        for i in range(len(self.kwargs)-1):
            value.append([])
        try:
            for i in range(len(self.kwargs)-1):
                _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                if _data is None:
                    if self.expLog == 0:
                        self.signalLog.emit("Empty Canvas Data!")
                        self.expLog += 1
                else:
                    try:
                        _data = jsonArray.jsonDecoder(_data)
                    except:
                        if self.expLog < 2:
                            self.signalLog.emit("Incompleted Canvas data")
                            self.expLog += 1
                value[i] = _data
        except:
            pass 
        try:
            self.signalStatus.emit(1,value)
        except:
            pass
 
    def getPathData(self, path):
        _data = None
        try:
            _data = self.neonServer.get(path)
        except:
            pass
        if _data is None:
            pass#_data = json.dumps('--')
        elif _data == 'clear':
            pass#_data = json.dumps('--')
        else:
            try:
                _date = jsonArray.jsonDecoder(_data)
            except:
                pass#_data = json.dumps('--')
        return _data

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

    def getDetectorIndex(self):
        return self.parent.getDetectorIndex()

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()

