#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf.constants import *

import Queue
from canvas import *
from model.readData import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *


class CSNSExperimentPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSExperimentPage, self).__init__(parent)
        self.inQueue = Queue.Queue()
        self.outQueue = Queue.Queue()
        self.setupUi(self)
        self.minRange = 1
        self.maxRange = 60
        self.protonConstant = True
        self.scatterConstant = False
        self.monitorConstant = False
        self.peakConstant = False
        self.rexpConstant = False
        self.middleProtonRange = 0
        self.middleScatterRange = 0
        self.middleMonitorRange = 0
        self.middlePeakRange = 0
        self.middleRexpRange = 0

    def __del__(self):

        # self.getThread.stop_event.set()
        # self.putThread.stop_event.set()

        pass

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 3
        _ysize = 0.5

        # Measurement Time

        self.timeLabel = QtGui.QLabel('Measurement Time:')
        #self.timeProgressBar = QtGui.QProgressBar(self)
        #self.timeProgressThread = updateProgressBar(121, 1, 3600)
        #self.timeProgressThread.partDone.connect(self.updateTimeProgressBar)
        #self.timeProgressThread.procDone.connect(self.fin)
        #self.timeProgressThread.start()

        # Proton Charge

        self.protonRadio = QtGui.QRadioButton()
        self.protonRadio.setChecked(True)
        self.protonLabel = QtGui.QLabel('Proton Charge:')

        self.protonCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Scattered Neutron Counts

        self.scatterRadio = QtGui.QRadioButton()
        self.scatterLabel = QtGui.QLabel('Scattered Neutron Counts:')

        self.scatterCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Incident Neutron Counts

        self.monitorRadio = QtGui.QRadioButton()
        self.monitorLabel = QtGui.QLabel('Incident Neutron Counts:')

        self.monitorCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Peak Intensity

        self.peakRadio = QtGui.QRadioButton()
        self.peakLabel = QtGui.QLabel('Peak Intensity:')

        self.peakCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Rexp Factor

        self.rexpRadio = QtGui.QRadioButton()
        self.rexpLabel = QtGui.QLabel('Rexp Factor:')

        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.protonRadio)
        self.RadioGroup.addButton(self.scatterRadio)
        self.RadioGroup.addButton(self.monitorRadio)
        self.RadioGroup.addButton(self.peakRadio)
        self.RadioGroup.addButton(self.rexpRadio)
        self.RadioGroup.buttonClicked.connect(self.RadioButtonChoose)

        self.rexpCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Common ProgressBar

        self.protonProgressBar = QtGui.QProgressBar(self)
	self.protonProgressThread = updateProgressBar(121, 1, 3600)
        self.protonProgressThread.partDone.connect(self.updateProtonProgressBar)
        self.protonProgressThread.procDone.connect(self.fin)
        self.protonProgressThread.start()

        self.scatterProgressBar = QtGui.QProgressBar(self)
        self.scatterProgressThread = updateProgressBar(121, 1, 360)
        self.scatterProgressThread.partDone.connect(self.updateScatterProgressBar)
        self.scatterProgressThread.procDone.connect(self.fin)
        self.scatterProgressThread.start()

        self.monitorProgressBar = QtGui.QProgressBar(self)
        self.monitorProgressThread = updateProgressBar(121, 1, 360)
        self.monitorProgressThread.partDone.connect(self.updateMonitorProgressBar)
        self.monitorProgressThread.procDone.connect(self.fin)
        self.monitorProgressThread.start()

        self.peakProgressBar = QtGui.QProgressBar(self)
        self.peakProgressThread = updateProgressBar(121, 1, 360)
        self.peakProgressThread.partDone.connect(self.updatePeakProgressBar)
        self.peakProgressThread.procDone.connect(self.fin)
        self.peakProgressThread.start()

        self.rexpProgressBar = QtGui.QProgressBar(self)
        self.rexpProgressThread = updateProgressBar(121, 1, 360)
        self.rexpProgressThread.partDone.connect(self.updateRexpProgressBar)
        self.rexpProgressThread.procDone.connect(self.fin)
        self.rexpProgressThread.start()

        _nline = 0
        self.mainGrid.addWidget(
            self.timeLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        #self.mainGrid.addWidget(self.timeProgressBar, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.protonProgressBar, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.scatterProgressBar, _nline, 2, 1,
                                1)
        _nline += 1
        self.mainGrid.addWidget(self.monitorProgressBar, _nline, 2, 1,
                                1)
        _nline += 1
        self.mainGrid.addWidget(self.peakProgressBar, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.rexpProgressBar, _nline, 2, 1, 1)


        _nline += 1
        self.mainGrid.addWidget(self.protonRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.protonLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.protonCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.scatterRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.scatterLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.scatterCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.monitorRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.monitorLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.monitorCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.peakRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.peakLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.peakCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.rexpRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.rexpLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.rexpCanvas, _nline, 2, 1, 1)

        self.verticalLayout.addWidget(self.scrollArea)

        self.scatterProgressBar.hide()
        self.monitorProgressBar.hide()
        self.peakProgressBar.hide()
        self.rexpProgressBar.hide()

        # self.inQueue.join()
        # self.outQueue.join()

    def startProtonSimulator(self):
        self.putProton()
        self.getProton()
        self.startCommonProgress()

        # for i in range(int(1E6)):
        #    self.inQueue.put_nowait(i)
        #    self.inQueue.join()

    def putProton(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.putThread = protonSimulator(CSNSThreadID, self.inQueue,
                self.outQueue)

        self.putThread.setDaemon(True)
        self.putThread.start()

    def getProton(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.getThread = updateProtonCharge(CSNSThreadID,
                self.protonCanvas, self.protonCanvas.ax, 'g',
                self.outQueue)
        self.getThread.setDaemon(True)
        self.getThread.start()

    def putProtonIsAlive(self):
        try:
            return self.putThread.isAlive()
        except:
            return False

    def getProtonIsAlive(self):
        try:
            return self.getThread.isAlive()
        except:
            return False

    #def updateTimeProgressBar(self, val):
    #    self.timeProgressBar.setValue(val)
    #    perct = '{0}%'.format(val)

    def updateProtonProgressBar(self, val):
        self.protonProgressBar.setValue(val)

        perct = "{0}%".format(val)
        # self.middleProtonRange = val

    def updateScatterProgressBar(self, val):
        self.scatterProgressBar.setValue(val)
        perct = "{0}%".format(val)

    def updateMonitorProgressBar(self, val):
        self.monitorProgressBar.setValue(val)
        perct = "{0}%".format(val)

    def updatePeakProgressBar(self, val):
        self.peakProgressBar.setValue(val)
        perct = "{0}%".format(val)

    def updateRexpProgressBar(self, val):
        self.rexpProgressBar.setValue(val)
        perct = "{0}%".format(val)

    def RadioButtonChoose(self):
        if self.protonRadio.isChecked():
            self.protonProgressBar.show()
            self.scatterProgressBar.hide()
            self.monitorProgressBar.hide()
            self.peakProgressBar.hide()
            self.rexpProgressBar.hide()
        elif self.scatterRadio.isChecked():

            self.protonProgressBar.hide()
            self.scatterProgressBar.show()
            self.monitorProgressBar.hide()
            self.peakProgressBar.hide()
            self.rexpProgressBar.hide()
        elif self.monitorRadio.isChecked():

            self.protonProgressBar.hide()
            self.scatterProgressBar.hide()
            self.monitorProgressBar.show()
            self.peakProgressBar.hide()
            self.rexpProgressBar.hide()
        elif self.peakRadio.isChecked():

            self.protonProgressBar.hide()
            self.scatterProgressBar.hide()
            self.monitorProgressBar.hide()
            self.peakProgressBar.show()
            self.rexpProgressBar.hide()
        elif self.rexpRadio.isChecked():

            self.protonProgressBar.hide()
            self.scatterProgressBar.hide()
            self.monitorProgressBar.hide()
            self.peakProgressBar.hide()
            self.rexpProgressBar.show()

    def startCommonProgress(self):
        global CSNSThreadID

        CSNSThreadID += 1
        self.protonProgressThread = updateProgressBar(CSNSThreadID, 1,
                60)
        self.protonProgressThread.partDone.connect(self.updateProtonProgressBar)
        self.protonProgressThread.procDone.connect(self.fin)
        self.protonProgressThread.start()

        CSNSThreadID += 1
        self.scatterProgressThread = updateProgressBar(CSNSThreadID, 1,
                600)
        self.scatterProgressThread.partDone.connect(self.updateScatterProgressBar)
        self.scatterProgressThread.procDone.connect(self.fin)
        self.scatterProgressThread.start()

        CSNSThreadID += 1
        self.monitorProgressThread = updateProgressBar(CSNSThreadID, 1,
                100)
        self.monitorProgressThread.partDone.connect(self.updateMonitorProgressBar)
        self.monitorProgressThread.procDone.connect(self.fin)
        self.monitorProgressThread.start()

        CSNSThreadID += 1
        self.peakProgressThread = updateProgressBar(CSNSThreadID, 1,
                200)
        self.peakProgressThread.partDone.connect(self.updatePeakProgressBar)
        self.peakProgressThread.procDone.connect(self.fin)
        self.peakProgressThread.start()

        CSNSThreadID += 1
        self.rexpProgressThread = updateProgressBar(CSNSThreadID, 1,
                300)
        self.rexpProgressThread.partDone.connect(self.updateRexpProgressBar)
        self.rexpProgressThread.procDone.connect(self.fin)
        self.rexpProgressThread.start()

    def fin(self):
        #print self.rightSplitter.sizes()
        pass


