#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
MenuBar

Created on 2015.12.18
'''

from conf import *
import thread
import threading
import time
import random
from model.globalClass import *
from model.diffractionSimulator import *
from viewer.canvas import *
from viewer.chopperSetting import *

class menuBar(QtGui.QMenuBar):

    def __init__(self, parent=None):
        super(menuBar, self).__init__(parent)
        self.parent = parent
        self.CreateMenuBar()
        self.open_action.triggered.connect(self.file_open)
        self.dataStreaming_action.triggered.connect(self.data_streaming)
        self.offlineData_action.triggered.connect(self.offline_data)
        self.diffractionSimulator_action.triggered.connect(self.diffraction_simulator)
        self.protonSimulator_action.triggered.connect(self.proton_simulator)
        self.choppersetting_action.triggered.connect(self.chopperSetting)

    def CreateMenuBar(self):

        self.file_menu = self.addMenu('File(&F)')
        self.edit_menu = self.addMenu('Edit(&E)')
        self.option_menu = self.addMenu('Options(&O)')
        self.help_menu = self.addMenu('Help(&H)')

        self.open_action = self.file_menu.addAction('Open')
        self.save_action = self.file_menu.addAction('Save')
        self.exit_action = self.file_menu.addAction('Exit')
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap('icon/open.jpg'),
                       QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.open_action.setIcon(icon)
        self.open_action.setShortcut(QtCore.QCoreApplication.translate('MainWindow'
                , 'Ctrl+O'))
        icon2 = QtGui.QIcon()
        icon2.addPixmap(QtGui.QPixmap('icon/save.jpg'),
                        QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.save_action.setIcon(icon2)
        self.save_action.setShortcut(QtCore.QCoreApplication.translate('MainWindow'
                , 'Ctrl+S'))
        icon3 = QtGui.QIcon()
        icon3.addPixmap(QtGui.QPixmap('icon/exit.jpg'),
                        QtGui.QIcon.Normal, QtGui.QIcon.Off)
        self.exit_action.setIcon(icon3)
        self.exit_action.setShortcut(QtCore.QCoreApplication.translate('MainWindow'
                , 'Ctrl+P'))

        self.cut_action = self.edit_menu.addAction('Cut')
        self.copy_action = self.edit_menu.addAction('Copy')
        self.past_action = self.edit_menu.addAction('Paste')

        # Add child menu for Option Menu
        self.selectDataSources_menu = \
            self.option_menu.addMenu('Select Data Sources')
        self.choppersetting_action = \
            self.option_menu.addAction('Chopper Setting')
                
        # Add child menu for Select Data Sources Menu
        self.dataStreaming_action = \
            self.selectDataSources_menu.addAction('Data Streaming')
        self.offlineData_action = \
            self.selectDataSources_menu.addAction('Offline Data')
        self.diffractionSimulator_action = \
            self.selectDataSources_menu.addAction('Diffraction Simulator'
                )
        self.protonSimulator_action = \
            self.selectDataSources_menu.addAction('Proton Simulator'
                )
       
    def chopperSetting(self): 
        self.choppersetting_dialog = CSNSChopperSetting()
        self.choppersetting_dialog.show()

    def file_open(self):
        fileName = QtGui.QFileDialog.getOpenFileName(self, 'title', './'
                , '')  # ,None)
        file = open(fileName,'r')

        with file:
            text = file.read()

        print ('fileName:', fileName)

    def data_streaming(self):

        print 'Data Streaming'

    def offline_data(self):

        print 'Offline Data'

    def diffraction_simulator(self):
        self.parent.updateDiffractionSimulator()
    
    def proton_simulator(self):
        _threadID =101
        self.parent.updateProton(_threadID)
