#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.26

Calibration

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *


class CSNSCalibrationPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSCalibrationPage, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.verticalLayout = QtGui.QVBoxLayout(self)

        first = QtGui.QFrame(self)
        first.setFrameShape(QtGui.QFrame.StyledPanel)
        scrollArea = QtGui.QScrollArea()
        scrollArea.setWidgetResizable(True)
        scrollArea.setWidget(first)

        self.verticalLayout.addWidget(scrollArea)

        self.mainGrid = QtGui.QGridLayout(first)

        # Background

        _xsize = 5
        _ysize = 0.8

        # Background

        self.BackLabel = QtGui.QLabel('Bank')
        self.BackComboBox = QtGui.QComboBox()
        self.BackComboBox.addItem('0:Left Backward')
        self.BackComboBox.addItem('1:Right Backward')
        self.BackComboBox.addItem('2:Left Medium')
        self.BackComboBox.addItem('3:Right Medium')
        self.BackComboBox.addItem('4:Left Small')
        self.BackComboBox.addItem('5:Right Small')

        self.LoadButton = QtGui.QPushButton('Load')
        self.LoadButton.clicked.connect(self.load_file)        

        self.BackCanvas = CSNSCanvas(
            self,
            _xsize, 
            _ysize,
            150,
            'Backward Bank',
            'X',
            'Y',
            )

        self.filexy = ['img/XY ++.png', 'img/XT +-.png']
        
        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[1], 1, 1)

        self.BackImage1 = \
            self.BackCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.PuBu, zorder=2, alpha=0.5)

        #self.filexy = ['img/XY ++.png', 'img/XY +-.png']

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[0], 1, 1)
        self.BackImage2 = \
            self.BackCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.Reds, zorder=1)

        _nline = 0
        self.mainGrid.addWidget(self.BackComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.BackLabel,_nline, 4, 1, 1, QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.LoadButton, _nline, 8, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.BackCanvas, _nline, 1, 1, 7)

    def load_file(self):
        fileName = QtGui.QFileDialog.getOpenFileName(self, 'Open File')
        file = open(fileName,'r')

        with file:
            text = file.read()
            print text
            #self.textEdit.setText(text)
