#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10
'''
import numpy as np
from PyQt4 import QtCore, QtGui
import patternDock
from viewer.menuBar import *
class CSNSPatternPage(QtGui.QMainWindow):

    def __init__(self, parent):
        super(CSNSPatternPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):
        self.patternDock=[]
        self.patternDock.append(patternDock.patternDock(self,
                1, 9, 0.4, 'r', 4000, 'Backward Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                2, 9, 0.4, 'g', 3000, 'Medium-Angle Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                3, 9, 0.4, 'b', 2000, 'Low-Angle Bank'))
        ''' 
        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.firstGrid = QtGui.QGridLayout(self.first)
 
        self.label = QtGui.QLabel("Normalization by ")
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('Monitor')
        self.comboBox.addItem('Proton Charge')

        _nline=0
        self.firstGrid.addWidget(self.label, _nline, 0, 1,1)
        self.firstGrid.addWidget(self.comboBox, _nline, 1, 1,1)
        '''
        #self.choose_menu = self.addMenu('&Normalization by')
        #self.monitor_action = self.choose_menu.addAction('Monitor')
        #self.proton_action = self.choose_menu.addAction('Proton')
        #self.myMenuBar = menuBar(self)
        #self.setMenuBar(self.myMenuBar)

        self.addDockWidget(QtCore.Qt.RightDockWidgetArea,
                           self.patternDock[0])
        self.addDockWidget(QtCore.Qt.RightDockWidgetArea,
                           self.patternDock[1])
        self.addDockWidget(QtCore.Qt.RightDockWidgetArea,
                           self.patternDock[2])
        
        #self.setCentralWidget(self.scrollArea)

        self.comboIndex = [0,0,0]

    def getPatternCanvas(self, n):
        return self.patternDock[n].getCanvas()
    
    def setStatus(self):
        return self.parent.setStatus()

    def updateCanvas(self, value, started, _command): 
        try:
            for i in range(len(self.patternDock)):
                can = self.patternDock[i].canvas
                can.ax.clear()
                if _command in ('configure', 'stop', 'abort'):
                    pass
                else:
                    if not started:
                        pass
                    else:
                        _pause = self.patternDock[i].pauseButton.text()
                        if _pause == 'Pause':
                            _scale = self.patternDock[i].getScale()
                            can.ax.plot(np.divide(value[0][i],_scale), np.divide(value[1][i],_scale), color=can.plotColor)
                        can.ax.relim()
                        can.ax.autoscale_view()
                        can.draw()
        except:
            pass
