#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2016.03.23

ServerSetting
'''

from conf import *
from model.neonConnector import *

class CSNSServerSetting(QtGui.QDialog):

    def __init__(self, parent):
        super(CSNSServerSetting, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QDialog):
        self.setWindowTitle('Data Streaming Server Setting')
        self.resize(200,150)

        self.mainGrid = QtGui.QGridLayout(self)

        self.statusLabel = QtGui.QLabel('<font color=red>X: Server not connected...</font>')
        
        self.ipLabel = QtGui.QLabel('<font color=red>IP</font>')
        self.ipSetLabel = QtGui.QLabel('<font color=black>IP:</font>')
        self.ipSetTextEdit = QtGui.QTextEdit('192.168.1.11')
        self.ipSetTextEdit.setMaximumHeight(30)
        self.ipSetTextEdit.setMinimumWidth(130)
        self.portLabel = QtGui.QLabel('<font color=black>Port:</font>')
        self.portTextEdit.setMaximumHeight(30)
        self.portTextEdit.setMinimumWidth(130)
        
        self.connectButton = QtGui.QPushButton('Connect')
        self.connectButton.clicked.connect(self.connectServer)
        self.startButton = QtGui.QPushButton('Start')
        self.startButton.setEnabled(False)
        self.startButton.clicked.connect(self.startServer)
 
        nrow = -1
        
        nrow = nrow + 1
        self.mainGrid.addWidget(self.statusLabel, nrow, 0, 1, 2, 
                    QtCore.Qt.AlignCenter)
        nrow = nrow + 1
        self.mainGrid.addWidget(self.ipSetLabel, nrow, 0, 1, 1, 
                    QtCore.Qt.AlignLeft)
        self.mainGrid.addWidget(self.ipSetTextEdit, nrow, 1, 1, 1, 
                    QtCore.Qt.AlignLeft)
        nrow = nrow + 1
        self.mainGrid.addWidget(self.portLabel, nrow, 0, 1, 1, 
                    QtCore.Qt.AlignLeft)
        self.mainGrid.addWidget(self.portTextEdit, nrow, 1, 1, 1, 
                    QtCore.Qt.AlignLeft)
        nrow = nrow + 1
        self.mainGrid.addWidget(self.connectButton, nrow, 0, 1, 1, 
                    QtCore.Qt.AlignLeft)
        self.mainGrid.addWidget(self.startButton, nrow, 1, 1, 1, 
                    QtCore.Qt.AlignLeft)

    def getIP(self):
        return self.ipSetTextEdit.toPlainText()

    def getPort(self):
        try:
            return int(self.portTextEdit.toPlainText())
        except:
            return 0

    def connectServer(self):
        try:
            r=neonConnector(self.getIP(), self.getPort())
            if r.isConnected():
                self.statusLabel.setText('<font color=red>O: Server connected...</font>')
                self.connectButton.setEnabled(False)
                self.startButton.setEnabled(True)
            else:
                self.connectButton.setEnabled(True)
                self.startButton.setEnabled(False)
        except:
           self.connectButton.setEnabled(True)
           self.startButton.setEnabled(False)

    def startServer(self):
        if self.startButton.text()=="Start":
            self.startButton.setText("Stop")
            self.parent.data_streaming()
        elif self.startButton.text()=="Stop":
            self.startButton.setText("Start")
            pass
        else:
            pass
