#!/usr/bin/python
# -*- coding: utf-8 -*-
from conf import *
import thread
import threading
from model.globalClass import *
from model.diffractionSimulator import *

from matplotlib.figure import Figure
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.mlab import griddata
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D


class updateStreamingMonitor(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        color,
        simulatorStreaming,
        ):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.simulatorStreaming = simulatorStreaming
        self.can = can
        self.ax = ax
        self.can_run = threading.Event()

        self.lines = self.ax.plot(self.simulatorStreaming.MX,
                                  self.simulatorStreaming.MY,
                                  color=color)
    def process(self):
        self.lines[0].set_xdata(self.simulatorStreaming.MX)
        self.lines[0].set_ydata(self.simulatorStreaming.MY)

        self.ax.relim()
        self.ax.autoscale_view()
        self.can.draw()

    def run(self):
        while True:
            if not self.can_run.isSet():
                delay = 1
                time.sleep(delay)
                try:
                    self.process()
                except:
                    break
                finally:
                    pass

    def pause(self):
        self.can_run.clear()

    def resume(self):
        self.can_run.set()

class updateStreaming2D(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        constant,
        color,
        simulatorStreaming,
        ):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.color = color
        self.simulatorStreaming = simulatorStreaming
        self.can = can
        self.ax = ax
        self.constant = constant
        self.can_run = threading.Event()

    def process(self):
        self.ax.clear()
        self.ax.plot(self.simulatorStreaming.X * self.constant,
                     self.simulatorStreaming.Y,
                     color=self.color)

        self.ax.relim()
        self.ax.autoscale_view()
        self.can.draw() 

    def run(self):
        while True:
            if not self.can_run.isSet():
                try:
                    self.process() 
                except:
                    break
                finally:
                    pass

    def pause(self):
        self.can_run.set()

    def resume(self):
        self.can_run.clear()

class updateStreaming3D(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        cmap,
        simulatorStreaming,
        ):
        threading.Thread.__init__(self)
        self.threadID = threadID
        self.simulatorStreaming = simulatorStreaming
        self._x = self.simulatorStreaming.Xaxis
        self._y = self.simulatorStreaming.Yaxis
        self.can = can
        self.ax = ax
        self.cmap = cmap
        self.can_run = threading.Event()

    def process(self):
        self.ax.pcolormesh(self._x, self._y, self._z, cmap=self.cmap)
        self.can.draw()

    def run(self):
        while True:
            if not self.can_run.isSet():
                self._z = self.simulatorStreaming.XY
                delay = 1
                time.sleep(delay)
                try:
                    self.process()
                except:
                    break
                finally:
                    pass
 
    def pause(self):
        self.can_run.clear()

    def resume(self):
        self.can_run.set()

class updateProtonCharge(threading.Thread):

    def __init__(
        self,
        threadID,
        can,
        ax,
        color,
        queue,
        ):
        threading.Thread.__init__(self)
        self.threadID=threadID
        self.color = color
        self.can = can
        self.ax = ax
        self.queue=queue
        self.can_run = threading.Event()
        self.thing_done = threading.Event()
        self.thing_done.set()
        self.can_run.set()

    def process(self, result):
        self.ax.clear()
        self.ax.plot(result, color=self.color)

        self.ax.relim()
        self.ax.autoscale_view()
        self.can.draw()
         
    def run(self):
        while True:
            if not self.can_run.isSet():
                result=self.queue.get()
                try:
                    self.process(result)
                except:
                    break
                finally:
                    pass
                self.thing_done.set()

            self.queue.task_done()

    def pause(self):
        self.can_run.clear()

    def resume(self):
        self.can_run.set()
