#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Created on 2015.6.4

Analysis

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from hotimage import *
from histogram import *

class CSNSAnalysisPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSAnalysisPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        self.HistogramTab = CSNSHistogramPage()
        self.HotimageTab = CSNSHotimagePage()

        # self.mainFrame = QtGui.QFrame(self.XYTab)
        # self.mainFrame.setFrameShape(QtGui.QFrame.StyledPanel)
        # self.scrollArea = QtGui.QScrollArea()
        # self.scrollArea.setWidgetResizable(True)
        # self.scrollArea.setWidget(self.mainFrame)

        self.addTab(self.HistogramTab, 'Histogram')
        self.addTab(self.HotimageTab, 'Hotimage')

    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        return self.HistogramTab.updateBackwardStreaming(threadID, simulatorStreaming)

    def updateMediumStreaming(self, threadID, simulatorStreaming):
        return self.HistogramTab.updateMediumStreaming(threadID, simulatorStreaming)

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        return self.HistogramTab.updateSmallStreaming(threadID, simulatorStreaming)

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        return self.HistogramTab.updateMonitorStreaming(threadID, simulatorStreaming)
    
    def updateBackward3DStreaming(self, threadID, simulatorStreaming):
        return self.HistogramTab.updateBackward3DStreaming(threadID, simulatorStreaming)
    
    def updateMedium3DStreaming(self, threadID, simulatorStreaming):
        return self.HistogramTab.updateMedium3DStreaming(threadID, simulatorStreaming)
    
    def updateSmall3DStreaming(self, threadID, simulatorStreaming):
        return self.HistogramTab.updateSmall3DStreaming(threadID, simulatorStreaming)
