#!/usr/bin/python
# -*- coding: utf-8 -*-
from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from chopper import *
from sample import *
from analysis import *
from calibration import *
from reduction import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent=None):
        super(CSNSMainTab, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.chopperPage = CSNSChopperPage()
        self.samplePage = CSNSSamplePage()
        self.analysisPage = CSNSAnalysisPage()
        self.calibrationPage = CSNSCalibrationPage()
        self.reductionPage = CSNSReductionPage()

        self.tfvalue = TimeFrameCalculation(0.5, 6.0)
        (pulseList, chopperList, timeList, xList, yList) = \
            self.tfvalue.getTimeFrame()
        self.chopperPage.updateTimeFrame(pulseList, chopperList,
                timeList, xList, yList)

        self.addTab(self.chopperPage, 'Chopper')
        self.addTab(self.samplePage, 'Sample')
        self.addTab(self.analysisPage, 'Analysis')
        self.addTab(self.calibrationPage, 'Calibration')
        self.addTab(self.reductionPage, 'Reduction')

    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        return self.analysisPage.updateBackwardStreaming(threadID, simulatorStreaming)

    def updateBankStreaming(self, threadID, simulatorStreaming):
        return self.analysisPage.updateBankStreaming(threadID, simulatorStreaming)

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        return self.analysisPage.updateSmallStreaming(threadID, simulatorStreaming)

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        return self.analysisPage.updateMonitorStreaming(threadID, simulatorStreaming)
