#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2015.9.25
'''

from conf import *

# user defined

from viewer.runList import *
from viewer.runData import *
from viewer.mainTab import *
from viewer.subTab import *
from viewer.menuBar import *
from viewer.statusBar import *

class mywindow(QtGui.QMainWindow):

    def __init__(self):
        super(mywindow, self).__init__()
        self.setupUi(self)

    def setupUi(self, MainWindow):

        self.myMenuBar = menuBar(self)
        self.setMenuBar(self.myMenuBar)

        self.myStatusBar = statusBar(self)
        self.setStatusBar(self.myStatusBar)

        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)

        self.leftSplitter = QtGui.QSplitter(QtCore.Qt.Vertical, self)
        self.rightSplitter = QtGui.QSplitter(QtCore.Qt.Vertical, self)

        self.upLeftListWidget = CSNSRunList(self.leftSplitter)
        self.downLeftFigure = CSNSRunData(self.leftSplitter)

        self.upRightTab = CSNSMainTab(self.rightSplitter)
        self.downRightTab = CSNSSubTab(self.rightSplitter)

        self.leftSplitter.setSizes([600, 200])
        self.rightSplitter.setSizes([700, 100])

        self.leftSplitter.addWidget(self.upLeftListWidget)
        self.leftSplitter.addWidget(self.downLeftFigure)
        self.rightSplitter.addWidget(self.upRightTab)
        self.rightSplitter.addWidget(self.downRightTab)
        self.mainSplitter.addWidget(self.leftSplitter)
        self.mainSplitter.addWidget(self.rightSplitter)

        self.setCentralWidget(self.mainSplitter)

    def btnExit(self):
        if self.pushButton.text() == 'Let it go':
            print self.pushButton.text()
            self.pushButton.setText("I'm still here!")
        else:
            print self.pushButton.text()
            self.pushButton.setText('Let it go')

    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        return self.upRightTab.updateBackwardStreaming(threadID, simulatorStreaming)

    def updateBankStreaming(self, threadID, simulatorStreaming):
        return self.upRightTab.updateBankStreaming(threadID, simulatorStreaming)

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        return self.upRightTab.updateSmallStreaming(threadID, simulatorStreaming)

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        return self.upRightTab.updateMonitorStreaming(threadID, simulatorStreaming)

def main():
    myapp = QtGui.QApplication(sys.argv)
    mytop = mywindow()
    mytop.setWindowTitle('GPPD')
    mytop.resize(1200, 800)
    mytop.show()
    sys.exit(myapp.exec_())


if __name__ == '__main__':

    # if __package__ is None:
        # sys.path.append( path.dirname( path.dirname( path.abspath(__file__) ) ) )

    main()
