#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''
import Queue
from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *

class CSNSExperimentPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSExperimentPage, self).__init__(parent)
        self.inQueue=Queue.Queue()
        self.outQueue=Queue.Queue()
        self.setupUi(self)
        self.minRange = 1
        self.maxRange = 60
        self.protonConstant = True
        self.scatterConstant = False
        self.monitorConstant = False
        self.peakConstant = False
        self.rexpConstant = False
        self.middleProtonRange = 0
        self.middleScatterRange = 0
        self.middleMonitorRange = 0
        self.middlePeakRange = 0
        self.middleRexpRange = 0

    def __del__(self):
        #self.getThread.stop_event.set()
        #self.putThread.stop_event.set()
        pass       
 
    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        _xsize = 3
        _ysize = 0.5

        # Measurement Time
        self.timeLabel = QtGui.QLabel('Measurement Time:')
        self.timeProgressBar = QtGui.QProgressBar(self)     
        self.timeProgressThread = updateProgressBar(121,1, 3600)
        self.timeProgressThread.partDone.connect(self.updateTimeProgressBar)
        self.timeProgressThread.procDone.connect(self.fin)
        self.timeProgressThread.start()
 
        # Proton Charge
        self.protonRadio = QtGui.QRadioButton() 
        self.protonRadio.setChecked(True)
        self.protonLabel = QtGui.QLabel('Proton Charge:')

        self.protonCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        
        # Scattered Neutron Counts
        self.scatterRadio = QtGui.QRadioButton() 
        self.scatterLabel = QtGui.QLabel('Scattered Neutron Counts:')

        self.scatterCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Incident Neutron Counts
        self.monitorRadio = QtGui.QRadioButton() 
        self.monitorLabel = QtGui.QLabel('Incident Neutron Counts:')

        self.monitorCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )


        # Peak Intensity
        self.peakRadio = QtGui.QRadioButton() 
        self.peakLabel = QtGui.QLabel('Peak Intensity:')

        self.peakCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Rexp Factor 
        self.rexpRadio = QtGui.QRadioButton() 
        self.rexpLabel = QtGui.QLabel('Rexp Factor:')
        
        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.protonRadio)
        self.RadioGroup.addButton(self.scatterRadio)
        self.RadioGroup.addButton(self.monitorRadio)
        self.RadioGroup.addButton(self.peakRadio)
        self.RadioGroup.addButton(self.rexpRadio)
        self.RadioGroup.buttonClicked.connect(self.RadioButtonChoose)

        self.rexpCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Common ProgressBar
        self.commonProgressBar = QtGui.QProgressBar(self)

        self.startCommonProgress(111 ,1, 600)
        
        _nline = 0
        self.mainGrid.addWidget(
            self.timeLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.timeProgressBar, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.protonRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.protonLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.protonCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.scatterRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.scatterLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.scatterCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.monitorRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.monitorLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.monitorCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.peakRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.peakLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.peakCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.rexpRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.rexpLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.rexpCanvas, _nline, 2, 1, 1)
        
        _nline += 1
        self.mainGrid.addWidget(self.commonProgressBar, _nline, 2, 1, 1)

        #self.inQueue.join()
        #self.outQueue.join()

    def startProtonSimulator(self):
        self.putProton()
        self.getProton()

        #for i in range(int(1E6)):
        #    self.inQueue.put_nowait(i)        
        #    self.inQueue.join()        

    def putProton(self):
        global CSNSThreadID
        CSNSThreadID+=1
        self.putThread = protonSimulator(
            CSNSThreadID,
            self.inQueue,
            self.outQueue,
            )

        self.putThread.setDaemon(True)
        self.putThread.start()

    def getProton(self):        
        global CSNSThreadID
        CSNSThreadID+=1
        self.getThread = updateProtonCharge(CSNSThreadID, self.protonCanvas,self.protonCanvas.ax, 'g', self.outQueue)
        self.getThread.setDaemon(True)
        self.getThread.start()

    def putProtonIsAlive(self):
        try:
            return self.putThread.isAlive()
        except:
            return False

    def getProtonIsAlive(self):
        try:
            return self.getThread.isAlive()
        except:
            return False

    def updateTimeProgressBar(self, val):
        self.timeProgressBar.setValue(val)
        perct = "{0}%".format(val)

    def updateProtonProgressBar(self, val):
        self.commonProgressBar.setValue(val)
        perct = "{0}%".format(val)
        self.middleProtonRange = val

    def updateScatterProgressBar(self, val):
        self.commonProgressBar.setValue(val)
        perct = "{0}%".format(val)
        self.middleScatterRange = val 

    def updateMonitorProgressBar(self, val):
        self.commonProgressBar.setValue(val)
        perct = "{0}%".format(val)
        self.middleMonitorRange = val 

    def updatePeakProgressBar(self, val):
        self.commonProgressBar.setValue(val)
        perct = "{0}%".format(val)
        self.middlePeakRange = val 

    def updateRexpProgressBar(self, val):
        self.commonProgressBar.setValue(val)
        perct = "{0}%".format(val)
        self.middleRexpRange = val 
    
    def RadioButtonChoose(self):
        if self.protonRadio.isChecked():
            self.minProtonRange = 1
            self.maxProtonRange = 60
            self.protonConstant = True
            self.scatterConstant = False
            self.monitorConstant = False
            self.peakConstant = False
            self.rexpConstant = False
        elif self.scatterRadio.isChecked():
            self.minScatterRange = 1
            self.maxScatterRange = 600
            self.protonConstant = False
            self.scatterConstant = True
            self.monitorConstant = False
            self.peakConstant = False
            self.rexpConstant = False
        elif self.monitorRadio.isChecked():
            self.minMonitorRange = 1
            self.maxMonitorRange = 100
            self.protonConstant = False
            self.scatterConstant = False
            self.monitorConstant = True
            self.peakConstant = False
            self.rexpConstant = False
        elif self.peakRadio.isChecked():
            self.minPeakRange = 1
            self.maxPeakRange = 200
            self.protonConstant = False
            self.scatterConstant = False
            self.monitorConstant = False
            self.peakConstant = True
            self.rexpConstant = False
        elif self.rexpRadio.isChecked():
            self.minRexpRange = 1
            self.maxRexpRange = 300
            self.protonConstant = False
            self.scatterConstant = False
            self.monitorConstant = False
            self.peakConstant = False
            self.rexpConstant = True
        
        if self.protonConstant:
            self.minProtonRange = self.middleProtonRange
            self.commonProgressThread.stop()
            global CSNSThreadID

            CSNSThreadID += 1
            self.commonProgressThread = updateProgressBar(CSNSThreadID, self.minProtonRange, self.maxProtonRange)
            self.commonProgressThread.partDone.connect(self.updateProtonProgressBar)
            self.commonProgressThread.procDone.connect(self.fin)
            self.commonProgressThread.start()
        elif self.scatterConstant:
            self.minScatterRange = self.middleScatterRange
            self.commonProgressThread.stop()

            CSNSThreadID += 1
            self.commonProgressThread = updateProgressBar(CSNSThreadID, self.minScatterRange, self.maxScatterRange)
            self.commonProgressThread.partDone.connect(self.updateScatterProgressBar)
            self.commonProgressThread.procDone.connect(self.fin)
            self.commonProgressThread.start()
        elif self.monitorConstant:
            self.minMonitorRange = self.middleMonitorRange
            self.commonProgressThread.stop()

            CSNSThreadID += 1
            self.commonProgressThread = updateProgressBar(CSNSThreadID, self.minMonitorRange, self.maxMonitorRange)
            self.commonProgressThread.partDone.connect(self.updateMonitorProgressBar)
            self.commonProgressThread.procDone.connect(self.fin)
            self.commonProgressThread.start()
        elif self.peakConstant:
            self.minPeakRange = self.middlePeakRange
            self.commonProgressThread.stop()

            CSNSThreadID += 1
            self.commonProgressThread = updateProgressBar(CSNSThreadID, self.minPeakRange, self.maxPeakRange)
            self.commonProgressThread.partDone.connect(self.updatePeakProgressBar)
            self.commonProgressThread.procDone.connect(self.fin)
            self.commonProgressThread.start()
        elif self.rexpConstant:
            self.minRexpRange = self.middleRexpRange
            self.commonProgressThread.stop()

            CSNSThreadID += 1
            self.commonProgressThread = updateProgressBar(CSNSThreadID, self.minRexpRange, self.maxRexpRange)
            self.commonProgressThread.partDone.connect(self.updateRexpProgressBar)
            self.commonProgressThread.procDone.connect(self.fin)
            self.commonProgressThread.start()
 
    def startCommonProgress(self,threadID,min,max):
        self.commonProgressThread = updateProgressBar(threadID, min, max)
        self.commonProgressThread.partDone.connect(self.updateProtonProgressBar)
        self.commonProgressThread.procDone.connect(self.fin)
        self.commonProgressThread.start()

    def fin(self):
        pass
    
    def getCommonProgress(self,min,max):
        global CSNSThreadID

        CSNSThreadID += 1
        self.startCommonProgress(CSNSThreadID, min, max)
    
    def startProtonSimulator(self):
        self.getProton()
        self.getCommonProgress()
