#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from experiment import *
from histogram import *
from detector import *
from monitor import *
from model.chopperModel import *

class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.histogramPage = CSNSHistogramPage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.histogramPage, 'Diffraction Pattern')
        self.addTab(self.detectorPage, 'Detector Counts')
        self.addTab(self.monitorPage, 'Monitor Counts')
        self.addTab(self.experimentPage, 'Experiment Progress')

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getNeutronCanvas(self):
        return self.experimentPage.getNeutronCanvas()
    
    def getImageCanvas(self):
        return self.histogramPage.getImageCanvas()

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()

