#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *


class CSNSHistogramPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSHistogramPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        _xsize = 5
        _ysize = 0.8

        # Backward TOF/d

        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem('TOF')
        self.BackwardComboBox.addItem('d')
        self.BackwardComboBox.activated.connect(self.BackwardComboboxChoose)
        
        self.BackwardCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # 90-Bank TOF/d

        self.MediumComboBox = QtGui.QComboBox()
        self.MediumComboBox.addItem('TOF')
        self.MediumComboBox.addItem('d')
        self._index1 = self.MediumComboBox.currentIndex()
        self.MediumComboBox.activated.connect(self.MediumComboboxChoose)

        self.MediumCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small-angle bank TOF/d

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('TOF')
        self.SmallComboBox.addItem('d')
        self._index2 = self.SmallComboBox.currentIndex()
        self.SmallComboBox.activated.connect(self.SmallComboboxChoose)
        
        self.SmallCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Monitor TOF/d

        self.MonitorCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Backward bank 3D

        self.Backward3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Medium bank 3D

        self.Medium3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small bank 3D

        self.Small3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        _nline = 0
        self.mainGrid.addWidget(
            self.BackwardCanvas,
            _nline,
            0,
            1,
            4,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.BackwardComboBox, _nline, 4, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(
            self.MediumCanvas,
            _nline,
            0,
            1,
            4,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.MediumComboBox, _nline, 4, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(
            self.SmallCanvas,
            _nline,
            0,
            1,
            4,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.SmallComboBox, _nline, 4, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.MonitorCanvas, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.Backward3DCanvas, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.Medium3DCanvas, _nline, 2, 1, 1)
        self.mainGrid.addWidget(self.Small3DCanvas, _nline, 3, 1, 1)

    def BackwardComboboxChoose(self):
        self.index = self.BackwardComboBox.currentIndex()
        if self.index == 0:
            self.BackwardConstant = 40000    
        elif self.index == 1:
            self.BackwardConstant = 1
        self.BackwardThread.stop()
        
        self.BackwardThread = updateStreaming2D(self.BackwardThreadID,self.BackwardCanvas,
                self.BackwardCanvas.ax, self.BackwardConstant, 'r', self.BackwardSimulatorStreaming)
        self.BackwardThread.setDaemon(True)
        self.BackwardThread.start()

    def MediumComboboxChoose(self):
        self.index = self.MediumComboBox.currentIndex()
        if self.index == 0:
            self.MediumConstant = 30000       
        elif self.index == 1:
            self.MediumConstant = 1
        self.MediumThread.stop()
        
        self.MediumThread = updateStreaming2D(self.MediumThreadID,self.MediumCanvas,
                self.MediumCanvas.ax, self.MediumConstant, 'g', self.MediumSimulatorStreaming)
        self.MediumThread.setDaemon(True)
        self.MediumThread.start()

    def SmallComboboxChoose(self):
        self.index = self.SmallComboBox.currentIndex()
        if self.index == 0:
            self.SmallConstant = 20000       
        elif self.index == 1:
            self.SmallConstant = 1
        self.SmallThread.stop()
        
        self.SmallThread = updateStreaming2D(self.SmallThreadID,self.SmallCanvas,
                self.SmallCanvas.ax, self.SmallConstant, 'b', self.SmallSimulatorStreaming)
        self.SmallThread.setDaemon(True)
        self.SmallThread.start()
     
    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        self.BackwardThreadID = threadID
        self.BackwardSimulatorStreaming = simulatorStreaming
        
        self.BackwardThread = updateStreaming2D(self.BackwardThreadID,self.BackwardCanvas, 
                self.BackwardCanvas.ax, CSNSBackwardConstant , 'r', self.BackwardSimulatorStreaming)
        self.BackwardThread.setDaemon(True)
        self.BackwardThread.start()
        return self.BackwardThread

    def updateMediumStreaming(self, threadID, simulatorStreaming):
        self.MediumThreadID = threadID
        self.MediumSimulatorStreaming = simulatorStreaming
        self.MediumThread = updateStreaming2D(self.MediumThreadID, self.MediumCanvas,
                self.MediumCanvas.ax,CSNSMediumConstant, 'g', self.MediumSimulatorStreaming)
        self.MediumThread.setDaemon(True)
        self.MediumThread.start()
        return self.MediumThread

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        self.SmallThreadID = threadID
        self.SmallSimulatorStreaming = simulatorStreaming
        self.SmallThread = updateStreaming2D(self.SmallThreadID, self.SmallCanvas,
                self.SmallCanvas.ax, CSNSSmallConstant,'b', self.SmallSimulatorStreaming)
        self.SmallThread.setDaemon(True)
        self.SmallThread.start()
        return self.SmallThread

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        MonitorThread = updateStreamingMonitor(threadID,
                self.MonitorCanvas, self.MonitorCanvas.ax, 'y',
                simulatorStreaming)
        MonitorThread.start()
        return MonitorThread

    def updateBackward3DStreaming(self, threadID, simulatorStreaming):
        Backward3DThread = updateStreaming3D(threadID,
                self.Backward3DCanvas, self.Backward3DCanvas.ax,
                'Accent', simulatorStreaming)
        Backward3DThread.start()
        return Backward3DThread

    def updateMedium3DStreaming(self, threadID, simulatorStreaming):
        Medium3DThread = updateStreaming3D(threadID,
                self.Medium3DCanvas, self.Medium3DCanvas.ax, 'Spectral'
                , simulatorStreaming)
        Medium3DThread.start()
        return Medium3DThread

    def updateSmall3DStreaming(self, threadID, simulatorStreaming):
        Small3DThread = updateStreaming3D(threadID, self.Small3DCanvas,
                self.Small3DCanvas.ax, 'cool', simulatorStreaming)
        Small3DThread.start()
        return Small3DThread
