#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2017.05.11

Experiment

'''

from conf.constants import *

import time
import Queue
from canvas import *
from model.readData import *
from model.readImage import *
from model.protonSimulator import *
from model import neutronCounts
from presenter.updateStreaming import *
from presenter.progressBarThread import *
import numpy as np

class CSNSExperimentPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSExperimentPage, self).__init__(parent)
        self.inQueue = Queue.Queue()
        self.outQueue = Queue.Queue()
        self.setupUi(self)
        self.minRange = 1
        self.maxRange = 60

        self.protonConstant = True
        self.neutronConstant = False
        self.pulseConstant = False

        self.middleProtonRange = 0
        self.middleNeutronRange = 0
        self.middlePluseRange = 0

    def __del__(self):

        # self.getThread.stop_event.set()
        # self.putThread.stop_event.set()

        pass

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 3
        _ysize = 0.5

        # Proton Charge
        self.protonRadio = QtGui.QRadioButton()
        self.protonRadio.setChecked(True)
        self.protonLabel = QtGui.QLabel('Proton Charge:')

        self.protonCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'm',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Neutron Counts
        self.neutronRadio = QtGui.QRadioButton()
        self.neutronLabel = QtGui.QLabel('Neutron Counts:')

        self.neutronCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'r',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # pulse Counts
        self.pulseRadio = QtGui.QRadioButton()
        self.pulseLabel = QtGui.QLabel('Pulse Counts:')

        self.pulseCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'c',
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.protonRadio)
        self.RadioGroup.addButton(self.neutronRadio)
        self.RadioGroup.addButton(self.pulseRadio)
        self.RadioGroup.buttonClicked.connect(self.RadioButtonChoose)

        _nline = 0
        self.mainGrid.addWidget(self.protonRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.protonLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.protonCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.neutronRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.neutronLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.neutronCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.pulseRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.pulseLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.pulseCanvas, _nline, 2, 1, 1)

        self.verticalLayout.addWidget(self.scrollArea)

        # self.inQueue.join()
        self.beginTime = time.time()

    def RadioButtonChoose(self):
        pass

    def updateCanvas(self, value, started, _command):
        self.protonCanvas.ax.clear()
        self.neutronCanvas.ax.clear()
        self.pulseCanvas.ax.clear()
        if _command in ('configure', 'stop', 'abort'):
            pass
        else:
            try:
                if not started:
                    pass
                else:
                    self.protonCanvas.ax.plot(value[0][0], value[0][1], color=self.protonCanvas.plotColor)
                    self.protonCanvas.ax.relim()
                    self.protonCanvas.ax.autoscale_view()
                    self.protonCanvas.draw()
            except:
                pass

            try:
                if not started:
                    pass
                else:
                    self.neutronCanvas.ax.plot(value[1][0], value[1][1], color=self.neutronCanvas.plotColor)
                    self.neutronCanvas.ax.relim()
                    self.neutronCanvas.ax.autoscale_view()
                    self.neutronCanvas.draw()
            except:
                pass

            try:
                if not started:
                    pass
                else:
                    self.pulseCanvas.ax.plot(value[2][0], value[2][1], color=self.pulseCanvas.plotColor)
                    self.pulseCanvas.ax.relim()
                    self.pulseCanvas.ax.autoscale_view()
                    self.pulseCanvas.draw()
            except:
                pass
