#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import time
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure
from redis.sentinel import Sentinel

from conf.constants import *
from model import neonReceiver
from viewer import canvas

class CSNSUserInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSUserInfo, self).__init__(parent)
        self.setupUi(self)

        self.parent = parent
        self.controlThread = None

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreafirst = QtGui.QScrollArea()
        self.scrollAreafirst.setWidgetResizable(True)
        self.scrollAreafirst.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreasecond = QtGui.QScrollArea()
        self.scrollAreasecond.setWidgetResizable(True)
        self.scrollAreasecond.setWidget(self.second)

        self.timeF = QtGui.QFrame(self)
        self.timeF.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaTime = QtGui.QScrollArea()
        self.scrollAreaTime.setWidgetResizable(True)
        self.scrollAreaTime.setWidget(self.timeF)

        self.delayF = QtGui.QFrame(self)
        self.delayF.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaDelay = QtGui.QScrollArea()
        self.scrollAreaDelay.setWidgetResizable(True)
        self.scrollAreaDelay.setWidget(self.delayF)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreathird = QtGui.QScrollArea()
        self.scrollAreathird.setWidgetResizable(True)
        self.scrollAreathird.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollAreafirst)
        self.splitter.addWidget(self.scrollAreasecond)
        self.splitter.addWidget(self.scrollAreaTime)
        self.splitter.addWidget(self.scrollAreaDelay)
        self.splitter.addWidget(self.scrollAreathird)
        self.splitter.setSizes([100, 170, 100, 120, 300])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.timeGrid = QtGui.QGridLayout(self.timeF)
        self.delayGrid = QtGui.QGridLayout(self.delayF)
        self.thirdGrid = QtGui.QGridLayout(self.third)

    	# main verticalLayout
        self.GPPDLabel = QtGui.QLabel('<font color=red>GPPD</font>')
        self.GPPDLabel.setFont(QtGui.QFont('Roman times', 20,
                               QtGui.QFont.Bold))
        self.spectLabel = QtGui.QLabel('<font color=black>Instrument Scientist: Lunhua He</font>')
        self.developLabel = QtGui.QLabel('<font size=2 color=black>Software Engineer: Lili Yan(347)</font>')

        self.verticalLayout.addWidget(self.GPPDLabel)
        self.verticalLayout.addWidget(self.spectLabel)
        self.verticalLayout.addWidget(self.developLabel)
        self.verticalLayout.addWidget(self.splitter)

    	# first Grid
        self.userIDLabel = QtGui.QLabel('UserID: ', self.first)
        self.userIDText = QtGui.QLabel('--------', self.first)

        self.runNoLabel = QtGui.QLabel('RunNo: ', self.first)
        self.runNoText = QtGui.QLabel('--------', self.first)

        self.proposalLabel = QtGui.QLabel('ProposalID: ', self.first)
        self.proposalText = QtGui.QLabel('--------', self.first)

    	# second Grid
        self.neonLabel = QtGui.QLabel('NEON:', self.second)
        self.neonConnectLabel = QtGui.QLabel('',
                self.second)
        self.neonConnectLabel.setFixedSize(QtCore.QSize(80, 30))

        self.commandLabel = QtGui.QLabel('Command: ', self.second)

        self.commandTimeLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel.setStyleSheet("color:green")
        
        self.statusLabel = QtGui.QLabel('State: ', self.second)
        self.statusTimeLabel = QtGui.QLabel('', self.second)
        if len(sys.argv) == 1: 
            self.statusValueLabel = QtGui.QLabel('None', self.second)
        else:
            self.statusValueLabel = QtGui.QLabel('Read only', self.second)
        self.statusValueLabel.setStyleSheet("color:blue")

        # third Grid
        with plt.xkcd():
            self.runCanvas=canvas.xkcdFigure(self)
        
        self.currentTimeLabel = \
            QtGui.QLabel('<font color=red>Current Time:</font>')
        self.currentTimeText = QtGui.QLabel('------')
        self.currentTimeText.setStyleSheet('color:red')
        self.currentTimer = QtCore.QTimer(self)
        self.labelConstant = True
        self.currentTimer.timeout.connect(self.changeTime)
        self.currentTimer.start(1000)

        self.m1DelayLabel = QtGui.QLabel('<font color=red>M1 Delay Time:</font>')
        self.m1DelayText = QtGui.QLabel('------')
        self.m1DelayText.setStyleSheet('color:red')
        self.m2DelayLabel = QtGui.QLabel('<font color=red>M2 Delay Time:</font>')
        self.m2DelayText = QtGui.QLabel('------')
        self.m2DelayText.setStyleSheet('color:red')
        self.m3DelayLabel = QtGui.QLabel('<font color=red>M3 Delay Time:</font>')
        self.m3DelayText = QtGui.QLabel('------')
        self.m3DelayText.setStyleSheet('color:red')
        self.detectorDelayLabel = QtGui.QLabel('<font color=red>Detector Delay Time:</font>')
        self.detectorDelayText = QtGui.QLabel('------')
        self.detectorDelayText.setStyleSheet('color:red')
        self.startTimeLabel = QtGui.QLabel('<font color=red>Start Time:</font>')
        self.startTimeText = QtGui.QLabel('------')
        self.startTimeText.setStyleSheet('color:red')
        self.endTimeLabel = QtGui.QLabel('<font color=red>End Time:</font>')
        self.endTimeText = QtGui.QLabel('------')
        self.endTimeText.setStyleSheet('color:red')
    
        self.protonLabel = QtGui.QLabel('Proton Charge: ')
        self.protonText = QtGui.QLabel('-----')

        self.detectorLabel = QtGui.QLabel('Detector Counts: ')
        self.detectorText = QtGui.QLabel('------')
        self.detectorRateLabel = QtGui.QLabel('    Counting Rates: ')
        self.detectorRateText = QtGui.QLabel('------')
        self.monitorLabel = QtGui.QLabel('Monitor Counts: ')
        self.monitorText = QtGui.QLabel('------')
        self.monitorRateLabel = QtGui.QLabel('     Counting Rates: ')
        self.monitorRateText = QtGui.QLabel('------')        

        _nline = 0
        self.firstGrid.addWidget(self.userIDLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.userIDText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.runNoLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.runNoText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.proposalLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.proposalText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline = 0
        self.secondGrid.addWidget(self.neonLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.neonConnectLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.commandLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.commandValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.commandTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.statusLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.statusValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.statusTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)

        _nline = 0
        self.delayGrid.addWidget(self.m1DelayLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.delayGrid.addWidget(self.m1DelayText,_nline,1,1,1,QtCore.Qt.AlignLeft,)
        _nline += 1
        self.delayGrid.addWidget(self.m2DelayLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.delayGrid.addWidget(self.m2DelayText,_nline,1,1,1,QtCore.Qt.AlignLeft,)
        _nline += 1
        self.delayGrid.addWidget(self.m3DelayLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.delayGrid.addWidget(self.m3DelayText,_nline,1,1,1,QtCore.Qt.AlignLeft,)
        _nline += 1
        self.delayGrid.addWidget(self.detectorDelayLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.delayGrid.addWidget(self.detectorDelayText,_nline,1,1,1,QtCore.Qt.AlignLeft,)

        _nline = 0
        self.timeGrid.addWidget(self.currentTimeLabel,_nline,0,1,1)
        self.timeGrid.addWidget(self.currentTimeText,_nline,1,1,1)
        _nline += 1
        self.timeGrid.addWidget(self.startTimeLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.timeGrid.addWidget(self.startTimeText,_nline,1,1,1,QtCore.Qt.AlignLeft,)
        _nline += 1
        self.timeGrid.addWidget(self.endTimeLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.timeGrid.addWidget(self.endTimeText,_nline,1,1,1,QtCore.Qt.AlignLeft,)
        _nline += 1
        self.thirdGrid.addWidget(
            self.protonLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.protonText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.detectorLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.detectorText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.detectorRateLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.detectorRateText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.monitorLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.monitorText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.monitorRateLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.monitorRateText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.runCanvas,
            _nline,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        #self.thirdGrid.addItem(QtGui.QSpacerItem(-1, -1,
        #                       QtGui.QSizePolicy.Ignored,
        #                       QtGui.QSizePolicy.Expanding), 2, 0)


        self.dataThread = False
        self.pix = None

    def changeTime(self):
        timenow = time.strftime('%Y-%m-%d %H:%M:%S')
        self.currentTimeText.setText(timenow)

    def setNeonStatus(self, value):
        if value:
            self.neonConnectLabel.setText('connected')
        else:
            self.neonConnectLabel.setText('disconnected')

    def getIP_PORT(self):
        #ip = '10.1.53.240'
        ip = '10.1.33.141'
        _ip_port = [(ip, 9001), (ip,9011)]
        return _ip_port

    def getNeon(self):
        status=False
        writeServer=None
        readServer=None

        _timeout=10
        _ip_port=self.getIP_PORT()
        _passwd='sanlie;123'
        _r=neonReceiver.connectNeon(_ip_port, _passwd, _timeout)
        status=_r.getStatus()
        writeServer=_r.getRedisWrite()
        readServer=_r.getRedisRead()
        
        return status, writeServer, readServer

    def setUserInfo(self, value):
        try:
            _value = json.loads(str(value))
            self.userIDText.setText(str(_value['userID']))
            self.runNoText.setText(str(_value['runNo']))
            self.proposalText.setText(str(_value['proposalID']))
            
            self.m1DelayText.setText(str(_value['m1Delay']))
            self.m2DelayText.setText(str(_value['m2Delay']))
            self.m3DelayText.setText(str(_value['m3Delay']))
            self.detectorDelayText.setText(str(_value['detectorDelay']))
        except:
            pass

    # get from neon
    def setCommandLabel(self, value):
        _timen=str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        self.setCommandTimeLabel(_timen)
        self.setCommandValueLabel(value)

    def setCommandTimeLabel(self, time):
        self.commandTimeLabel.setText(time)

    def setCommandValueLabel(self, value):
        self.commandValueLabel.setText(value)
    
    # get from neon
    def setStatusLabel(self, value):
        myStatus = self.statusValueLabel.text()
        _timen=str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        if myStatus != value: 
            self.setStatusTimeLabel(_timen)
            self.setStatusValueLabel(value)
            logging.info(str("status is " + value + ' now')) 

    def setStatusTimeLabel(self, time):
        self.statusTimeLabel.setText(time)

    def setStatusValueLabel(self, value):
        if len(sys.argv) == 1:
            self.statusValueLabel.setText(value)
        else:
            pass

    def setProtonNeutron(self, _proton, _detector, _detectorRate, _monitor, _monitorRate):
        try:
            self.protonText.setText(str(_proton))
            self.detectorText.setText(str(_detector))
            self.detectorRateText.setText(str(_detectorRate))
            self.monitorText.setText(str(_monitor))
            self.monitorRateText.setText(str(_monitorRate))
        except:
            self.protonText.setText("-----")
            self.detectorText.setText('------')
            self.detectorRateText.setText('------')
            self.monitorText.setText('------')
            self.monitorRateText.setText('------')
    
    def setStartEndTime(self, _start, _end):
        try:
            self.startTimeText.setText(str(_start))
            self.endTimeText.setText(str(_end))
        except:
            self.startTimeText.setText("------")
            self.endTimeText.setText("------")

    def clearCanvas(self):
        self.runCanvas.ax.clear()
        self.runCanvas.draw()

    def updateMonitorCanvas(self, xdata, ydata, started,_command):
        try:
            #if _command in ('configure', 'abort'):
            #    self.pix = None
            #elif not started:
            #    pass
            #else:
            if str(xdata) == 'clear' or str(ydata) == 'clear':
                self.runCanvas.ax.clear()
                self.runCanvas.draw()
            elif len(xdata) != len(ydata) or len(ydata) == 0:
                pass
            else:
                #if not self.pix:
                self.runCanvas.ax.clear()
                self.pix, = self.runCanvas.ax.plot(xdata, ydata, color="r")
                #else:
                #    self.pix.set_ydata(ydata)
                self.runCanvas.ax.relim()
                self.runCanvas.ax.autoscale_view()
                self.runCanvas.draw()
                #self.runCanvas.flush_events()
        except:
            pass
