#!/usr/bin/python
# -*- coding: utf-8 -*-

from conf.constants import *
from canvas import *
from model import listenner

from matplotlib.ticker import MaxNLocator
import numpy as np

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)
        
        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([100, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
	
        #first Grid
        _width = 15
        _height = 15
        self.moduleList=[141,142,143,131,132,133,121,122,123,223,222,221,233,232,231,243,242,241,321,322,323,331,332,333,341,342,343,421,422,423,431,432,433,441,442,443,521,531,532,533,541,542,543,623,631,632,633,641,642,643]
        #self.moduleList=[143,131,132,133,123,221,233,232,231,241,322,331,332,333,341,342,343,422,431,432,433,441,442,443,521,522,523,531,532,533,541,542,543,621,622,623,631,632,633,641,642,643]
        self.buttonList=[141,142,143, # 0, 1, 2
                         131,132,133, # 3, 4, 5
                         121,122,123, # 6, 7, 8
                         223,222,221, # 9,10,11
                         233,232,231, #12,13,14
                         243,242,241, #15,16,17
                         321,322,323, #18,19,20
                         331,332,333, #21,22,23
                         341,342,343, #24,25,26
                         421,422,423, #27,28,29
                         431,432,433, #30,31,32
                         441,442,443, #33,34,35
                         521,         #36
                         531,532,533, #37,38,39
                         541,542,543, #40,41,42
                                 623, #43,44,45
                         631,632,633, #46,47,48
                         641,642,643] #49.50,51
        for i in range(len(self.buttonList)):
            self.buttonList[i] = BankButton(self,'img/module_off.png', _width, _height)
        
        self.camera = BankButton(self,'img/camera.png', _width, _height)
        self.sample = BankButton(self,'img/sample.png', _width, _height)
        self.monitor = BankButton(self,'img/monitor.png', _width, _height)
        
        self.blank5 = BankButton(self,'blank.png', _width, _height)
        self.blank9 = BankButton(self,'blank.png', _width, _height)
	
        self.RadioGroup = QtGui.QButtonGroup()
        for i in range(len(self.buttonList)):
            self.RadioGroup.addButton(self.buttonList[i])
        self.RadioGroup.buttonClicked.connect(self.buttonClicked)

        self.blank1 = QtGui.QLabel("                               ---------------------------------------------->", self.first)
        self.blank1.setMinimumWidth(460)
        self.blank2 = QtGui.QLabel(self.first)
        self.blank2.setMinimumWidth(460)
	
        #second Grid
        self.moduleLabel = QtGui.QLabel("module:633   ", self.second)
        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('XY')
        self.bankCombo.addItem('I-tof')
        self.bankCombo.addItem('I-d')
        self.bankCombo.addItem('I-q')
        #self.bankCombo.setCurrentIndex(1)
        self.bankCombo.activated.connect(self.comboSelected)

        self.logCombo = QtGui.QComboBox()
        self.logCombo.addItem('linear')
        self.logCombo.addItem('logarithmic')
        self.logCombo.activated.connect(self.comboLogChange)
        
        _xsize = 16
        _ysize = 8
        self.canvas1 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            'Neutron Distribution',
            'X / mm',
            #'TOF / us',
            )
        self.canvas2 = zoomCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            'Neutron Distribution',
            'TOF / us',
            #'TOF / us',
            )

        _nline = 0
        self.firstGrid.addWidget(self.blank5, _nline, 5, 1,1)
        self.firstGrid.addWidget(self.blank9, _nline, 9, 1,1)
        _index = self.moduleList.index(341)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 6, 1,1)
        _index = self.moduleList.index(342)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 7, 1,1)
        _index = self.moduleList.index(343)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 8, 1,1)
        _nline += 1
        _index = self.moduleList.index(543)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 2, 1,1)
        _index = self.moduleList.index(533)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 3, 1,1)
        #self.firstGrid.addWidget(self.buttonList[26], _nline, 4, 1,1)#523
        _index = self.moduleList.index(331)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 6, 1,1)
        _index = self.moduleList.index(332)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 7, 1,1)
        _index = self.moduleList.index(333)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 8, 1,1)
        _index = self.moduleList.index(141)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 10, 1,1)
        _index = self.moduleList.index(142)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 11, 1,1)
        _index = self.moduleList.index(143)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 12, 1,1)
        _nline += 1
        _index = self.moduleList.index(542)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 2, 1,1)
        _index = self.moduleList.index(532)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 3, 1,1)
        #self.firstGrid.addWidget(self.buttonList[25], _nline, 4, 1,1)#522
        _index = self.moduleList.index(321)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 6, 1,1)
        _index = self.moduleList.index(322)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 7, 1,1)
        _index = self.moduleList.index(323)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 8, 1,1)
        _index = self.moduleList.index(131)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 10, 1,1)
        _index = self.moduleList.index(132)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 11, 1,1)
        _index = self.moduleList.index(133)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 12, 1,1)
        _nline += 1
        _index = self.moduleList.index(541)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 2, 1,1)
        _index = self.moduleList.index(531)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 3, 1,1)
        _index = self.moduleList.index(521)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 4, 1,1)
        _index = self.moduleList.index(121)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 10, 1,1)
        _index = self.moduleList.index(122)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 11, 1,1)
        _index = self.moduleList.index(123)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 12, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.monitor, _nline, 1, 1,1)
        self.firstGrid.addWidget(self.sample, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.camera, _nline, 13, 1,1)
        self.firstGrid.addWidget(self.blank1, _nline, 0, 1,1)
        self.firstGrid.addWidget(self.blank2, _nline, 14, 1,1)
        _nline += 1
        _index = self.moduleList.index(643)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 2, 1,1)
        _index = self.moduleList.index(633)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 3, 1,1)
        _index = self.moduleList.index(623)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 4, 1,1)
        _index = self.moduleList.index(223)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 10, 1,1)
        _index = self.moduleList.index(222)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 11, 1,1)
        _index = self.moduleList.index(221)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 12, 1,1)
        _nline += 1
        _index = self.moduleList.index(642)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  2, 1,1)
        _index = self.moduleList.index(632)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  3, 1,1)
        #self.firstGrid.addWidget(self.buttonList[34], _nline, 4, 1,1)#622
        _index = self.moduleList.index(423)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  6, 1,1)
        _index = self.moduleList.index(422)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  7, 1,1)
        _index = self.moduleList.index(421)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  8, 1,1)
        _index = self.moduleList.index(233)
        self.firstGrid.addWidget(self.buttonList[_index],  _nline, 10, 1,1)
        _index = self.moduleList.index(232)
        self.firstGrid.addWidget(self.buttonList[_index],  _nline, 11, 1,1)
        _index = self.moduleList.index(231)
        self.firstGrid.addWidget(self.buttonList[_index],  _nline, 12, 1,1)
        _nline += 1
        _index = self.moduleList.index(641)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  2, 1,1)
        _index = self.moduleList.index(631)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  3, 1,1)
        #self.firstGrid.addWidget(self.buttonList[33], _nline, 4, 1,1)#621
        _index = self.moduleList.index(433)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  6, 1,1)
        _index = self.moduleList.index(432)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  7, 1,1)
        _index = self.moduleList.index(431)
        self.firstGrid.addWidget(self.buttonList[_index], _nline,  8, 1,1)
        _index = self.moduleList.index(243)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 10, 1,1)
        _index = self.moduleList.index(242)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 11, 1,1)
        _index = self.moduleList.index(241)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 12, 1,1)
        _nline += 1
        _index = self.moduleList.index(443)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 6, 1,1)
        _index = self.moduleList.index(442)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 7, 1,1)
        _index = self.moduleList.index(441)
        self.firstGrid.addWidget(self.buttonList[_index], _nline, 8, 1,1)
        _nline = 0
        self.secondGrid.addWidget(self.moduleLabel, _nline, 1, 1,1)
        self.secondGrid.addWidget(self.bankCombo,   _nline, 2, 1,1)
        self.secondGrid.addWidget(self.logCombo,    _nline, 3, 1,1)
        _nline += 1
        self.secondGrid.addWidget(self.canvas1, _nline, 0, 1,1)#, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.canvas2, _nline, 0, 1,1)#, QtCore.Qt.AlignCenter)
        self.canvas1.show()
        self.canvas2.hide()
        self.verticalLayout.addWidget(self.splitter)
        
        self.buttonIndex = 38
        self.buttonList[38].setIcon(QtGui.QIcon('img/module_on.png'))
        self.buttonChange = True
        self.comboIndex = 0  

        self.pix = None
        self.roi = None
        self.colorbar = None

        self.font={ 'family': 'serif',
                    'color':  'red',
                    'weight': 'normal',
                    'size': 7,
                    }

    def setModuleListen(self, module):
        try:
            self.buttonReset()
            #for i in range (len(self.buttonList)):
            #    if self.buttonList[i].isChecked():
                    #self.buttonIndex = i
            for i in range (len(module)):
                _index = self.moduleList.index(module[i])
                self.buttonList[_index].setIcon(QtGui.QIcon('img/module_error.png'))
            self.moduleLabel.setText("module:"+str(self.moduleList[self.buttonIndex])+"   ")
            self.buttonList[self.buttonIndex].setIcon(QtGui.QIcon('img/module_on.png'))
            #_index1 = self.moduleList.index(module1)
            #_index2 = self.moduleList.index(module2)
            #self.buttonList[_index1].setIcon(QtGui.QIcon('img/module_error.png')) 
            #self.buttonList[_index2].setIcon(QtGui.QIcon('img/module_error.png')) 
        except:
            pass

    def getComboIndex(self):
        self.comboIndex = self.bankCombo.currentIndex()    
        return self.comboIndex    

    def getButtonIndex(self):
        return self.buttonIndex
    
    def getDetectorIndex(self):
        buttonIndex = self.getButtonIndex()
        comboIndex = self.getComboIndex()
        return buttonIndex, comboIndex

    def comboSelected(self):
        self.pix = None
        self.canvas2.zoomSelected = False
        comboIndex = self.getComboIndex()
        #buttonIndex = self.getButtonIndex()
        self.parent.tabChange()
        if comboIndex==0:
            self.canvas2.hide()
            self.canvas1.show()
        elif comboIndex==1:
            self.canvas2.ax.set_xlabel('TOF / us')
            self.canvas2.show()
            self.canvas1.hide()
            self.canvas2.draw()
        elif comboIndex==2:
            self.canvas2.ax.set_xlabel('d')
            self.canvas2.show()
            self.canvas1.hide()
            self.canvas2.draw()
        elif comboIndex==3:
            self.canvas2.ax.set_xlabel('q')
            self.canvas2.show()
            self.canvas1.hide()
            self.canvas2.draw()
        self.getDetectorData()        

    def comboLogChange(self):
        self.pix = None
        self.canvas2.zoomSelected = False
        index = self.logCombo.currentIndex()
        if index == 0:
            self.canvas2.ax.set_yscale('linear')
        else:
            self.canvas2.ax.set_yscale('log')
        self.canvas2.draw()

    def getDetectorData(self):
        self.parent.getDetectorData()
    
    def getModuleList(self):
        return self.moduleList

    def buttonClicked(self):
        self.buttonReset()
        for i in range (len(self.buttonList)):
            if self.buttonList[i].isChecked():
                self.buttonIndex = i
                self.moduleLabel.setText("module:"+str(self.moduleList[i])+"   ")
                self.buttonList[i].setIcon(QtGui.QIcon('img/module_on.png'))
        self.parent.tabChange()
        self.roi = None
        self.pix = None
        self.buttonChange = True
        self.canvas1.zoomSelected = False
        self.canvas2.zoomSelected = False
        self.canvas2.ax.clear()
        self.canvas1.ax.clear()
        self.canvas2.draw()
        self.canvas1.draw()
        comboIndex = self.getComboIndex()

    def clearCanvas(self):
        self.canvas1.ax.clear()
        self.canvas1.draw()
        self.canvas2.ax.clear()
        self.canvas2.draw()
 
    def updateBankCanvas(self, num, value):#, started, _command):
        _buttonIndex=self.getButtonIndex()
        _comboIndex=self.getComboIndex()
        if _buttonIndex in (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18):
            color2D = 'c'
            color3D = 'Greens'
        elif _buttonIndex   in (19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36):
            color2D = 'r'
            color3D = 'Blues'
        elif _buttonIndex in (37,38,39,40,41,42,43,44,45,46,47,48,49,50,51):
            color2D = 'y'
            color3D = 'gist_heat'
        # XY 3D Image
        if _comboIndex==0:
            try:
                if str(value[2]) == 'clear':
                    self.canvas1.ax.clear()
                    self.canvas1.draw()
                elif len(value[2]) == 0:
                    pass
                else:
                    #if self.buttonChange or self.roi == None:
                    self.canvas1.ax.clear()
                    self.canvas1.ax.add_patch(self.canvas1.rect)
                    #self.canvas1.ax.axis('equal', adjustable='box')
                    #self.roi=self.canvas1.ax.pcolor(value[0], value[1], value[2], cmap=color3D)
                    self.roi=self.canvas1.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                    self.canvas1.ax.xaxis.set_major_locator(matplotlib.ticker.MultipleLocator(20))
                    self.canvas1.ax.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(20))
                    self.canvas1.ax.set_xlabel('X / mm')
                    self.canvas1.ax.set_ylabel('Y / mm')
                    #self.buttonChange = False
                    #else:
                    #    self.roi.set_array(np.array(value[2]).ravel())
                        #self.roi.set_array(np.array(value[2])[:-1,:-1].ravel())
                    if self.buttonChange == False:
                        if self.canvas1.zoomSelected and (self.canvas1.minX != self.canvas1.maxX) and (self.canvas1.minY != self.canvas1.maxY):
                            self.canvas1.ax.set_xlim(self.canvas1.minX, self.canvas1.maxX)
                            self.canvas1.ax.set_ylim(self.canvas1.minY, self.canvas1.maxY)
                        elif self.canvas1.scale_factor != 1.0:
                            self.canvas1.ax.set_xlim([self.canvas1.xdata - self.canvas1.new_width * (1-self.canvas1.relx), self.canvas1.xdata + self.canvas1.new_width * (self.canvas1.relx)])
                            self.canvas1.ax.set_ylim([self.canvas1.ydata - self.canvas1.new_height * (1-self.canvas1.rely), self.canvas1.ydata + self.canvas1.new_height * (self.canvas1.rely)])
                    if self.colorbar == None:
                        self.colorbar=self.canvas1.fig.colorbar(self.roi,ax=self.canvas1.ax,extend='max')
                        self.colorbar.ax.tick_params(labelsize=5)
                    else:
                        self.colorbar.on_mappable_changed(self.roi)
                    self.buttonChange = False
                    self.canvas1.draw()
            except:
                pass
                #self.roi = None
        # PID 2D Bar
        else:
            #try:
            if True:
                if str(value[4]) == 'clear':
                    self.canvas2.ax.clear()
                    self.canvas2.draw()
                elif len(value[3]) != len(value[4]) or len(value[4]) == 0:
                    pass
                else:
                    #_t=np.array(value[4])
                    #_t[np.isnan(_t)]=0
                    #_t[np.isinf(_t)]=0
                    #if self.buttonChange or self.pix == None:
                    self.canvas2.ax.clear()
                    comboIndex = self.getComboIndex()
                    x = []
                    y = []
                    if comboIndex == 3:
                        xLen = len(value[3])
                        for i in range(xLen):
                            x.append(2*np.pi/value[3][xLen - i - 1])
                            y.append(value[4][xLen - i - 1])
                    else:
                        x = value[3]
                        y = value[4]
                    self.pix, = self.canvas2.ax.plot(x, y, color=color2D)
                    #self.pix, = self.canvas2.ax.plot(value[3], _t, color=color2D)
                    self.canvas2.ax.add_patch(self.canvas2.rect)
                    #else:
                    #    self.pix.set_ydata(value[4])
                    if self.buttonChange == False:
                        if self.canvas2.zoomSelected and (self.canvas2.minX != self.canvas2.maxX) and (self.canvas2.minY != self.canvas2.maxY):
                            self.canvas2.ax.set_xlim(self.canvas2.minX, self.canvas2.maxX)
                            self.canvas2.ax.set_ylim(self.canvas2.minY, self.canvas2.maxY)
                        elif self.canvas2.scale_factor != 1.0:
                            self.canvas2.ax.set_xlim([self.canvas2.xdata - self.canvas2.new_width * (1-self.canvas2.relx), self.canvas2.xdata + self.canvas2.new_width * (self.canvas2.relx)])
                            self.canvas2.ax.set_ylim([self.canvas2.ydata - self.canvas2.new_height * (1-self.canvas2.rely), self.canvas2.ydata + self.canvas2.new_height * (self.canvas2.rely)])
                    self.canvas2.ax.yaxis.set_major_locator(MaxNLocator(integer=True))
                    if _comboIndex==1:
                        self.canvas2.ax.set_xlabel('TOF / us')
                    elif _comboIndex==2:
                        self.canvas2.ax.set_xlabel('d')
                    elif _comboIndex==3:
                        self.canvas2.ax.set_xlabel('q')
                    self.canvas2.ax.set_ylabel('Neutron Distribution')

                    index = self.logCombo.currentIndex()
                    if index == 0:
                        self.canvas2.ax.set_yscale('linear')
                    else:
                        self.canvas2.ax.set_yscale('log')

                    self.canvas2.ax.relim()
                    self.canvas2.ax.autoscale_view()
                    self.canvas2.draw()
                    self.buttonChange = False
            #except:
            #    pass
            #    self.pix = None
                #self.canvas2.ax.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(3))
        plt.pause(0.0001)

    def buttonReset(self):
        for i in range (len(self.buttonList)):
            self.buttonList[i].setIcon(QtGui.QIcon('img/module_off.png')) 

class BankButton(QtGui.QPushButton):

    def __init__(
        self,
        parent=None,
        img='',
        width=20,
        height=20,
        ):
        super(BankButton,self).__init__(parent)
	
        self.setFlat(True)
        self.setStyleSheet("border:none;outline:none")
        self.setIcon(QtGui.QIcon(img))
        self.setIconSize(QtCore.QSize(width,height))
        self.setCheckable(True)
