from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import QThread
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy as np

import logging
import redis
import datetime
import os


class listenThread(QtCore.QObject):
    def __init__(self, parent, redisServer=None, refreshTime=1.0):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.worker = listenner(self, redisServer, refreshTime)
        self.worker_thread = workerThread(parent)
        self.worker.moveToThread(self.worker_thread)
        self.worker_thread.started.connect(self.worker.process)
        self.worker.finished.connect(self.worker_thread.quit)
        self.worker.signalListen.connect(self.parent.setModuleListen)
        self.num = 0

    def pause(self):
        self.worker.set(False)

    def resume(self):
        self.worker.resume()

    def clear(self):
        if self.worker_thread.isRunning():
            self.worker_thread.terminate()
            self.worker_thread.wait()
            #self.signalProgress.emit('')
            #self.signalStatus.emit()
            #self.signalMonitor.emit()
            #self.signalExperiment.emit()
            #self.worker_thread.start()

    def start(self):
        if self.num == 0:
            self.worker_thread.start()
            self.num = 1
        else:
            self.worker.resume()

    def stop(self):
        self.worker.set(False)

    def exit(self):
        self.worker.exit()

class listenner(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalListen = QtCore.pyqtSignal(object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, redisServer, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.redisServer = redisServer

        self.refreshTime = refreshTime
        self.started = True

        self.proportion = 2.0
        self.moduleList = [[143,241],[133,231],[123,221],[142,242],[132,232],[122,222],[141,243],[131,233],[121,223],[321,423],[322,422],[323,421],[331,433],[332,432],[333,431],[341,443],[342,442],[343,441],[521,623],[531,633],[532,632],[533,631],[541,643],[542,642],[543,641]]
        #self.moduleList = [[143,241],[133,231],[123,221],[142,242],[131,233],[141,243],[322,422],[331,433],[332,432],[333,431],[341,443],[342,442],[343,441],[521,623],[531,633],[532,632],[533,631],[541,643],[542,642],[543,641]]

    def __del__(self):
        self.wait()

    def pause(self):
        self.started=False

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def resume(self):
        if not self.started:
            self.started = True

    @QtCore.pyqtSlot()
    def process(self):
        while True:
            _data = []
            _started = self.get()
            if not _started:
                continue 
            
            # Detector Page
            value=[]
            i = 0
            for i in range(len(self.moduleList)):
                value.append([])
            i = 0
            j = 0
            for i in range(len(self.moduleList)):
                for j in range(len(self.moduleList[i])):
                    value[i].append([])
            i = 0
            j = 0
            _module = []
            for i in range(len(self.moduleList)):
                #try:
                if True:
                    _proportion = 0.0
                    for j in range(len(self.moduleList[i])):
                        _data = self.redisServer.get('/GPPD/earthworm/module'+str(self.moduleList[i][j])+'/detector_counts')
                        #_data = self.redisServer.get('/GPPD/workspace/MantidData/module'+str(self.moduleList[i][j])+'/counts')
                        if _data is not None:
                            _data = jsonArray.jsonDecoder(_data)
                            value[i][j] = _data
                    x = value[i][0]
                    y = value[i][1]
                    if (x == 0) and (y != 0):
                        _proportion =  x/y
                    elif (x != 0) and (y == 0):
                        _proportion =  y/x
                    elif (x == 0) and (y == 0):
                        _proportion = 0.0
                    else:
                        _proportion = float(x) / float(y)
                    if (_proportion > self.proportion) or (_proportion < (1.0/self.proportion)):
                        _module.append(self.moduleList[i][0])        
                        _module.append(self.moduleList[i][1]) 
                        #self.signalListen.emit(self.moduleList[i][0],self.moduleList[i][1])
                #except:
                #    pass
            try:
                self.signalListen.emit(_module)
            except:
                pass
       
            try:
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()

