#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''
import numpy as np
from PyQt4 import QtCore, QtGui
import histogramDock

class CSNSHistogramPage(QtGui.QMainWindow):

    def __init__(self, parent):
        super(CSNSHistogramPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        self.patternDock=[]
        self.patternDock.append(histogramDock.histogramDock(self,
                1, 9, 0.4, 'r', 4000, 'Backward Bank'))
        self.patternDock.append(histogramDock.histogramDock(self,
                2, 9, 0.4, 'g', 3000, 'Medium-Angle Bank'))
        self.patternDock.append(histogramDock.histogramDock(self,
                3, 9, 0.4, 'b', 2000, 'Low-Angle Bank'))

        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[0])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[1])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[2])

        self.comboIndex = [0,0,0]
        self.kwargs = {}

    def getPatternCanvas(self, n):
        return self.patternDock[n].getCanvas()

    def updateCanvas(self, value, started):
        try:
            
            for i in range(len(self.patternDock)):
                can = self.patternDock[i].canvas
                can.ax.clear()
                if not started:
                    pass
                else:
                    _pause = self.patternDock[i].pauseButton.text()
                    if _pause == 'Pause':
                        _scale = self.patternDock[i].getScale()
                        can.ax.plot(np.divide(value[0][i],_scale), np.divide(value[1][i],_scale), color=can.plotColor)

                can.ax.relim()
                can.ax.autoscale_view()
                can.draw()
        except:
            pass

