#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2017.05.15

Detector
'''
from conf.constants import *

# user defined

from model.readData import *
from canvas import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *

class CSNSDetectorPage(QtGui.QTabWidget):#QMainWindow):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([100, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
	
        #first Grid
        _width = 20
        _height = 20
        self.bank01 = BankButton(self,'img/bank1_off.png', _width, _height+45)
        self.bank02 = BankButton(self,'img/bank2_off.png', _width, _height+45)

        self.bank03 = BankButton(self,'img/bank3_off.png', _width+55, _height)
        self.bank04 = BankButton(self,'img/bank4_off.png', _width+55, _height)
        self.bank05 = BankButton(self,'img/bank5_off.png', _width+45, _height+40)
        self.bank06 = BankButton(self,'img/bank6_off.png', _width+45, _height+40)
       
        self.camera = BankButton(self,'img/camera.png', _width, _height)
        self.sample = BankButton(self,'img/sample.png', _width, _height)
        self.monitor = BankButton(self,'img/monitor.png', _width, _height)
	
        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.bank01)
        self.RadioGroup.addButton(self.bank02)
        self.RadioGroup.addButton(self.bank03)
        self.RadioGroup.addButton(self.bank04)
        self.RadioGroup.addButton(self.bank05)
        self.RadioGroup.addButton(self.bank06)
        self.RadioGroup.buttonClicked.connect(self.bankClicked)

        self.blank1 = QtGui.QLabel("                               ---------------------------------------------->", self.first)
        self.blank1.setMinimumWidth(460)
        self.blank2 = QtGui.QLabel(self.first)
        self.blank2.setMinimumWidth(460)
	
        #second Grid
        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('PID')
        self.bankCombo.addItem('XY')
        self.bankCombo.activated.connect(self.comboSelected)

        _xsize = 16#6
        _ysize = 8#3
        '''
        self.BankCanvas = blankCanvas(
            self,
            _xsize,
            _ysize,
            72,
            )
	    '''
        self.BankCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            )

        _nline = 0
        self.firstGrid.addWidget(self.bank03, _nline, 3, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.bank01, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.bank05, _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.monitor, _nline, 1, 1,1)
        self.firstGrid.addWidget(self.sample, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.camera, _nline, 5, 1,1)
        self.firstGrid.addWidget(self.blank1, _nline, 0, 1,1)
        self.firstGrid.addWidget(self.blank2, _nline, 6, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.bank02, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.bank06, _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.bank04, _nline, 3, 1,1)
	
        _nline += 1
        self.secondGrid.addWidget(self.bankCombo, _nline, 1, 1,1)
        _nline += 1
        self.secondGrid.addWidget(self.BankCanvas, _nline, 0, 1,1)

        self.verticalLayout.addWidget(self.splitter)
        
        self.bankIndex = -1
        self.comboIndex = 0    

    def getComboIndex(self):
        self.comboIndex = self.bankCombo.currentIndex()    
        return self.comboIndex    

    def getBankIndex(self):
        return self.bankIndex
    
    def getDetectorIndex(self):
        bankIndex = self.getBankIndex()
        comboIndex = self.getComboIndex()
        return bankIndex, comboIndex

    def comboSelected(self):
        comboIndex = self.getComboIndex()
        bankIndex = self.getBankIndex()
        self.parent.tabChange()

    def bankClicked(self):
        bankIndex = self.getBankIndex()
        comboIndex = self.getComboIndex()
        if self.bank01.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_on.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_off.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_off.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_off.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_off.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_off.png'))
            bankIndex=0
        elif self.bank02.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_off.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_on.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_off.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_off.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_off.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_off.png'))
            bankIndex=1
        elif self.bank03.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_off.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_off.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_on.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_off.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_off.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_off.png'))
            bankIndex=2
        elif self.bank04.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_off.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_off.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_off.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_on.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_off.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_off.png'))
            bankIndex=3
        elif self.bank05.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_off.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_off.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_off.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_off.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_on.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_off.png'))
            bankIndex=4
        elif self.bank06.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_off.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_off.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_off.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_off.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_off.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_on.png'))
            bankIndex=5
        
        self.bankIndex = bankIndex
        self.parent.tabChange()

    def updateBankCanvas(self, value, started):
        self.BankCanvas.ax.clear()
        if not started:
            pass
        else:
            _bankIndex=self.getBankIndex()
            _comboIndex=self.getComboIndex()
            if _bankIndex==0:
                color2D = 'r'
                color3D = 'hot'
            elif _bankIndex==1:
                color2D = 'g'
                color3D = 'cool'
            elif _bankIndex==2 :
                color2D = 'b'
                color3D = 'prism'
            elif _bankIndex==3:
                color2D = 'c'
                color3D = 'spring'
            elif _bankIndex==4:
                color2D = 'm'
                color3D = 'winter'
            elif _bankIndex==5:
                color2D = 'y'
                color3D = 'BuPu'
            try:
                if _comboIndex==0:
                    # PID 2D Bar
                    #self.BankCanvas.ax.bar(_x,value,0.5,color='r')
                    self.BankCanvas.ax.hist(value[1], color=color2D)
                elif _comboIndex==1:
                    # XY 3D Image
                    self.BankCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                    #mlab.show()
                    #self.BankCanvas.ax.clear()
                    #self.BankCanvas.ax.imshow(img)
                    #self.BankCanvas.draw()
            except:
                pass
        plt.pause(0.0001)
        self.BankCanvas.draw()

class BankButton(QtGui.QPushButton):

    def __init__(
        self,
        parent=None,
        img='',
        width=100,
        height=100,
        ):
        super(BankButton,self).__init__(parent)
	
        #self.img = img
        #self.width = width
        #self.height = height
        self.setFlat(True)
        self.setStyleSheet("border:none;outline:none")
        self.setIcon(QtGui.QIcon(img))
        self.setIconSize(QtCore.QSize(width,height))
        #self.resize(self.width,self.height)
        self.setCheckable(True)
