#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2016.12.12

Histogram

'''

from conf.constants import *

from canvas import *
from model.readData import *
#from model.readImage import *
from presenter.updateStreaming import *
from model.neonReceiver import *

class CSNSHistogramDock(QtGui.QDockWidget):#QTabWidget):

    def __init__(self, parent, neonID, plotColor, plotScale, title):
        super(CSNSHistogramDock, self).__init__(parent)
	self.neonID = neonID
	self.plotColor = plotColor
	self.plotScale = plotScale
	self.title = title
	
	self.streaming = CSNSGlobal()
	self.streamingThread = None
	self.plotThread = None
        
	self.setupUi(self)
    
    def setupUi(self, Widget):#QTabWidget):
        #self.setTabPosition(QTabWidget.West)

	self.setFeatures(QtGui.QDockWidget.DockWidgetFloatable | QtGui.QDockWidget.DockWidgetMovable)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 9
        _ysize = 0.8

        # Backward TOF/d

        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('TOF')
        self.comboBox.addItem('d')
        self.comboBox.addItem('Q')
        self.comboBox.activated.connect(self.comboboxChoose)

        self.startButton = QtGui.QPushButton('Start')
        self.startButton.clicked.connect(self.startBackward2D)

        self.resumeButton = QtGui.QPushButton('Pause')
        self.resumeButton.setEnabled(False)
        self.resumeButton.clicked.connect(self.resumeButtonClicked)

        self.saveButton = QtGui.QPushButton('Save')
        self.saveButton.setEnabled(False)
        
        self.canvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            self.title,
            'TOF /mics',
            'Neutron Counts',
            )
       
	self.label = QtGui.QLabel(self.title)
 
        _nline = 0
        self.mainGrid.addWidget(self.comboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startButton, _nline, 1,
                                1, 1)
        self.mainGrid.addWidget(self.resumeButton, _nline, 2,
                                1, 1)
        self.mainGrid.addWidget(self.saveButton, _nline, 4,
                                1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.canvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.label, _nline, 4, 1, 1)

	self.setWidget(self.scrollArea)
        #self.setCentralWidget(self)
 
        self.sourceID=-1

    def comboboxChoose(self):
        index = self.comboBox.currentIndex()
        if index == 0:
            _scale = self.plotScale
        elif index == 1:
            _scale = 1

        try:
            self.plotThread.setUnit(_scale)
        except:
            pass

    def startDiffractionSimulator(self):
        self.setSource(2)

    def createStreamingThread(self, sourceID):
        global CSNSThreadID
        CSNSThreadID += 1

        if sourceID == 2:
            self.streamingThread = diffractionSimulator(
                CSNSThreadID,
                3,
                './dat/gppd.dat',
                './dat/monitor.dat',
                1E6,
                1.0,
                self.streaming,
                )
        elif sourceID == 0:
            self.streamingThread = neonReceiver(
                CSNSThreadID,
                self.getIP(),
                self.getPort(),
                self.neonID,
                1.0,
                self.streaming,
                )

        self.streamingThread.setDaemon(True)

    def createPlotThread(self):
        global CSNSThreadID
        CSNSThreadID += 1

        self.plotThread = updateStreaming2D(
            CSNSThreadID,
            self.canvas,
            self.canvas.ax,
            self.plotScale,
            self.plotColor,
            self.streaming,
            )

        self.plotThread.setDaemon(True)

    def startBackward2D(self):
        _sourceID=self.getSource()
        if not(_sourceID ==0 or _sourceID ==2):
            print "ERROR: The streaming server not started."            
            return

        if self.startButton.text() == 'Start':
            self.createStreamingThread(self.getSource())
            self.createPlotThread()

            self.streamingThread.start()
            self.plotThread.start()

            self.startButton.setText('Stop')
            self.resumeButton.setText('Pause')
            self.resumeButton.setEnabled(True)
        elif self.startButton.text() == 'Stop':

            self.plotThread.stop()
            del self.plotThread
            self.streamingThread.stop()
            del self.streamingThread

            self.startButton.setText('Start')
            self.resumeButton.setText('Resume')
            self.resumeButton.setEnabled(False)

    def resumeButtonClicked(self):
        if self.resumeButton.text() == 'Resume':
            self.plotThread.resume()
            self.resumeButton.setText('Pause')
        elif self.resumeButton.text() == 'Pause':

            self.plotThread.pause()
            self.resumeButton.setText('Resume')

    def isStreamingThread(self):
        try:
            self.streamingThread()
            return True
        except:
            return False

    def isPlotThread(self):
        try:
            self.plotThread()
            return True
        except:
            return False

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()

    def getSource(self):
        return self.sourceID

    def setSource(self, id):
        self.sourceID=id
