#!/usr/bin/python
# -*- coding: utf-8 -*-

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

from conf.constants import *
import json

from conf import *

from viewer.mainTab import *
from viewer.subTab import *


class CSNSMainSetInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSMainSetInfo, self).__init__(parent)
        self.parent=parent
        self.setupUi(self)

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.upRightTab = CSNSMainTab(self)
        self.progressBar = QtGui.QProgressBar(self)
        self.downRightTab = CSNSSubTab(self)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)

        self.splitter.addWidget(self.upRightTab)
        self.splitter.addWidget(self.progressBar)
        self.splitter.addWidget(self.downRightTab)
        self.splitter.setSizes([800, 30, 30])
        self.verticalLayout.addWidget(self.splitter)

        #self.createTimeProgress(0,2000)

    def setDataPath(self, kwargs):
        self.parent.setDataPath(kwargs) 

    # time Progress ThreadI
    def createProgressBar(self, mini,maxi):
        global CSNSThreadID
        CSNSThreadID += 1
        self.progressThread = updateProgressBar(self, CSNSThreadID, mini, maxi)
        self.progressThread.partDone.connect(self.updateTimeProgress)
        self.progressThread.procDone.connect(self.fin)
        self.progressThread.start()

    @QtCore.pyqtSlot(int)
    def updateTimeProgress(self, val):
        self.progressBar.setValue(val)
        perct = '{0}%'.format(val)

    def fin(self):
        pass
        
    def getValue(self):
        return self.parent.getValue()

    '''
    # diffraction pattern
    def getPatternCanvas(self, n):
        return self.upRightTab.getPatternCanvas()

    # monitor Counts
    def getMonitorImageCanvas(self, n):    
        return self.upRightTab.getMonitorImageCanvas(n)

    def getMonitorPatternCanvas(self, n):
        return self.upRightTab.getMonitorPatternCanvas(n)

    # experiment Progress
    def getProtonCanvas(self):
        return self.upRightTab.getProtonCanvas()

    def getNeutronCanvas(self):
        return self.upRightTab.getNeutronCanvas()

    def getPulseCanvas(self):
        return self.upRightTab.getPulseCanvas()
    '''

