#!/usr/bin/python
# -*- coding: utf-8 -*-

# after v05

from data.GPPDData import *

if __name__ == '__main__':
    redishost = '192.168.1.12'
    m_neonRedis = NeonRedis(host=redishost, port=9999, db=0,
                            isWritable=True)  # server mode, set msgs to Redis
    m_neonRedisCli = NeonRedis(host=redishost, port=9999, db=0,
                               isWritable=True)  # client mode, get msgs from Redis
    m_neonRegister = NeonService.Register(m_neonRedis, 'NeonRegister')
    import random
    import sys

    isTestNeonReg = True

    if isTestNeonReg:
        interface = {'name': 'haolai', 'addr': '192.168.0.1',
                     'port': 9999}
        m_neonRegister.register(name='haolai', attribute=interface)
        pro = m_neonRegister.request(name='haolai')

        # print pro
        # print pro['name']

    xlen = 10000
    xbins_list = []
    for i in range(xlen):
        xbins_list.append(i * 4)

    xbins_raw = numpy.array(xbins_list)
    xvals_raw = numpy.zeros(xlen)

    curtime = time.time()
    hist2d = Hist2D(m_neonRedis, '/Bank1/2DHist/ID_100', xbins_raw,
                    xvals_raw)
    i = 0
    total = 0
    while True:
        for item in xrange(1000):
            _yindex = random.randint(0, xlen - 1)
            xvals_raw[_yindex] += 1
        hist2d.setData(xvals_raw)
        hist2d.dump()
        now = time.time()
        inte = now - curtime
        total = total + inte
        i = i + 1
        average = total / i
        curtime = now
        if i % 100 == 0:
            print i, ' usedtime: ', inte, ' total: ', total, \
                ' average: ', average
