#!/usr/bin/python
# -*- coding: utf-8 -*-

import math
import random
from math import atan
from numpy import *
from scipy import pi, log
import numpy as np
import time
import threading
import Queue
from scipy.interpolate import interp1d
from scipy.interpolate import InterpolatedUnivariateSpline
from scipy.interpolate import UnivariateSpline
from readData import *
from globalClass import *
from profileFunction import *


class protonSimulator(threading.Thread):

    def __init__(
        self,
        threadID,
        inQueue,
        outQueue,
        ):

        threading.Thread.__init__(self)
        self.paused = False
        self.pause_cond = threading.Condition(threading.Lock())

        self.threadID = threadID

        self.inQueue = inQueue
        self.outQueue = outQueue

        self.gauss = []
        _parameters = [1.0, 0.0, 5, 0.0]
        for i in range(5):
            self.gauss.append(CSNSgauss(_parameters, -5.0 + i * 2))

        self.nPulse = 5
        self.step = 2.0
        self.nPoints = int(5 * 40 / self.step)
        self.period = int(40 / self.step)

        self.protonCharge = []
        for i in range(self.nPoints):
            self.protonCharge.append(0.0)

        self._renew = -1

    def __del__(self):
        self.outQueue.task_done()

    def process(self, iPulse):
        if iPulse < 0:
            return
        self._renew += 1
        if self._renew < 5:
            self.protonCharge.pop(0)

                # self.protonCharge.append(self.gauss[self._renew]*random.uniform(0.8,1.0))

            self.protonCharge.append(self.gauss[self._renew] * 1.0)
            self._renew += 1
        elif self._renew < self.period:
            self.protonCharge.pop(0)

                # self.protonCharge.append(random.uniform(0.01, 0.1))

            self.protonCharge.append(0.1)
            self._renew += 1
        else:
            self._renew = -1

    def run(self):
        while True:

            # iPulse = self.inQueue.get()
            # self.process(iPulse)

            try:
                self.process(1)
            except:
                break
            self.outQueue.put(self.protonCharge)

            # self.inQueue.task_done()

    def pause(self):
        self.paused = True
        self.pause_cond.acquire()

    def resume(self):
        self.paused = False
        self.pause_cond.notify()
        self.pause_cond.release()


