#!/usr/bin/python
# -*- coding: utf-8 -*-

import numpy as np


class TimeFrameModel:

    def __init__(self):

        # super(TimeFrameCalculation, self).__init__(lambdaMin, lambdaMax)

        self.chopperList = [6.395, 8.359, 9.923]

        self.samplePosition = 12.0

        self.openingAngle = 60.0
        self.bandwidth = self.theta2lambda(25.0, self.openingAngle,
                self.chopperList[0])

        self.openingList = []
        for i in range(len(self.chopperList)):
            self.openingList.append(self.lambda2theta(25.0,
                                    self.bandwidth,
                                    self.chopperList[i]))

        self.npulse = 5
        self.pulseList = []
        for i in range(self.npulse):
            self.pulseList.append(i * 40)

    def TimeFrameCalculation(
        self,
        DC1frequency,
        DC2frequency,
        DC3frequency,
        DC1phase,
        DC2phase,
        DC3phase,
        ):
        _frequency = [DC1frequency, DC2frequency, DC3frequency]
        _phase = [DC1phase, DC2phase, DC3phase]

        timeList = [[], [], []]
        for i in range(3):
            if _frequency[i] == 1.0:
                pass
            elif _frequency[i] == 0.0:
                timeList[i] = [0.0, self.npulse * 40]
            else:
                _close = 0.0
                timeList[i].append(_close)
                _close = _close + _phase[i] / 360.0 * 1000.0 \
                    / _frequency[i]
                timeList[i].append(_close)
                while True:
                    _close = _close + self.openingList[i] / 360.0 \
                        * 1000.0 / _frequency[i]
                    if _close >= self.npulse * 40:
                        timeList[i].append(self.npulse * 40)
                        break
                    else:
                        timeList[i].append(_close)

                    _close = _close + (360 - self.openingList[i]) \
                        / 360.0 * 1000.0 / _frequency[i]
                    if _close >= self.npulse * 40:
                        timeList[i].append(self.npulse * 40)
                        break
                    else:
                        timeList[i].append(_close)

        xList = []
        yList = [0, self.samplePosition]

        _LDC1 = self.chopperList[1]
        _LSAM = self.chopperList[-1]
        for i in range(1, len(timeList[1]) - 1):
            _tmp = _LSAM / _LDC1 * timeList[1][i]

            # for j in range(len(self.pulseList)):

            for j in range(1):
                xList.append([self.pulseList[j], self.pulseList[j]
                             + _tmp])

        return (
            self.pulseList,
            self.chopperList,
            self.samplePosition,
            timeList,
            xList,
            yList,
            )

    def ChopperCalculation(
        self,
        frequency,
        lambdaMin,
        lambdaMax,
        ):
        DC1frequency = frequency
        DC2frequency = frequency
        DC3frequency = frequency

        DC1phase = self.lambda2theta(DC1frequency, lambdaMin,
                self.chopperList[0])
        DC2phase = self.lambda2theta(DC2frequency, lambdaMin,
                self.chopperList[1])
        DC3phase = self.lambda2theta(DC3frequency, lambdaMin,
                self.chopperList[2])
        return (
            DC1frequency,
            DC2frequency,
            DC3frequency,
            DC1phase,
            DC2phase,
            DC3phase,
            )

    def fromWavelength(
        self,
        frequency=25.0,
        lambdaMin=1.0,
        lambdaMax=5.0,
        ):
        if lambdaMax == None:
            lambdaMax = lambdaMin + theta2lambda(frequency,
                    self.openingAngle, self.chopperList[1])
        elif lambdaMin == None:
            lambdaMin = lambdaMax - theta2lambda(frequency,
                    self.openingAngle, self.chopperList[1])

        return (frequency, lambdaMin, lambdaMax)

    def fromChopper(
        self,
        DC1Frequency=25,
        DC1Phase=0.0,
        DC2Frequency=25,
        DC2Phase=0.0,
        DC3Frequency=25,
        DC3Phase=0.0,
        ):
        frequency = DC1Frequency
        lambdaMin = self.theta2lambda(DC1Frequency, DC1Phase,
                self.chopperList[1])
        lambdaMax = lambdaMin + self.theta2lambda(frequency,
                self.openingAngle, self.chopperList[1])

        return (frequency, lambdaMin, lambdaMax)

    def theta2lambda(
        self,
        frequency,
        openingAngle,
        chopperDistance,
        ):
        return openingAngle * (1 / float(frequency)) / 360.0 * 3.9562 \
            / chopperDistance * 1000.0

    def lambda2theta(
        self,
        frequency,
        wavelength,
        chopperDistance,
        ):
        return 360 * chopperDistance * wavelength / 3.9562 / (1
                / float(frequency)) / 1000.0


