#!/usr/bin/python
# -*- coding: utf-8 -*-
import json
from array import *
import sys


def tree(d, level=-1):
    if isinstance(d, dict):
        level += 1
        for k in d:
            _sep = ''
            if not isinstance(k, dict):
                _sep = level * '- '
                print _sep + k
            tree(d[k], level)


def encode(d, parent=None):
    if isinstance(d, dict):
        for (k, v) in d.items():
            if not isinstance(v, dict):
                if k == 'title':
                    d[k] = 'Diffraction Pattern'
                elif k == 'bankname':
                    d[k] = 'Monitor Counter'
                elif k == 'type':
                    if parent == 'xaxis':
                        d[k] = 'F32_List_Bin'
                    elif parent == 'yaxis':
                        d[k] = 'I32_List_Bin'
                elif k == 'unit':
                    if parent == 'xaxis':
                        d[k] = 'mics'
                    elif parent == 'yaxis':
                        d[k] = 'A.U.'
                elif k == 'long_name':
                    if parent == 'xaxis':
                        d[k] = 'TOF'
                    elif parent == 'yaxis':
                        d[k] = 'Intensity'
            else:
                parent = k
            encode(d[k], parent)


def main():
    key_level = {
        'bankname': '',
        'title': '',
        'xaxis': {'type': '', 'long_name': '', 'unit': ''},
        'yaxis': {'type': '', 'long_name': '', 'unit': ''},
        }
    tree(key_level)
    encode(key_level)
    print key_level

    fout = open('key.json', 'w')
    fout.write(json.dumps(key_level))  # sort_keys=True, indent=4)
    fout.close()

    fdata1 = open('./monitor_value.json').read()
    expData = json.loads(fdata1)
    print expData
    for item in range(len(expData)):
        if expData.keys()[item] == 'xaxis':
            xdata = expData[expData.keys()[item]]
        elif expData.keys()[item] == 'yaxis':
            ydata = expData[expData.keys()[item]]
    print xdata, ydata

    sys.exit(0)


if __name__ == '__main__':

    main()
