#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10
'''
import numpy as np
from PyQt4 import QtCore, QtGui
import patternDock
import patternDock1

class CSNSPatternPage(QtGui.QMainWindow):

    def __init__(self, parent):
        super(CSNSPatternPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):
        self.patternDock=[]
        self.patternDock.append(patternDock1.patternDock(self,
                1, 9, 0.4, 'r', 4000, 'Backward Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                2, 9, 0.4, 'g', 3000, 'Medium-Angle Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                3, 9, 0.4, 'b', 2000, 'Low-Angle Bank'))

        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[0])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[1])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[2])
        
        #self.setCentralWidget(self.scrollArea)
        self.pix = []
        for i in range(len(self.patternDock)):
            self.pix.append('') 

    def getPatternCanvas(self, n):
        return self.patternDock[n].getCanvas()
    
    def setStatus(self):
        return self.parent.setStatus()
    
    def getHistogramData(self):
        self.parent.getHistogramData()

    def updateCanvas(self, num, value):#, started, _command): 
        if num == 1:
            self.updateCanvas3(value)
        elif num == 2:
            self.updateCanvas2(value)
        elif num == 3:
            self.updateCanvas1(value)

    def updateCanvas1(self, value):
            can = self.patternDock[0].canvas
            _pause = self.patternDock[0].pauseButton.text()
            if _pause == 'Pause':
                #try:
                if str(value[1]) == 'clear':
                    pass
                elif len(value[0]) != len(value[1]) or len(value[1]) == 0:
                    pass
                else:
                    can.ax.clear()
                    self.pix[0], = can.ax.plot(value[0], value[1], color=can.plotColor)
                    can.ax.add_patch(can.rect)
                    if can.zoomSelected and (can.minX != can.maxX) and (can.minY != can.maxY):
                        can.ax.set_xlim(can.minX, can.maxX)
                        can.ax.set_ylim(can.minY, can.maxY) 
                    index = self.patternDock[0].getIndex()
                    if index == 0:
                        can.ax.set_xlabel('TOF / us')
                    else:
                        can.ax.set_xlabel('d')
                    can.ax.set_ylabel('Neutron Counts')
                    can.ax.relim()
                    can.ax.autoscale_view()
                    can.draw()
                #except:
                #    pass

    def updateCanvas2(self, value):
            can = self.patternDock[1].canvas
            _pause = self.patternDock[1].pauseButton.text()
            if _pause == 'Pause':
                #try:
                if str(value[1]) == 'clear':
                    pass
                elif len(value[0]) != len(value[1]) or len(value[1]) == 0:
                    pass
                else:
                    can.ax.clear()
                    self.pix[1], = can.ax.plot(value[0], value[1], color=can.plotColor)
                    can.ax.add_patch(can.rect)
                    if can.zoomSelected and (can.minX != can.maxX) and (can.minY != can.maxY):
                        can.ax.set_xlim(can.minX, can.maxX)
                        can.ax.set_ylim(can.minY, can.maxY) 
                    index = self.patternDock[1].getIndex()
                    if index == 0:
                        can.ax.set_xlabel('TOF / us')
                    else:
                        can.ax.set_xlabel('d')
                    can.ax.set_ylabel('Neutron Counts')
                    can.ax.relim()
                    can.ax.autoscale_view()
                    can.draw()
                #except:
                #    pass

    def updateCanvas3(self, value):
            can = self.patternDock[2].canvas
            _pause = self.patternDock[2].pauseButton.text()
            if _pause == 'Pause':
                try:
                    if str(value[1]) == 'clear':
                        pass
                    elif len(value[0]) != len(value[1]) or len(value[1]) == 0:
                        pass
                    else:
                        can.ax.clear()
                        self.pix[2], = can.ax.plot(value[0], value[1], color=can.plotColor)
                        can.ax.add_patch(can.rect)
                        if can.zoomSelected and (can.minX != can.maxX) and (can.minY != can.maxY):
                            can.ax.set_xlim(can.minX, can.maxX)
                            can.ax.set_ylim(can.minY, can.maxY) 
                        index = self.patternDock[2].getIndex()
                        if index == 0:
                            can.ax.set_xlabel('TOF / us')
                        else:
                            can.ax.set_xlabel('d')
                        can.ax.set_ylabel('Neutron Counts')
                        can.ax.relim()
                        can.ax.autoscale_view()
                        can.draw()
                except:
                    pass
