#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf.constants import *

from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *
from model.neonReceiver import *


class CSNSImagePage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSImagePage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        self.verticalLayout = QtGui.QHBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.verticalLayout.addWidget(self.scrollArea)
        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 9
        _ysize = 0.8

        # Backward TOF/d
        self.BankComboBox = QtGui.QComboBox()
        self.BankComboBox.addItem('0+1:Backward')
        self.BankComboBox.addItem('0:Left Backward')
        self.BankComboBox.addItem('1:Right Backward')
        self.BankComboBox.addItem('2+3:Medium-angle Bank')
        self.BankComboBox.addItem('2:Left Medium-angle')
        self.BankComboBox.addItem('3:Right Medium-angle')
        self.BankComboBox.addItem('4+5:Low-angle Bank')
        self.BankComboBox.addItem('4:Left Low-angle')
        self.BankComboBox.addItem('5:Right Low-angle')
        self.BankComboBox.activated.connect(self.BankComboboxChoose)

        self.startBankButton = QtGui.QPushButton('Start')
        self.startBankButton.clicked.connect(self.startBank)
        self.resumeBankButton = QtGui.QPushButton('Resume')
        self.resumeBankButton.clicked.connect(self.resumeBank)
        self.resumeBankButton.setEnabled(False)
        
        self.LoadButton = QtGui.QPushButton('Load')
        #self.LoadButton.clicked.connect(self.load_file)
        self.ExportButton = QtGui.QPushButton('Export')
        #self.ExportButton.clicked.connect(self.export_file)

        self.maskListWidget = QtGui.QListWidget(self)

        # self.maskListWidget.setMinimumWidth(70)
        # self.maskListWidget.setMaximumWidth(150)

        for i in range(100):
            _item = QtGui.QListWidgetItem(str(i), self.maskListWidget)

            # _item.setFlags(QtCore.Qt.ItemIsUserCheckable)

            _r = random.random()
            if _r < 0.22:
                _item.setCheckState(QtCore.Qt.Unchecked)
            else:
                _item.setCheckState(QtCore.Qt.Checked)
            self.maskListWidget.addItem(_item)

        self.ImageCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize*3/4,
            150,
            'User-defined Bank',
            'X /mm',
            'Y /mm',
            )

        self.PatternCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize/4,
            150,
            'User-defined Bank',
            'TOF',
            'Neutron Counts',
            )

        _nline = 0
        self.mainGrid.addWidget(self.BankComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startBankButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.resumeBankButton, _nline, 2, 1, 1)
        self.mainGrid.addWidget(self.LoadButton, _nline, 4, 1, 1)
        self.mainGrid.addWidget(self.ExportButton, _nline, 5, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.ImageCanvas, _nline, 0, 1, 4)
        self.mainGrid.addWidget(self.maskListWidget, _nline, 4, 2, 2)
        _nline += 1
        self.mainGrid.addWidget(self.PatternCanvas, _nline, 0, 1, 4)
      
        self.neoni2DID = '/BL01/BANK01/PATTERN'
        self.neoni3DID = '/BL01/BANK01/IMAGE'

        self.streaming = CSNSGlobal()

        self.streamingThread = None

        self.plot2DThread = None
        self.plot3DThread = None

        self.plotScale = [
            1,
            1,
            1,
            ]

        self.plotColor = [
            'Accent',
            'Spectral',
            'cool',
            ]

    def BankComboboxChoose(self):
        index = self.BankComboBox.currentIndex()
    
    def getBankID(self):
        return self.BankComboBox.currentIndex()

    def createStreamingThread(self, sourceID, bankID):
        global CSNSThreadID
        CSNSThreadID += 1

        if sourceID == 2:
            self.streamingThread = diffractionSimulator(
                CSNSThreadID,
                3,
                './dat/gppd.dat',
                './dat/monitor.dat',
                1E6,
                1.0,
                self.streaming,
                )
        elif sourceID == 0:
            self.streamingThread = neonReceiver(
                CSNSThreadID,
                self.getIP(),
                self.getPort(),
                self.neonID[bankID],
                1.0,
                self.streaming,
                )

        self.streamingThread.setDaemon(True)

    def createPlotThread(self, bankID):
        global CSNSThreadID
        CSNSThreadID += 1

        self.plot3DThread = updateStreaming3D(CSNSThreadID,
                self.ImageCanvas, self.ImageCanvas.ax,
                self.plotColor[bankID], self.streaming)

        CSNSThreadID += 1
        self.plot2DThread = updateStreaming2D(
            CSNSThreadID,
            self.PatternCanvas,
            self.PatternCanvas.ax,
            1,
            'r',
            self.streaming,
            )

        self.plot2DThread.setDaemon(True)
        self.plot3DThread.setDaemon(True)

    def startBank(self):
        _bankID = self.getBankID()
        if self.startBankButton.text() == 'Start':
            self.createStreamingThread(self.getSource(), _bankID)
            self.createPlotThread(_bankID)

            self.streamingThread.start()
            self.plot2DThread.start()
            self.plot3DThread.start()

            self.startBankButton.setText('Stop')
            self.resumeBankButton.setText('Pause')
            self.resumeBankButton.setEnabled(True)
        elif self.startBankButton.text() == 'Stop':

            self.plot2DThread.stop()
            self.plot3DThread.stop()
            del self.plot2DThread
            del self.plot3DThread
            self.streamingThread.stop()
            del self.streamingThread

            self.startBankButton.setText('Start')
            self.resumeBankButton.setText('Resume')
            self.resumeBankButton.setEnabled(False)

    def resumeBank(self):
        _bankID = self.getBankID()
        if self.resumeBankButton.text() == 'Resume':
            self.plotThread[_bankID].resume()
            self.resumeBankButton.setText('Pause')
        elif self.resumeBankButton.text() == 'Pause':
            self.plotThread[_bankID].pause()
            self.resumeBankButton.setText('Resume')

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()

    def getSource(self):
        self.sourceID = 2
        return self.sourceID
