#!/usr/bin/python
# -*- coding: utf-8 -*-
import json
from array import *
import sys
import redis


class histogram2D_head:

    def __init__(self, redis_server, bankname):

        # bankname = backward, medium, small
        # axis = xdata, ydata, zdata, cdata

        self.r = redis_server
        self.key = bankname + '_head'
        if self.r.exists(self.key):
            return True
        else:
            return False

    # to be developed with Redis

    def set(
        title,
        bankname,
        xaxis_type,
        xaxis_longname,
        xaxis_unit,
        xdata,
        yaxis_type,
        yaxis_longname,
        yaxis_unit,
        ydata,
        ):
        d_dict = encode_2Dhistogram_head(
            title,
            bankname,
            xaxis_type,
            xaxis_longname,
            xaxis_unit,
            yaxis_type,
            yaxis_longname,
            yaxis_unit,
            )
        d_json = dict2json(d_dict)
        d_str = json2str(d_json)
        self.r.set(self.key, d_str)

    # to be developed with Redis

    def get(self):
        d_str = self.r.get(self.key)
        d_json = str2json(d_str)
        (
            title,
            bankname,
            xaxis_type,
            xaxis_longname,
            xaxis_unit,
            yaxis_type,
            yaxis_longname,
            yaxis_unit,
            ) = decode_2Dhistogram_head(d_json)
        return (
            title,
            bankname,
            xaxis_type,
            xaxis_longname,
            xaxis_unit,
            yaxis_type,
            yaxis_longname,
            yaxis_unit,
            )


class histogram_data:

    def __init__(
        self,
        redis_server,
        bankname,
        axis,
        ):

        # bankname = backward, medium, small
        # axis = xdata, ydata, zdata, cdata

        self.r = redis_server
        self.key = bankname + '_' + axis
        if self.r.exists(self.key):
            return True
        else:
            return False

    # to be developed with Redis

    def set(self, data):
        d_json = encode_histogram_data(data)
        d_str = json2str(d_json)
        self.r.set(self.key, d_str)

    # to be developed with Redis

    def get(self):
        d_str = self.r.get(self.key)
        d_json = str2json(d_str)
        data = decode_histogram_data(d_json)
        return data


def encode_histogram_data(data):
    d_json = array2json(data)
    return d_json


def decode_histogram_data(d_json):
    data = json2array(d_json)
    return data


def tree(d, level=-1):
    if isinstance(d, dict):
        level += 1
        for k in d:
            _sep = ''
            if not isinstance(k, dict):
                _sep = level * '- '
                print _sep + k
            tree(d[k], level)


def encode_2Dhistogram_head(
    title='',
    bankname='',
    xaxis_type='',
    xaxis_longname='',
    xaxis_unit='',
    yaxis_type='',
    yaxis_longname='',
    yaxis_unit='',
    ):
    d = {
        'bankname': '',
        'title': '',
        'xaxis': {'type': '', 'long_name': '', 'unit': ''},
        'yaxis': {'type': '', 'long_name': '', 'unit': ''},
        }

    d['bankname'] = bankname
    d['title'] = title
    d['xaxis']['type'] = xaxis_type
    d['xaxis']['longname'] = xaxis_longname
    d['xaxis']['unit'] = xaxis_unit
    d['yaxis']['type'] = yaxis_type
    d['yaxis']['longname'] = yaxis_longname
    d['yaxis']['unit'] = yaxis_unit

    return d


def decode_2Dhistogram_head(d):
    bankname = d['bankname']
    title = d['title']
    xaxis_type = d['xaxis']['type']
    xaxis_longname = d['xaxis']['longname']
    xaxis_unit = d['xaxis']['unit']
    yaxis_type = d['yaxis']['type']
    yaxis_longname = d['yaxis']['longname']
    yaxis_unit = d['yaxis']['unit']
    return (
        title,
        bankname,
        xaxis_type,
        xaxis_longname,
        xaxis_unit,
        yaxis_type,
        yaxis_longname,
        yaxis_unit,
        )


def dict2json(d_dict):

    # d_json = json.JSONEncoder().encode(d_dict)

    d_json = json.dumps(d_dict)
    return d_json


def str2json(d_str):  # ok
    d_json = json.loads(d_str)
    return d_json


def json2str(d_json):
    d_str = json.dumps(d_json)
    return d_str


def json2array(d_json):
    return


def array2json(d_array):
    return


def main():
    key_level = {
        'bankname': '',
        'title': '',
        'xaxis': {'type': '', 'long_name': '', 'unit': ''},
        'yaxis': {'type': '', 'long_name': '', 'unit': ''},
        }
    tree(key_level)

    # encode(key_level)

    print key_level

    dict2json(key_level)

    fout = open('key.json', 'w')

    # key_level_str=JSONEncoder().encode(key_level)
    # key_level_json=JSONDecoder().decode(key_level_str)

    fout.write(json.dumps(key_level))  # sort_keys=True, indent=4)
    fout.close()

    sys.exit(0)


if __name__ == '__main__':

    main()
