#!/usr/bin/python
# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
import time


class updateProgressBar(QThread):

    procDone = pyqtSignal(bool)
    partDone = pyqtSignal(int)

    def __init__(
        self,
        threadID,
        min,
        max,
        ):
        super(updateProgressBar, self).__init__()
        self.thread_stop = False
        self.threadID = threadID
        self.min = min
        self.max = max

    def run(self):
        for a in range(self.min, self.max):
            self.partDone.emit(float(a) / (self.max - self.min) * 100)
            time.sleep(1)
            if self.thread_stop == True:
                return

        self.procDone.emit(True)

    def stop(self):
        self.thread_stop = True


