#!/usr/bin/python
# -*- coding: utf-8 -*-

import math
import random
from math import atan
from numpy import *
from scipy import pi, log
import numpy as np
import time
import thread
import threading
from scipy.interpolate import interp1d
from scipy.interpolate import InterpolatedUnivariateSpline
from scipy.interpolate import UnivariateSpline
from readData import *
from globalClass import *
from neon.Neon import *


class Hist2D(NeonData.BasedData, object):

    # for python 2.7.x, force the class new-style. there is not this problem in python 3.x

    def __init__(
        self,
        remoteDB_backend,
        name,
        xAxis=None,
        data=None,
        ):
        self.xAxis = xAxis
        staticDic = {'xAxis': self.xAxis}
        super(Hist2D, self).__init__(remoteDB_backend, name, staticDic,
                data)

    def getXAxis(self):
        return self.xAxis

    def setXAxis(self, xAxis):
        self.xAxis = xAxis
        setStatic({'xAxis': self.xAxis})

    def load(self):
        super(Hist2D, self).load()
        staticDic = self.getStatic()
        self.xAxis = staticDic['xAxis']


class neonReceiver(threading.Thread):

    def __init__(
        self,
        threadID,
        ip,
        port,
        bankID,
        freshTime,
        CSNSGlobal,
        ):

        threading.Thread.__init__(self)
        self.paused = False
        self.pause_cond = threading.Condition(threading.Lock())

        self.can_run = threading.Event()
        self.threadID = threadID
        self.bankID = bankID
        self.freshTime = freshTime
        self.histogramOut = CSNSGlobal

        self.neon = NeonRedis(host=ip, port=port, db=0, isWritable=True)
        self.hist2d = Hist2D(self.neon, self.bankID)
        self.hist2d.load()
        self.histogramOut.X = self.hist2d.getXAxis()
        self.histogramOut.Y = self.hist2d.getData()

    def xyzSampling(self):
        pass

    def xySampling(self):
        pass

    def ySampling(self):
        self.hist2d.load()
        self.histogramOut.X = self.hist2d.getXAxis()
        self.histogramOut.Y = self.hist2d.getData()

    def run(self):
        while True:
            try:
                self.ySampling()
            except:
                break

        # time.sleep(self.freshTime)

    def pause(self):
        self.paused = True
        self.pause_cond.acquire()

    def resume(self):
        self.paused = False
        self.pause_cond.notify()
        self.pause_cond.release()

    def stop(self):
        self.paused = True
        self.pause_cond.acquire()
        self.can_run.set()


def isNeonConnector(ip, port):

    try:
        NeonRedis(ip, port, db=0, isWritable=True)
    except:
        return False

    return True


