#!/usr/bin/python
# -*- coding: utf-8 -*-

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

from conf.constants import *
import json

from conf import *

from viewer.mainTab import *
from viewer.subTab import *


class CSNSMainSetInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSMainSetInfo, self).__init__(parent)
        self.parent=parent
        self.setupUi(self)

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.upRightTab = CSNSMainTab(self)
        self.timeProgress = QtGui.QProgressBar(self)
        self.downRightTab = CSNSSubTab(self)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)

        self.splitter.addWidget(self.upRightTab)
        self.splitter.addWidget(self.timeProgress)
        self.splitter.addWidget(self.downRightTab)
        self.splitter.setSizes([800, 30, 30])
        self.verticalLayout.addWidget(self.splitter)

    def setImgPath(self,value):
        self.parent.setImgPath(value)

    def setDataPath(self, kwargs):
        self.parent.setDataPath(kwargs) 

    # time Progress ThreadI
    def createTimeProgress(mini,maxi):
	global CSNSThreadID
        CSNSThreadID += 1
        self.timeProgressThread = updateProgressBar(CSNSThreadID, mini, maxi)
        self.timeProgressThread.partDone.connect(self.updateTimeProgress)
        self.timeProgressThread.procDone.connect(self.fin)
        self.timeProgressThread.start()

    def updateTimeProgress(self, val):
        self.timeProgress.setValue(val)
        perct = '{0}%'.format(val)

    def fin(self):
        pass

    # diffraction pattern
    def getPatternCanvas(self, n):
        return self.upRightTab.getPatternCanvas()

    # monitor Counts
    def getMonitorImageCanvas(self, n):    
        return self.upRightTab.getMonitorImageCanvas(n)

    def getMonitorPatternCanvas(self, n):
        return self.upRightTab.getMonitorPatternCanvas(n)

    # experiment Progress
    def getProtonCanvas(self):
        return self.upRightTab.getProtonCanvas()

    def getNeutronCanvas(self):
        return self.upRightTab.getNeutronCanvas()

    def getPulseCanvas(self):
        return self.upRightTab.getPulseCanvas()

