#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2015.9.25
'''

from conf.constants import *
import json
from json import *
import atexit
import redis

# user defined

from viewer.user import *
import warnings

# from viewer.runData import *

from viewer.menuBar import *
from viewer.statusBar import *

from viewer.mainSet import *

from model import neonReceiver
from viewer import logWindow

class mywindow(QtGui.QMainWindow):

    def __init__(self, parent):
        super(mywindow, self).__init__()
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, MainWindow):

        self.myMenuBar = menuBar(self)
        self.setMenuBar(self.myMenuBar)

        self.myStatusBar = statusBar(self)
        self.setStatusBar(self.myStatusBar)

        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)

        self.userWidget = CSNSUserInfo(self)  # .mainSplitter)
        self.mainSetWidget = CSNSMainSetInfo(self)  # .mainSplitter)

        self.mainSplitter.addWidget(self.userWidget)  # leftSplitter)
        self.mainSplitter.addWidget(self.mainSetWidget)  # rightSplitter)

        self.setCentralWidget(self.mainSplitter)
        self.loadConfigure()
        self.setConfigure()

        self.myStatus = 'waiting'
        self.myCommand = 'start'

    # self.updateNeutronCounts()

    def updateDiffractionSimulator(self):
        self.upRightTab.updateDiffractionSimulator()

    def updateDataStreaming(self):
        self.upRightTab.updateDataStreaming()

    def updateProton(self, threadID):
        self.upRightTab.updateProton(threadID)

    # update Neutron Counts
    def updateNeutronCounts(self):
        ip = '10.1.53.240'
        port = 9000
        try:
            print '   NEON Starting...'
            r = redis.Redis(host=ip, port=port, db=0)
        except:
            print 'ERROR: Neon server not available.\n'
            sys.exit()

        neonpathx = '/GPPD/workspace/data/bank01/fit/axis_x_1'
        neonpathy = '/GPPD/workspace/data/bank01/fit/axis_y_1'
        neonpathz = '/GPPD/workspace/data/bank01/fit/value_2'
        neonpathc = '/GPPD/workspace/data/bank01/event'

        datasetThread = neonReceiver.dataGet(
            1,
            r,
            2,
            neonpathx,
            neonpathy,
            neonpathz,
            neonpathc,
            self.getCountsText(),
            self.getImageCanvas(),
            )
        datasetThread.setDaemon(True)
        datasetThread.start()
        time.sleep(0.01)

    # diffraction pattern
    def getPatternCanvas(self, n):
        return self.mainSetWidget.getPatternCanvas(n)

    # monitor Counts
    def getMonitorImageCanvas(self, n):
        return self.mainSetWidget.getMonitorImageCanvas(n)

    def getMonitorPatternCanvas(self, n):
        return self.mainSetWidget.getMonitorPatternCanvas(n)

    # experiment Progress
    def getProtonCanvas(self):
        return self.mainSetWidget.getProtonCanvas()

    def getNeutronCanvas(self):
        return self.mainSetWidget.getNeutronCanvas()

    def getPulseCanvas(self):
        return self.mainSetWidget.getPulseCanvas()

    def createTimeProgress(self, mini, maxi):
	return self.mainSetWidget.createTimeProgress(mini,maxi)

    # user info
    # Proton Charge Text
    def getChargeText(self):
        return self.userWidget.getChargeText()

    # Neutron Counts
    def getCountsText(self):
        return self.userWidget.getCountsText()

    def getUserIDText(self):
        return self.userWidget.getUserIDText()

    def getProposalText(self):
        return self.userWidget.getProposalText()

    def setCommandValueLabel(self, value):
        return self.userWidget.setCommandValueLabel(value)

    def getCommandTimeLabel(self):
        return self.userWidget.getCommandTimeLabel()

    def getStatusValueLabel(self):
        return self.userWidget.getStatusValueLabel()

    def getStatusTimeLabel(self):
        return self.userWidget.getStatusTimeLabel()

    def getIP(self):
        _ip=None
        try:
	        _ip=self.userWidget.getIP()
        except:
            _ip=None
        return _ip

    def getPort(self):
        _port=None
        try:
	        _port=self.userWidget.getPort()
        except:
	        _port=None
        return _port


    def getDisplay(self):
        screen_resolution = self.parent.desktop().screenGeometry()
        return screen_resolution.width(), screen_resolution.height()

    def loadConfigure(self):
        _confFile='./conf/configure.json'
        _mainWidth, _mainHeight=self.getDisplay()

        if not os.path.exists(_confFile):
            self.mainWidth=_mainWidth
            self.mainHeight=_mainHeight
            self.firstLayout=1
            self.ip="10.1.53.240"
            self.port=9000
            self.mainSplitterLeft=(self.mainWidth + 50) / 7.0
            self.mainSplitterRight=self.mainWidth / 7.0 * 6
        else:
            try:
                layoutParameter = json.loads(open(_confFile, "r").read())
                self.firstLayout= layoutParameter['firstLayout']
                self.mainWidth=layoutParameter['mainWidth']
                self.mainHeight=layoutParameter['mainHeight']
                self.ip=layoutParameter['ip']
                self.port=layoutParameter['port']
                self.mainSplitterLeft=layoutParameter['mainSplitterLeft']
                self.mainSplitterRight=layoutParameter['mainSplitterRight']
            except:
                self.mainWidth=_mainWidth
                self.mainHeight=_mainHeight
                self.firstLayout=1
                self.ip="10.1.53.240"
                self.port=9000

    def setConfigure(self):
        self.resize(self.mainWidth, self.mainHeight)
        self.mainSplitter.setSizes([self.mainSplitterLeft,self.mainSplitterRight])

    def saveConfigure(self):
        _mainWidth=self.mainSplitter.geometry().width()
        _mainHeight=self.mainSplitter.geometry().height()
        _firstLayout=self.firstLayout+1
        _ip=self.userWidget.getIP()
        _port=self.userWidget.getPort()
        _mainSplitterLeft=self.mainSplitter.sizes()[0]
        _mainSplitterRight=self.mainSplitter.sizes()[1]

        _data = {"mainWidth": _mainWidth, "firstLayout": _firstLayout, "mainHeight": _mainHeight, "mainSplitterLeft":_mainSplitterLeft,"mainSplitterRight":_mainSplitterRight, "ip":_ip, "port":_port }
        
        _confFile='./conf/configure.json'
        if not os.path.exists(_confFile):
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
        else:
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)

    def setNeonButton(self, value):
	    self.userWidget.setNeonButton(value)
 
    def getNeon(self):
	    self.neonStatus, self.neonServer=self.userWidget.getNeon()
	    return self.neonStatus, self.neonServer
  
    def getStatus(self):
    	return self.myStatus

    def setHeartBeat(self):
    	neonpath="/GPPD/heartbeat/pilot"
    	#mylog=conf.constants.mytop.getLogGui() 
    	#mylog.logWrite("Creating heartbeat thread")

    	logging.info("Creating heartbeat thread")
    	heartbeatThread = neonReceiver.setHeartbeat(self.neonServer, 1.0, neonpath, self.getStatus())
    	#heartbeatThread.finished.connect(conf.constants.myapp.exit)
    	logging.info("Starting heartbeat thread")
    	heartbeatThread.setDaemon(True)
    	heartbeatThread.start()
    	logging.info("Start heartbeat successfully")

    def getApp(self):
        return self.parent

    def getCommandButton(self):
        return self.userWidget.hostButton

    def getCommand(self, parent, gui):
        logging.info("Creating Command Thread...")
        self.commandThread = neonReceiver.getCommand(parent, gui)
        logging.info("Start Command Thread successfully")

    @QtCore.pyqtSlot(str)
    def setCommand(self, value):
        self.myCommand=value
        self.setCommandValueLabel(self.myCommand)

    @QtCore.pyqtSlot(str)
    def setLog(self, value):
        logging.info(value)
   
    def getCanvasData(self, parent, gui):
        logging.info("Creating Canvas data Thread...")
      
        self.protonPath='/GPPD/workspace/protoncharge'
        self.neutronPath='/GPPD/workspace/neutroncounts'
                
        self.dataThread = neonReceiver.dataWorker(parent, gui, self.neonServer, self.protonPath, self.neutronPath, 1.0)
                
        logging.info("Start Canvas Data Thread successfully")
 
    def setImgPath(self,value):
        self.dataThread.setImgPath(value)

    def setDataPath(self, kwargs):
        self.dataThread.setDataPath(kwargs)

    @QtCore.pyqtSlot(object)
    def setCanvasData(self, value):
        tabIndex = self.dataThread.getTabIndex()
        if tabIndex == 0:
            self.mainSetWidget.upRightTab.histogramPage.updateCanvas(value)            
        elif tabIndex == 1:
            self.mainSetWidget.upRightTab.detectorPage.updateBankCanvas(value)
        elif tabIndex == 2:
            self.mainSetWidget.upRightTab.monitorPage.updateCanvas(value)            
        elif tabIndex == 3:    
            self.mainSetWidget.upRightTab.experimentPage.updateCanvas(value)            

    @QtCore.pyqtSlot(object)
    def setProtonCanvas(self, value):
        self.mainSetWidget.upRightTab.experimentPage.setProtonCanvas(value)

    @QtCore.pyqtSlot(object)
    def setNeutronCanvas(self, value):
        can = self.getNeutronCanvas()
        can.ax.clear()
        can.ax.plot(value[0], value[1])#, color=self.color)

        can.ax.relim()
        can.ax.autoscale_view()
        can.draw()

    @QtCore.pyqtSlot(object)
    def setBankCanvas(self, _img):
        self.mainSetWidget.upRightTab.detectorPage.updateBankCanvas(_img)

def exit_handler(top):
    top.saveConfigure()

if __name__ == '__main__':
    
    myapp = QtGui.QApplication(sys.argv)
    
    mytop = mywindow(myapp)
    icon = QtGui.QIcon('img/logo.jpg')
    mytop.setWindowIcon(icon)
    mytop.setWindowTitle('GPPD')

    mytop.show()
    time.sleep(0.1)

    # connect neon
    _neonStatus, _neonServer = mytop.getNeon()
    mytop.setNeonButton(_neonStatus)

    # set heartbeat
    if _neonStatus:
        mytop.setHeartBeat()
        mytop.getCommand(myapp, mytop)
        #mytop.getProtonData(myapp, mytop)
        mytop.getCanvasData(myapp, mytop)
        #mytop.getBankData(myapp, mytop)
        
    #myapp.exec_()

    atexit.register(exit_handler, mytop)
    sys.exit(myapp.exec_())
