#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2017.05.15

Detector
'''

from conf.constants import *

# user defined

from model.readData import *
from canvas import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *
import time

class CSNSDetectorPage(QtGui.QTabWidget):#QMainWindow):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

    # self.CSNSTOF1DetectorDock = CSNSDetectorDock(self , '/BL01/BANK01/IMAGE', 1, 'Accent', '0+1:Backward')
    # self.CSNSTOF2DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fit', 1, 'gist_rainbow', '0+1:Backward')
    # self.CSNSXY1DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fxy', 1, 'Spectral', '0+1:Backward')
    # self.CSNSXY2DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fxy', 1, 'cool', '0+1:Backward')

    # self.addDockWidget(QtCore.Qt.TopDockWidgetArea, self.CSNSTOF1DetectorDock)
    # self.addDockWidget(QtCore.Qt.TopDockWidgetArea, self.CSNSTOF2DetectorDock)
    # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea, self.CSNSXY1DetectorDock)
    # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea, self.CSNSXY2DetectorDock)

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([100, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
	
        #first Grid
        _width = 20
        _height = 20
        self.bank01 = BankButton(self,'img/bank1_blue.png', _width+30, _height+30)
        self.bank02 = BankButton(self,'img/bank2_blue.png', _width+30, _height+30)
        self.bank03 = BankButton(self,'img/bank3_blue.png', _width+45, _height)
        self.bank04 = BankButton(self,'img/bank4_blue.png', _width+45, _height)
        self.bank05 = BankButton(self,'img/bank5_blue.png', _width, _height+40)
        self.bank06 = BankButton(self,'img/bank6_blue.png', _width, _height+40)
       
        self.camera = BankButton(self,'img/camera.png', _width, _height)
        self.sample = BankButton(self,'img/sample.png', _width, _height)
        self.monitor = BankButton(self,'img/monitor.png', _width, _height)
	
        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.bank01)
        self.RadioGroup.addButton(self.bank02)
        self.RadioGroup.addButton(self.bank03)
        self.RadioGroup.addButton(self.bank04)
        self.RadioGroup.addButton(self.bank05)
        self.RadioGroup.addButton(self.bank06)
        self.RadioGroup.buttonClicked.connect(self.bankClicked)

        self.blank1 = QtGui.QLabel("                               ---------------------------------------------->", self.first)
        self.blank1.setMinimumWidth(500)
        self.blank2 = QtGui.QLabel(self.first)
        self.blank2.setMinimumWidth(500)
	
        #second Grid
        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('PID')
        self.bankCombo.addItem('XY')
        self.bankCombo.activated.connect(self.bankComboSelected)

        _xsize = 3.2
        _ysize = 2.0
        self.BankCanvas = blankCanvas(
            self,
            _xsize,
            _ysize,
            72,
            )
	    
        _nline = 0
        self.firstGrid.addWidget(self.bank03, _nline, 3, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.bank05, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.bank01, _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.monitor, _nline, 1, 1,1)
        self.firstGrid.addWidget(self.sample, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.camera, _nline, 5, 1,1)
        self.firstGrid.addWidget(self.blank1, _nline, 0, 1,1)
        self.firstGrid.addWidget(self.blank2, _nline, 6, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.bank06, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.bank02, _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.bank04, _nline, 3, 1,1)
	
        _nline += 1
        self.secondGrid.addWidget(self.bankCombo, _nline, 1, 1,1)
        _nline += 1
        self.secondGrid.addWidget(self.BankCanvas, _nline, 0, 1,1)

        self.verticalLayout.addWidget(self.splitter)
        
        self.bankIndex = 0
        self.comboIndex = 0    
        self.imgPath = None

    def bankComboSelected(self):
        comboIndex = self.getComboIndex()
        bankIndex = self.getBankIndex()
        if comboIndex == 0:
            self.imgPath="/GPPD/workspace/MantidData/bank"+str(bankIndex).zfill(2)+"/pid_image"
        elif comboIndex == 1:
            self.imgPath="/GPPD/workspace/MantidData/bank"+str(bankIndex).zfill(2)+"/xy_image"
        else:
            self.imgPath=None
     
        self.parent.tabChange()

    def getComboIndex(self):
        self.comboIndex = self.bankCombo.currentIndex()    
        return self.comboIndex    

    def getBankIndex(self):
        return self.bankIndex

    def getImgPath(self):
        return self.imgPath

    def bankClicked(self):
        bankIndex = self.bankIndex
        comboIndex = self.getComboIndex()
        if self.bank01.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_yellow.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
            bankIndex=1
        elif self.bank02.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_yellow.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
            bankIndex=2
        elif self.bank03.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_yellow.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
            bankIndex=3
        elif self.bank04.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_yellow.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
            bankIndex=4
        elif self.bank05.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_yellow.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
            bankIndex=5
        elif self.bank06.isChecked():
            self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
            self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
            self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
            self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
            self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
            self.bank06.setIcon(QtGui.QIcon('img/bank6_yellow.png'))
            bankIndex=6

        if comboIndex == 0:
            self.imgPath="/GPPD/workspace/MantidData/bank"+str(bankIndex).zfill(2)+"/pid_image"
        elif comboIndex == 1:
            self.imgPath="/GPPD/workspace/MantidData/bank"+str(bankIndex).zfill(2)+"/xy_image"
        else:
            self.imgPath=None
        
        self.parent.tabChange()
        self.bankIndex = bankIndex

    def updateBankCanvas(self, img):
        try:
            self.BankCanvas.ax.imshow(img)
            self.BankCanvas.draw()
        except:
            pass

class BankButton(QtGui.QPushButton):

    def __init__(
        self,
        parent=None,
        img='',
        width=100,
        height=100,
        ):
        super(BankButton,self).__init__(parent)
	
        #self.img = img
        #self.width = width
        #self.height = height
	
        self.setFlat(True)
        self.setStyleSheet("border:none;outline:none")
        self.setIcon(QtGui.QIcon(img))
        self.setIconSize(QtCore.QSize(width,height))
        #self.resize(self.width,self.height)
        self.setCheckable(True)
