#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Monitor

'''
import numpy as np
from PyQt4 import QtCore, QtGui
import monitorDock

class CSNSMonitorPage(QtGui.QMainWindow):  # QTabWidget):

    def __init__(self, parent):
        super(CSNSMonitorPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        self.monitorDock = []
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK01/PATTERN',
            '/BL01/BANK01/IMAGE',
            9,
            0.8,
            'y',
            'Blues',
            'Incident Monitor 1',
            ))
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK03/PATTERN',
            '/BL01/BANK03/IMAGE',
            9,
            0.8,
            'c',
            'Oranges',
            'Incident Monitor 2',
            ))
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK05/PATTERN',
            '/BL01/BANK05/IMAGE',
            9,
            0.8,
            'm',
            'Greens',
            'Transmit Monitor',
            ))

        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[0])
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[1])
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[2])
        self.pix1 = []
        self.pix2 = []
        for i in range(len(self.monitorDock)):
            self.pix1.append('')
            self.pix2.append('')
        
    def setStatus(self):
        return self.parent.setStatus()

    def getComboIndex(self):
        _index = []
        for i in range(len(self.monitorDock)):
            _index.append(self.monitorDock[i].getComboIndex())
        return _index
    
    def getMonitorData(self):
        self.parent.getMonitorData()

    def clearCanvas(self):
        for i in range(len(self.monitorDock)):
            self.monitorDock[i].imageCanvas.ax.clear()
            self.monitorDock[i].imageCanvas.draw()
            self.monitorDock[i].patternCanvas.ax.clear()
            self.monitorDock[i].patternCanvas.draw()

    def updateCanvas(self, num, value):#, started, _command):
        i = 0
        _pause = None
        index = self.getComboIndex()
        for i in range(len(self.monitorDock)):
            canvas1 = self.monitorDock[i].imageCanvas
            canvas2 = self.monitorDock[i].patternCanvas
            _pause = self.monitorDock[i].pauseButton.text()
            if _pause == 'Pause':
                try:
                    if str(value[2][i]) == 'clear':
                        canvas1.ax.clear()
                        canvas1.draw()
                    elif len(value[2][i]) == 0:
                        pass
                    else:
                        #if not self.pix1[i]:
                        canvas1.ax.clear()
                        self.pix1[i] = canvas1.ax.pcolormesh(value[0][i], value[1][i], value[2][i], cmap=canvas1.plotColor)
                        canvas1.ax.add_patch(canvas1.rect)
                        canvas1.ax.set_xlabel('X / mm') 
                        canvas1.ax.set_ylabel('Y / mm') 
                        canvas1.ax.set_aspect('equal')
                        #else:
                        #    self.pix1[i].set_array(np.array(value[2][i]).ravel())
                            #self.pix1[i].set_array(np.array(value[2][i])[:-1,:-1].ravel())
                        if canvas1.zoomSelected and (canvas1.minX != canvas1.maxX) and (canvas1.minY != canvas1.maxY):
                            canvas1.ax.set_xlim(canvas1.minX, canvas1.maxX)
                            canvas1.ax.set_ylim(canvas1.minY, canvas1.maxY)
                        elif canvas1.scale_factor != 1.0:
                            canvas1.ax.set_xlim([canvas1.xdata - canvas1.new_width * (1-canvas1.relx), canvas1.xdata + canvas1.new_width * (canvas1.relx)])
                            canvas1.ax.set_ylim([canvas1.ydata - canvas1.new_height * (1-canvas1.rely), canvas1.ydata + canvas1.new_height * (canvas1.rely)])
                        canvas1.draw()
                except:
                    self.pix1[i] = None
                try:
                    if str(value[3][i]) == 'clear' or str(value[4][i]) == 'clear':
                        canvas2.ax.clear()
                        canvas2.draw()
                    elif len(value[3][i]) != len(value[4][i]) or  len(value[4][i]) == 0:
                        pass
                    else:
                        #if not self.pix2[i]:
                        canvas2.ax.clear()
                        self.pix2[i], = canvas2.ax.plot(value[3][i], value[4][i], color=canvas2.plotColor)
                        canvas2.ax.add_patch(canvas2.rect)
                        canvas2.ax.set_ylabel('Neutron Counts'
)
                        if index[i] == 0:
                            canvas2.ax.set_xlabel('TOF / us')
                        else:
                            canvas2.ax.set_xlabel('Wavelength')
                        #else:
                        #    self.pix2[i].set_ydata(value[4][i])
                        if canvas2.zoomSelected and (canvas2.minX != canvas2.maxX) and (canvas2.minY != canvas2.maxY):
                            canvas2.ax.set_xlim(canvas2.minX, canvas2.maxX)
                            canvas2.ax.set_ylim(canvas2.minY, canvas2.maxY)
                        elif canvas2.scale_factor != 1.0:
                            canvas2.ax.set_xlim([canvas2.xdata - canvas2.new_width * (1-canvas2.relx), canvas2.xdata + canvas2.new_width * (canvas2.relx)])
                            canvas2.ax.set_ylim([canvas2.ydata - canvas2.new_height * (1-canvas2.rely), canvas2.ydata + canvas2.new_height * (canvas2.rely)])
                        canvas2.ax.relim()
                        canvas2.ax.autoscale_view()
                        canvas2.draw()
                except:
                    self.pix2[i] = None
