#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from chopper import *
from sample import *
from calibration import *
from reduction import *
from experiment import *
from histogram import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent=None):
        super(CSNSMainTab, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.chopperPage = CSNSChopperPage()
        self.samplePage = CSNSSamplePage()
        self.experimentPage = CSNSExperimentPage()
        self.histogramPage = CSNSHistogramPage()
        self.calibrationPage = CSNSCalibrationPage()
        self.reductionPage = CSNSReductionPage()

        self.addTab(self.chopperPage, 'Chopper')
        self.addTab(self.samplePage, 'Sample')
        self.addTab(self.experimentPage, 'Experiment')
        self.addTab(self.histogramPage, 'Histogram')
        self.addTab(self.calibrationPage, 'Calibration')
        self.addTab(self.reductionPage, 'Reduction')

    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        return self.histogramPage.updateBackwardStreaming(threadID,
                simulatorStreaming)

    def updateMediumStreaming(self, threadID, simulatorStreaming):
        return self.histogramPage.updateMediumStreaming(threadID,
                simulatorStreaming)

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        return self.histogramPage.updateSmallStreaming(threadID,
                simulatorStreaming)

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        return self.histogramPage.updateMonitorStreaming(threadID,
                simulatorStreaming)

    def updateBackward3DStreaming(self, threadID, simulatorStreaming):
        return self.histogramPage.updateBackward3DStreaming(threadID,
                simulatorStreaming)

    def updateMedium3DStreaming(self, threadID, simulatorStreaming):
        return self.histogramPage.updateMedium3DStreaming(threadID,
                simulatorStreaming)

    def updateSmall3DStreaming(self, threadID, simulatorStreaming):
        return self.histogramPage.updateSmall3DStreaming(threadID,
                simulatorStreaming)
