#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *


class CSNSHistogramPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSHistogramPage, self).__init__(parent)
        self.setupUi(self)
        self.BackwardConstant = 40000
        self.MediumConstant = 30000
        self.SmallConstant = 20000

        self.simulatorStreaming = CSNSGlobal()

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        self.verticalLayout = QtGui.QHBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)
        # main  grid

        #self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.first)#.mainGridWidget)
        
        #histogramWidth=self.mainGridWidget.geometry().width()
        #histogramHeight=self.mainGridWidget.geometry().height()
        #print histogramWidth,histogramHeight
        _xsize = 6
        _ysize = 0.8
        #_xsize = histogramWidth
        #_ysize = histogramHeight/5

        # Backward TOF/d

        self.BackwardComboBox = QtGui.QComboBox(self.first)
        self.BackwardComboBox.addItem('TOF')
        self.BackwardComboBox.addItem('d')
        self.BackwardComboBox.activated.connect(self.BackwardComboboxChoose)
        self.BackwardButton = QtGui.QPushButton('Pause',self.first) 
        self.BackwardButton.clicked.connect(self.BackwardButtonClicked)

        self.BackwardCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )
        self.BackwardCanvas.setParent(self.first)

        # 90-Bank TOF/d

        self.MediumComboBox = QtGui.QComboBox(self.first)
        self.MediumComboBox.addItem('TOF')
        self.MediumComboBox.addItem('d')
        self.MediumComboBox.activated.connect(self.MediumComboboxChoose)
        self.MediumButton = QtGui.QPushButton('Pause',self.first) 
        self.MediumButton.clicked.connect(self.MediumButtonClicked)

        self.MediumCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )
        self.MediumCanvas.setParent(self.first)

        # Small-angle bank TOF/d

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('TOF')
        self.SmallComboBox.addItem('d')
        self.SmallComboBox.activated.connect(self.SmallComboboxChoose)
        self.SmallButton = QtGui.QPushButton('Pause') 
        self.SmallButton.clicked.connect(self.SmallButtonClicked)
        
        self.SmallCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Monitor TOF/d

        self.MonitorCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Backward bank 3D

        self.Backward3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Medium bank 3D

        self.Medium3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small bank 3D

        self.Small3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        _nline = 0
        self.mainGrid.addWidget(self.BackwardComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.BackwardButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.BackwardCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MediumComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.MediumButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.MediumCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.SmallComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.SmallButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.SmallCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MonitorCanvas, _nline, 0, 1, 2)
        self.mainGrid.addWidget(self.Backward3DCanvas, _nline, 2, 1, 2)
        self.mainGrid.addWidget(self.Medium3DCanvas, _nline, 4, 1, 2)
        self.mainGrid.addWidget(self.Small3DCanvas, _nline, 6, 1, 2)

        self.enablePauseButton(False)

        self.verticalLayout.addWidget(self.scrollArea)

    def BackwardComboboxChoose(self):
        index = self.BackwardComboBox.currentIndex()
        if index == 0:
            BackwardConstant = 40000    
        elif index == 1:
            BackwardConstant = 1
        self.BackwardThread.setUnit(BackwardConstant)

    def MediumComboboxChoose(self):
        index = self.MediumComboBox.currentIndex()
        if index == 0:
            MediumConstant = 30000       
        elif index == 1:
            MediumConstant = 1
        self.MediumThread.setUnit(MediumConstant)

    def SmallComboboxChoose(self):
        index = self.SmallComboBox.currentIndex()
        if index == 0:
            SmallConstant = 20000       
        elif index == 1:
            SmallConstant = 1
        self.SmallThread.setUnit(SmallConstant)
     
    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        self.BackwardThread = updateStreaming2D(threadID, self.BackwardCanvas, 
                self.BackwardCanvas.ax, CSNSBackwardConstant , 'r', 
                    simulatorStreaming)
        self.BackwardThread.setDaemon(True)
        self.BackwardThread.start()

    def updateMediumStreaming(self, threadID, simulatorStreaming):
        self.MediumThread = updateStreaming2D(threadID, self.MediumCanvas,
                self.MediumCanvas.ax,CSNSMediumConstant, 'g', simulatorStreaming)
        self.MediumThread.setDaemon(True)
        self.MediumThread.start()

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        self.SmallThread = updateStreaming2D(threadID, self.SmallCanvas,
                self.SmallCanvas.ax, CSNSSmallConstant,'b', simulatorStreaming)
        self.SmallThread.setDaemon(True)
        self.SmallThread.start()

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        MonitorThread = updateStreamingMonitor(threadID,
                self.MonitorCanvas, self.MonitorCanvas.ax, 'y',
                simulatorStreaming)
        MonitorThread.setDaemon(True)
        MonitorThread.start()
    
    def updateBackward3DStreaming(self, threadID, simulatorStreaming):
        Backward3DThread = updateStreaming3D(threadID,
                self.Backward3DCanvas, self.Backward3DCanvas.ax,
                'Accent', simulatorStreaming)
        Backward3DThread.setDaemon(True)
        Backward3DThread.start()

    def updateMedium3DStreaming(self, threadID, simulatorStreaming):
        Medium3DThread = updateStreaming3D(threadID,
                self.Medium3DCanvas, self.Medium3DCanvas.ax, 'Spectral'
                , simulatorStreaming)
        Medium3DThread.setDaemon(True)
        Medium3DThread.start()

    def updateSmall3DStreaming(self, threadID, simulatorStreaming):
        Small3DThread = updateStreaming3D(threadID, self.Small3DCanvas,
                self.Small3DCanvas.ax, 'cool', simulatorStreaming)
        Small3DThread.setDaemon(True)
        Small3DThread.start()

    def BackwardButtonClicked(self):
        if self.BackwardButton.text()=="Pause":
            self.BackwardButton.setText("Resume")     
            
            self.BackwardThread.pause()

        elif self.BackwardButton.text()=="Resume":
            self.BackwardButton.setText("Pause")     
            
            self.BackwardThread.resume()
    
    def MediumButtonClicked(self):
        if self.MediumButton.text()=="Pause":
            self.MediumButton.setText("Resume")
            
            self.MediumThread.pause()
        
        elif self.MediumButton.text()=="Resume":
            self.MediumButton.setText("Pause")
            
            self.MediumThread.resume()     

    def SmallButtonClicked(self):
        if self.SmallButton.text()=="Resume":
            self.SmallButton.setText("Pause")     

            self.SmallThread.pause()

        elif self.SmallButton.text()=="Pause":
            self.SmallButton.setText("Resume")     
            
            self.SmallThread.resume() 

    def enablePauseButton(self, enable):
        self.BackwardButton.setEnabled(enable)    
        self.MediumButton.setEnabled(enable)    
        self.SmallButton.setEnabled(enable)

    def putPulse(self):
        self.simulatorStreaming = CSNSGlobal()

        global CSNSThreadID
        CSNSThreadID += 1

        self.putThread = diffractionSimulator(
            CSNSThreadID,
            3,
            './dat/gppd.dat',
            './dat/monitor.dat',
            1E6,
            1.0,
            self.simulatorStreaming,
            )
        self.putThread.setDaemon(True)
        self.putThread.start()

    def getPulse(self):
        global CSNSThreadID

        CSNSThreadID += 1
        self.updateBackwardStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateMediumStreaming(CSNSThreadID,
                self.simulatorStreaming)

        CSNSThreadID += 1
        self.updateSmallStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateMonitorStreaming(CSNSThreadID,
                self.simulatorStreaming)
    
        CSNSThreadID += 1
        self.updateBackward3DStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateMedium3DStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateSmall3DStreaming(CSNSThreadID,
                self.simulatorStreaming)

    def startDiffractionSimulator(self):
        self.putPulse()
        #yield
        self.getPulse()
        self.enablePauseButton(True)
