#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2016.12.12

Image

'''

from conf.constants import *

from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *
from model.neonReceiver import *
from model import neonReceiver


class monitorDock(QtGui.QDockWidget):

    def __init__(
        self,
        parent,
        neon2DID,
        neon3DID,
        width,
        height,
        plotScale,
        plotColor,
        title,
        ):
        super(monitorDock, self).__init__(parent)
        self.parent = parent

        self.neon2DID = neon2DID
        self.neon3DID = neon3DID

        self.width = width
        self.height = height
        self.plotColor = plotColor
        self.plotScale = plotScale
        self.title = title

        self.setupUi(self)

    def setupUi(self, Widget):
        self.setFeatures(QtGui.QDockWidget.DockWidgetFloatable
                         | QtGui.QDockWidget.DockWidgetMovable)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        # _xsize = 9
        # _ysize = 0.8

        # Backward TOF/d

        self.pauseButton = QtGui.QPushButton('Pause')
        self.pauseButton.setEnabled(False)
        self.pauseButton.setFixedSize(QtCore.QSize(60, 20))
        self.pauseButton.clicked.connect(self.clickPauseBank)

        self.imageCanvas = CSNSCanvas(
            self,
            self.width,
            self.height,
            150,
            'Monitor 1',
            'X /mm',
            'Y /mm',
            )

        self.patternCanvas = CSNSCanvas(
            self,
            self.width,
            self.height,
            150,
            'Monitor 1',
            'TOF',
            'Neutron Counts',
            )

        self.label = QtGui.QLabel(self.title)

        _nline = 0
        self.mainGrid.addWidget(
            self.pauseButton,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.label, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.imageCanvas, _nline, 0, 1, 3)
        _nline += 1
        self.mainGrid.addWidget(self.patternCanvas, _nline, 0, 1, 3)

        self.setWidget(self.scrollArea)

         # self.setCentralWidget(self)

    def getImageCanvas(self):
        return self.imageCanvas

    def getPatternCanvas(self):
        return self.patternCanvas

    def clickPauseBank(self):
        if self.pauseButton.text() == 'Pause':
            self.pauseButton.setText('Resume')
        elif self.pauseButton.text() == 'Resume':

            self.pauseButton.setText('Pause')

    def enablePauseBank(self, enable):
        self.pauseButton.setEnabled(enable)


