#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from PyQt4 import QtCore, QtGui
import monitorDock


class CSNSMonitorPage(QtGui.QMainWindow):  # QTabWidget):

    def __init__(self, parent):
        super(CSNSMonitorPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        # self.setTabPosition(QTabWidget.West)

        self.monitorDock = []
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK01/PATTERN',
            '/BL01/BANK01/IMAGE',
            9,
            0.8,
            1,
            'Accent',
            'Incident Monitor 1',
            ))
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK03/PATTERN',
            '/BL01/BANK03/IMAGE',
            9,
            0.8,
            1,
            'Spectral',
            'Incident Monitor 2',
            ))
        self.monitorDock.append(monitorDock.monitorDock(
            self,
            '/BL01/BANK05/PATTERN',
            '/BL01/BANK05/IMAGE',
            9,
            0.8,
            1,
            'cool',
            'Transmit Monitor',
            ))

        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[0])
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[1])
        self.addDockWidget(QtCore.Qt.BottomDockWidgetArea,
                           self.monitorDock[2])

    def getMonitorImageCanvas(self, n):
	return self.monitorDock[n].getImageCanvas()

    def getMonitorPatternCanvas(self, n):
	return self.monitorDock[n].getPatternCanvas()
