#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2016.12.12

Histogram

'''

from conf.constants import *

from canvas import *
from model.readData import *

# from model.readImage import *

from presenter.updateStreaming import *
from model.neonReceiver import *


class histogramDock(QtGui.QDockWidget):  # QTabWidget):

    def __init__(
        self,
        parent,
        width,
        height,
        plotColor,
        plotScale,
        title,
        ):
        super(histogramDock, self).__init__(parent)

        self.width=width
        self.height=height
        self.plotColor = plotColor
        self.plotScale = plotScale
        self.title = title

        self.streaming = CSNSGlobal()
        self.streamingThread = None
        self.plotThread = None

        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        # self.setTabPosition(QTabWidget.West)

        self.setFeatures(QtGui.QDockWidget.DockWidgetFloatable
                         | QtGui.QDockWidget.DockWidgetMovable)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        # Backward TOF/d
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('TOF')
        self.comboBox.addItem('d')
        self.comboBox.addItem('Q')
        self.comboBox.activated.connect(self.comboboxChoose)
        self.comboBox.setFixedSize(QtCore.QSize(60, 20))

        self.resumeButton = QtGui.QPushButton('Pause')
        self.resumeButton.setEnabled(False)
        self.resumeButton.setFixedSize(QtCore.QSize(60, 20))    
        self.resumeButton.clicked.connect(self.resumeButtonClicked)

        self.saveButton = QtGui.QPushButton('Save')
        self.saveButton.setEnabled(False)
        self.saveButton.setFixedSize(QtCore.QSize(60, 20))

        self.canvas = CSNSCanvas(
            self,
            self.width,
            self.height,
            150,
            self.title,
            'TOF /mics',
            'Neutron Counts',
            )

        self.label = QtGui.QLabel(self.title)

        _nline = 0
        self.mainGrid.addWidget(self.comboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.resumeButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.saveButton, _nline, 2, 1, 1)
        self.mainGrid.addWidget(self.label, _nline, 4, 1, 2)
        _nline += 1
        self.mainGrid.addWidget(
            self.canvas,
            _nline,
            0,
            1,
            5,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1

        self.setWidget(self.scrollArea)

        # self.setCentralWidget(self)

    def comboboxChoose(self):
        index = self.comboBox.currentIndex()
        if index == 0:
            _scale = self.plotScale
        elif index == 1:
            _scale = 1

        try:
            self.plotThread.setUnit(_scale)
        except:
            pass

    def resumeButtonClicked(self):
        if self.resumeButton.text() == 'Resume':
            self.resumeButton.setText('Pause')
        elif self.resumeButton.text() == 'Pause':
            self.resumeButton.setText('Resume')

    def getCanvas(self):
	return self.canvas
