#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2017.05.15

Detector
'''

from conf.constants import *

# user defined

from model.readData import *
from canvas import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *
import random

from detectorDock import *


class CSNSDetectorPage(QtGui.QTabWidget):#QMainWindow):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

    # self.CSNSTOF1DetectorDock = CSNSDetectorDock(self , '/BL01/BANK01/IMAGE', 1, 'Accent', '0+1:Backward')
    # self.CSNSTOF2DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fit', 1, 'gist_rainbow', '0+1:Backward')
    # self.CSNSXY1DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fxy', 1, 'Spectral', '0+1:Backward')
    # self.CSNSXY2DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fxy', 1, 'cool', '0+1:Backward')

    # self.addDockWidget(QtCore.Qt.TopDockWidgetArea, self.CSNSTOF1DetectorDock)
    # self.addDockWidget(QtCore.Qt.TopDockWidgetArea, self.CSNSTOF2DetectorDock)
    # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea, self.CSNSXY1DetectorDock)
    # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea, self.CSNSXY2DetectorDock)

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

	self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
	self.splitter.setSizes([100, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
	
	#first Grid
	_width = 20
	_height = 20
	self.bank01 = QtGui.QPushButton('')
	self.bank01.setFlat(True)	
	self.bank01.setStyleSheet("border:none;outline:none")
	self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
	self.bank01.setIconSize(QtCore.QSize(_width+30, _height+30))
	#self.bank01.resize(_width, _height)
	self.bank01.setCheckable(True)
	#self.bank01 = BankButton('img/bank1_blue.png',100,100)
	
	self.bank02 = QtGui.QPushButton('')
	self.bank02.setFlat(True)	
	self.bank02.setStyleSheet(";border:none;outline:none")
	self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
	self.bank02.setIconSize(QtCore.QSize(_width+30, _height+30))
	#self.bank02.resize(_width, _height)
	self.bank02.setCheckable(True)
	
	self.bank03 = QtGui.QPushButton('')
	self.bank03.setFlat(True)	
	self.bank03.setStyleSheet("border:none;outline:none")
	self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
	self.bank03.setIconSize(QtCore.QSize(_width+45, _height))
	#self.bank03.resize(_height+50, _width)
	self.bank03.setCheckable(True)
	
	self.bank04 = QtGui.QPushButton('')
	self.bank04.setFlat(True)	
	self.bank04.setStyleSheet("border:none;outline:none")
	self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
	self.bank04.setIconSize(QtCore.QSize(_width+45, _height))
	#self.bank04.resize(_height+50, _width)
	self.bank04.setCheckable(True)
	
	self.bank05 = QtGui.QPushButton('')
	self.bank05.setFlat(True)	
	self.bank05.setStyleSheet("border:none;outline:none")
	self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
	self.bank05.setIconSize(QtCore.QSize(_width, _height+45))
	#self.bank05.resize(_width, _height)
	self.bank05.setCheckable(True)
	
	self.bank06 = QtGui.QPushButton('')
	self.bank06.setFlat(True)	
	self.bank06.setStyleSheet("border:none;outline:none")
	self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
	self.bank06.setIconSize(QtCore.QSize(_width, _height+45))
	#self.bank06.resize(_width, _height)
	self.bank06.setCheckable(True)
	
	self.camera = QtGui.QPushButton('')
	self.camera.setFlat(True)	
	self.camera.setStyleSheet("border:none;outline:none")
	self.camera.setIcon(QtGui.QIcon('img/camera.png'))
	#self.camera.setIconSize(QtCore.QSize(_width+85, _height))
	#self.camera.resize(_width, _height)
	self.sample = QtGui.QPushButton('')
	self.sample.setFlat(True)	
	self.sample.setStyleSheet("border:none;outline:none")
	self.sample.setIcon(QtGui.QIcon('img/sample.png'))
	#self.sample.setIconSize(QtCore.QSize(_width+85, _height))
	#self.sample.resize(_width, _height)
	self.monitor = QtGui.QPushButton('')
	self.monitor.setFlat(True)	
	self.monitor.setStyleSheet("border:none;outline:none")
	self.monitor.setIcon(QtGui.QIcon('img/monitor.png'))
	#self.monitor.setIconSize(QtCore.QSize(_width+85, _height))
	#self.monitor.resize(_width, _height)

	self.blank1 = QtGui.QLabel("                               -------------------------------------------------------------->", self.first)
	self.blank1.setMinimumWidth(500)
	self.blank2 = QtGui.QLabel(self.first)
	self.blank2.setMinimumWidth(500)
	
	#second Grid
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('PID')
        self.comboBox.addItem('XY')
        # self.comboBox.activated.connect(self.comboboxChoose)

	_xsize = 3
        _ysize = 0.5	
	self.BankCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            '',
            '',
            '',
            )
	
	_nline = 0
	self.firstGrid.addWidget(self.bank03, _nline, 3, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.bank05, _nline, 2, 1,1)
	self.firstGrid.addWidget(self.bank01, _nline, 4, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.monitor, _nline, 1, 1,1)
	self.firstGrid.addWidget(self.sample, _nline, 3, 1,1)
	self.firstGrid.addWidget(self.camera, _nline, 5, 1,1)
	self.firstGrid.addWidget(self.blank1, _nline, 0, 1,1)
	self.firstGrid.addWidget(self.blank2, _nline, 6, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.bank06, _nline, 2, 1,1)
	self.firstGrid.addWidget(self.bank02, _nline, 4, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.bank04, _nline, 3, 1,1)
	
	_nline += 1
	self.secondGrid.addWidget(self.comboBox, _nline, 1, 1,1)
	_nline += 1
	self.secondGrid.addWidget(self.BankCanvas, _nline, 0, 1,1)

	self.verticalLayout.addWidget(self.splitter)

	self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.bank01)
        self.RadioGroup.addButton(self.bank02)
        self.RadioGroup.addButton(self.bank03)
        self.RadioGroup.addButton(self.bank04)
        self.RadioGroup.addButton(self.bank05)
        self.RadioGroup.addButton(self.bank06)
	self.RadioGroup.buttonClicked.connect(self.bankClicked)

    def bankClicked(self):
	if self.bank01.isChecked():
	    self.bank01.setIcon(QtGui.QIcon('img/bank1_yellow.png'))
	    self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
	    self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
	    self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
	    self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
	    self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
	elif self.bank02.isChecked():
	    self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
	    self.bank02.setIcon(QtGui.QIcon('img/bank2_yellow.png'))
	    self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
	    self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
	    self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
	    self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
	elif self.bank03.isChecked():
	    self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
	    self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
	    self.bank03.setIcon(QtGui.QIcon('img/bank3_yellow.png'))
	    self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
	    self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
	    self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
	elif self.bank04.isChecked():
	    self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
	    self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
	    self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
	    self.bank04.setIcon(QtGui.QIcon('img/bank4_yellow.png'))
	    self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
	    self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
	elif self.bank05.isChecked():
	    self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
	    self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
	    self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
	    self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
	    self.bank05.setIcon(QtGui.QIcon('img/bank5_yellow.png'))
	    self.bank06.setIcon(QtGui.QIcon('img/bank6_blue.png'))
	elif self.bank06.isChecked():
	    self.bank01.setIcon(QtGui.QIcon('img/bank1_blue.png'))
	    self.bank02.setIcon(QtGui.QIcon('img/bank2_blue.png'))
	    self.bank03.setIcon(QtGui.QIcon('img/bank3_blue.png'))
	    self.bank04.setIcon(QtGui.QIcon('img/bank4_blue.png'))
	    self.bank05.setIcon(QtGui.QIcon('img/bank5_blue.png'))
	    self.bank06.setIcon(QtGui.QIcon('img/bank6_yellow.png'))

    def getBankCanvas(self):
	return self.BankCanvas

class BankButton(QtGui.QPushButton):

    def __init__(
	self,
	parent=None,
	img='',
	width=100,
	height=100,
	):
	super(BankButton,self).__init__(parent)
	self.setupUi(self)
	
	self.img = img
	self.width = width
	self.height = height

    def setupUi(self,QPushButton):
	
        self.setFlat(True)
        self.setStyleSheet("border:none;outline:none")
        self.setIcon(QtGui.QIcon(self.img))
        self.setIconSize(QtCore.QSize(self.width,self.height))
        self.resize(self.width,self.height)
